//******************************************************************************
// FILE LIBRARY: MAIN                                                         **
//                                                                            **
// Copyright 1997 Adept Software, All Rights Reserved                         **
//******************************************************************************

#ifndef FIL_MAIN_H
	#define FIL_MAIN_H

	#include "Adept.H"
	#ifndef WINDOWS
		#include <fcntl.h>
	#endif

//**************************************
// GLOBAL CONSTANTS

	#define FIL_POS_END			-1

	typedef struct
	{
		#ifdef WINDOWS
		HANDLE	Handle;
		dword	OpenFlags;
			#define FIL_OPENNORMAL		OPEN_EXISTING
			#define FIL_OPENOVERWRITE	(CREATE_NEW|CREATE_ALWAYS)
			#define FIL_OPENORCREATE	OPEN_ALWAYS
			#define FIL_OPENCREATENEW	CREATE_NEW
		dword	Access;
			#define FIL_READONLY		GENERIC_READ
			#define FIL_WRITEONLY		GENERIC_WRITE
			#define FIL_READWRITE		(GENERIC_READ|GENERIC_WRITE)
		dword	Attribs;
			#define FIL_A_NORMAL		FILE_ATTRIBUTE_NORMAL
			#define FIL_A_READONLY		FILE_ATTRIBUTE_READONLY
			#define FIL_A_HIDDEN		FILE_ATTRIBUTE_HIDDEN
			#define FIL_A_SYSTEM		FILE_ATTRIBUTE_SYSTEM
			#define FIL_A_ARCHIVE		FILE_ATTRIBUTE_ARCHIVE
		#else
		int		Handle;
		byte	OpenFlags;
			#define FIL_OPENNORMAL		1
			#define FIL_OPENOVERWRITE	2
			#define FIL_OPENORCREATE	4
			#define FIL_OPENCREATENEW	8
		byte	Access;
			#define FIL_READONLY		O_RDONLY
			#define FIL_WRITEONLY		O_WRONLY
			#define FIL_READWRITE		O_RDWR
		byte	Attribs;
			#define FIL_A_NORMAL		_A_NORMAL
			#define FIL_A_READONLY		_A_RDONLY
			#define FIL_A_HIDDEN		_A_HIDDEN
			#define FIL_A_SYSTEM		_A_SYSTEM
			#define FIL_A_VOLUMEID		_A_VOLID
			#define FIL_A_SUBDIR		_A_SUBDIR
			#define FIL_A_ARCHIVE		_A_ARCH
		#endif
		byte	Filename[_MAX_PATH+1];
		sdword	SetPos,CurPos;	// do not modify curpos
	} FIL_HANDLE;

//**************************************
// GLOBAL VARIABLES

	#undef GLOBAL
	#ifdef FIL_MAIN_C
		#define GLOBAL
		GLOBAL	dword	FIL_BufferSize=4096;
	#else
		#define GLOBAL	extern
		GLOBAL	dword	FIL_BufferSize;
	#endif

//**************************************
// GLOBAL ROUTINES

	void	FIL_Open		(byte *Filename,dword OpenFlags,dword Access,FIL_HANDLE *Handle);
	void	FIL_Close		(FIL_HANDLE *Handle);

	dword	FIL_Read		(FIL_HANDLE *Handle, void *Buffer,dword Size);
	void	FIL_ReadExact	(FIL_HANDLE *Handle, void *Buffer,dword Size);
	void	*FIL_AllocRead	(FIL_HANDLE *Handle, dword Size);
	dword	FIL_Write		(FIL_HANDLE *Handle, void *Buffer,dword Size);
	dword	FIL_SizeGet		(FIL_HANDLE *Handle);

	void	FIL_Copy		(byte *SourceFile,byte *DestFile,flag Overwrite);
	void	FIL_Rename		(byte *Filename,byte *NewName);
	void	FIL_Delete		(byte *Filename);
	dword	FIL_AttrGet		(byte *Filename);
	void	FIL_AttrSet		(byte *Filename,dword Attr);
	dword	FIL_Load		(byte *Filename,void *Buffer,dword MaxSize);
	void	*FIL_AllocLoad	(byte *Filename,dword *SizePtr);
	void	FIL_Save		(byte *Filename,void *Buffer,dword Size, flag Overwrite);

	void	FIL_InsertData	(FIL_HANDLE *Handle, void *Buffer,dword Size);
	void	FIL_DeleteData	(FIL_HANDLE *Handle, dword Size);

#endif
