/* sprite.h
 * 1997/12/27
 * (c)Cipher AKA Jeff Weeks of Code X
 *
 * Contains functions to support a simple sprite system.
 */

#ifndef __cx_sprite__
#define __cx_sprite__

#include "petal.h"
#include "pcx.h"

// tiny note for clarity: Sprites in my sprite system are not just simple
// pictures but animations of many simple pictures, hence the distintion
// between images and sprites.

class Sprite {
  public:
    Image *bg;                // the background for the sprites
    Image *screen;            // the actual screen that sprites are drawn to
    Pcx *image;               // the individual images of the sprites
    int **data;               // contains sprite data (animation sequences)
    int num_images;           // the number of images
    int num_sprites;          // the number of sprites
    int *fps;                 // the number of frames per sprite (fps :)
    int *current;             // the current frame of the sprite
    char *status;             // 1 is on, 0 if not.
    int *sx, *sy;             // the x and y locations of the sprite
    int *lx, *ly;             // the last x and y locations (dirty rectangle)

  public:
    Sprite(int maxx = petal.display.width, int maxy = petal.display.height);
    ~Sprite(void);

    void load(char *fname);
    void on(int num);
    void off(int num);
    void set_pos(int num, int x, int y);
    void get_pos(int num, int *x, int *y);
    void update(int tx = 0, int ty = 0);
};

#endif
