/* pcx.cc
 * 1997/12/27
 * (c)Cipher AKA Jeff Weeks of Code X
 *
 * Contains functions to import PCX files into Images
 */

#ifndef __petal_pcx__
#define __petal_pcx__

#include <stdio.h>

#include "petal.h"

#define NO_ERROR             0
#define FILE_ERROR           1
#define MEMORY_ERROR         2
#define TOO_MANY_ARGUMENTS   3

// PCX header structure
typedef struct  {
  char id;                      /* manufacturer's id (always 0xa0)  */
  char ver;                     /* PCX version                      */
  char encoding;                /* compression method (always 1)    */
  char bitsPerPixel;            /* the # of bits per pixel          */
  short xMin, yMin;             /* image start                      */
  short xMax, yMax;             /* image size                       */
  short hRes;                   /* horizontal resolution            */
  short vRes;                   /* vertical reoslution              */
  char palette16[48];           /* 16 color pallette               
                                    (not used with 256 color)       */
  char reserved;                /* not used                         */
  char colorPlanes;             /* # of color planes                */
  short bytesPerLine;           /* # of bytes per line              */
  short paletteType;            /* pallete type (grey or color)     */
  char filler[58];              /* not used                         */
} PcxHeader;

// The PETAL PCX class...
class Pcx {
  public:
    PcxHeader header;
    rgb palette[256];
    Image *img;
    FILE *file;
    int height, width;
    long imageSize;
    unsigned char filename[80];

    Pcx(void);
    Pcx(char *filename);
    ~Pcx(void);
    int  load(char *filename);
    void readline(char *buffer, int bytes);
    void loadimage(void);
    int  loadheader(void);
    void loadpalette(void);
};

#endif
