'$INCLUDE: 'pcrobots.bi'

DEFINT A-Z

TYPE RegType
    AX    as INTEGER
    BX    as INTEGER
    CX    as INTEGER
    DX    as INTEGER
    BP    as INTEGER
    SI    as INTEGER
    DI    as INTEGER
    FLAGS as INTEGER
end TYPE

TYPE RegTypeX
    AX    as INTEGER
    BX    as INTEGER
    CX    as INTEGER
    DX    as INTEGER
    BP    as INTEGER
    SI    as INTEGER
    DI    as INTEGER
    FLAGS as INTEGER
    DS    as INTEGER
    ES    as INTEGER
end TYPE

DECLARE sub Interrupt (intnum, inreg as RegType, outreg as RegType)

DECLARE sub InterruptX (intnum, inreg as RegTypeX, outreg as RegTypeX)

DECLARE function MakeLong&(byval LoByte, byval HiByte)
DECLARE sub SplitLong(byval Value&, LoByte, HiByte)

dim shared CRC as long

sub seedrand (seed as long)
    CRC = seed
end sub

function rand (limit as integer)
    dim flip as INTEGER
    dim i as INTEGER
    CRC = CRC XOR time
    FOR i = 1 TO 37
      flip = CRC AND 1
      IF CRC < 0 THEN
        CRC = ((CRC \ 2) XOR &H80000000) - flip
      ELSE
        CRC = CRC \ 2
      end IF
      IF flip THEN
        CRC = CRC XOR &H965A78E1
      end IF
    NEXT
    rand = CRC mod limit
end function

function MakeLong&(byval LoByte, byval HiByte)
    dim Result as Long
    dim Temp1 as Long
    dim Temp2 as Long
    Temp1 = LoByte
    Temp2 = HiByte
    Result = (Temp1 AND &H7FFF) + (Temp2 AND &H7FFF) * &H10000
    IF Temp1 AND &H8000 THEN Result = (Result OR &H8000)
    IF Temp2 AND &H8000 THEN Result = (Result OR &H80000000)
    MakeLong = Result
end function

sub SplitLong(byval Value&, LoByte, HiByte)
    LoByte = (Value& AND &H7FFF)
    HiByte = (Value& AND &H7FFF0000) \ &H10000
    IF Value& AND &H8000 THEN LoByte = LoByte OR &H8000
    IF Value& AND &H80000000 THEN HiByte = HiByte OR &H8000
end sub

sub SwapTask
    dim Regs as RegType

    Regs.AX = 0

    Interrupt &HE0, Regs, Regs
end sub

sub Movement(byval Fast, byval Angle)
    dim Regs as RegType

    Regs.AX = 1
    Regs.BX = Fast
    Regs.CX = Angle

    Interrupt &HE0, Regs, Regs
end sub

function Scan(byval Angle, byval Res, Range)
    dim Regs as RegType

    Regs.AX = 2
    Regs.BX = Angle
    Regs.CX = Res

    Interrupt &HE0, Regs, Regs

    Range = Regs.BX
    Scan  = Regs.AX
end function

function Shoot(byval Angle, byval Range)
    dim Regs as RegType

    Regs.AX = 3
    Regs.BX = Angle
    Regs.CX = Range

    Interrupt &HE0, Regs, Regs

    Shoot = Regs.AX
end function

sub GetXY(X, Y)
    dim Regs as RegType

    Regs.AX = &H10

    Interrupt &HE0, Regs, Regs

    X = Regs.BX
    Y = Regs.CX
end sub

function Transmit(byval Target, byval Message)
    dim Regs as RegType

    Regs.AX = &H11
    Regs.BX = Target
    Regs.CX = Message

    Interrupt &HE0, Regs, Regs

    Transmit = Regs.AX
end function

function Receive(Source, Message)
    dim Regs as RegType

    Regs.AX = &H12

    Interrupt &HE0, Regs, Regs

    Message = Regs.CX
    Source  = Regs.BX
    Receive = Regs.AX
end function

function Damage
    dim Regs as RegType

    Regs.AX = &H13

    Interrupt &HE0, Regs, Regs

    Damage = Regs.BX
end function


function Speed
    dim Regs as RegType

    Regs.AX = &H14

    Interrupt &HE0, Regs, Regs

    Speed = Regs.BX
end function


function Battery
    dim Regs as RegType

    Regs.AX = &H15

    Interrupt &HE0, Regs, Regs

    Battery = Regs.BX
end function

function Ticks&
    dim Regs as RegType

    Regs.AX = &H16

    Interrupt &HE0, Regs, Regs

    Ticks = MakeLong(Regs.CX, Regs.BX)
end function

function lSin&(byval Angle)
    dim Regs as RegType

    Regs.AX = &H17
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lSin = MakeLong(Regs.CX, Regs.BX)
end function


function lCos&(byval Angle)
    dim Regs as RegType

    Regs.AX = &H18
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lCos = MakeLong(Regs.CX, Regs.BX)
end function


function lTan&(byval Angle)
    dim Regs as RegType

    Regs.AX = &H19
    Regs.BX = Angle

    Interrupt &HE0, Regs, Regs

    lTan = MakeLong(Regs.CX, Regs.BX)
end function

function lAtan(byval Ratio&)
    dim Regs as RegType

    Regs.AX = &H1A

    SplitLong Ratio&, Regs.CX, Regs.BX

    Interrupt &HE0, Regs, Regs

    lAtan = Regs.AX
end function

function lSqrt&(byval Value&)
    dim Regs as RegType

    Regs.AX = &H1b
    SplitLong Value&, Regs.CX, Regs.BX

    Interrupt &HE0, Regs, Regs

    lSqrt = MakeLong(Regs.CX, Regs.BX)
end function


sub SetPattern(Buffer$)
    IF len(Buffer$)=5 THEN
        dim Regs as RegType

        Regs.AX = &H1C
        Regs.BX = sseg(Buffer$)
        Regs.CX = sadd(Buffer$)

        Interrupt &HE0, Regs, Regs
    endIF
end sub


sub DebugFlag(byval Flag, byval Set)
    dim Regs as RegType

    Regs.AX = &H1D
    Regs.BX = Flag
    Regs.CX = Set

    Interrupt &HE0, Regs, Regs
end sub


sub BuyArmour(byval ArmourUnits)
    dim Regs as RegType

    Regs.AX = &H1E
    Regs.BX = ArmourUnits

    Interrupt &HE0, Regs, Regs
end sub


sub BuyShells(byval Shells)
    dim Regs as RegType

    Regs.AX = &H1F
    Regs.BX = Shells

    Interrupt &HE0, Regs, Regs
end sub


function ShellsLeft
    dim Regs as RegType

    Regs.AX = &H20

    Interrupt &HE0, Regs, Regs

    ShellsLeft = Regs.BX
end function


sub GetLocalMap(Buffer$)
    dim Regs as RegType

    Buffer$ = string$(81, 0)

    Regs.AX = &H21
    Regs.BX = sseg(Buffer$)
    Regs.CX = sadd(Buffer$)

    Interrupt &HE0, Regs, Regs
end sub


sub Invisibility(byval InvisFlag)
    dim Regs as RegType

    Regs.AX = &H22
    Regs.BX = InvisFlag

    Interrupt &HE0, Regs, Regs
end sub


function GetShellStatus
    dim Regs as RegType

    Regs.AX = &H23

    Interrupt &HE0, Regs, Regs

    GetShellStatus = Regs.BX
end function


function IsInvisible
    dim Regs as RegType

    Regs.AX = &H24

    Interrupt &HE0, Regs, Regs

    IsInvisible = Regs.BX
end function


function lAtan2(byval Y, byval X)
    dim Regs as RegType

    Regs.AX = &H25
    Regs.BX = Y
    Regs.CX = X

    Interrupt &HE0, Regs, Regs

    lAtan2 = Regs.AX
end function

function GetRobotId
    dim Regs as RegType

    Regs.AX = &H26

    Interrupt &HE0, Regs, Regs

    GetRobotId = Regs.AX
end function

sub RegisterIFF (IFFname$)
    dim Regs as RegType
    dim Temp as string

    Temp = IFFname$ + chr$(0)

    Regs.AX = &H27
    Regs.BX = sseg(Temp)
    Regs.CX = sadd(Temp)

    Interrupt &HE0, Regs, Regs
end sub

function CheckIFF (byval Id)
    dim Regs as RegType

    Regs.AX = &H28
    Regs.BX = Id

    Interrupt &HE0, Regs, Regs

    CheckIFF = Regs.AX
end function

sub RegisterName (rName$)
    dim Regs as RegType
    dim Temp as string

    Temp = rName$ + chr$(0)

    Regs.AX = &H29
    Regs.BX = sseg(Temp)
    Regs.CX = sadd(Temp)

    Interrupt &HE0, Regs, Regs
end sub

function FindName (byval StartId, Name$)
    dim Regs as RegType
    dim Temp as string

    Temp = Name$ + chr$(0)

    Regs.AX = &H2A
    Regs.BX = sseg(Temp)
    Regs.CX = sadd(Temp)
    Regs.DX = StartId

    Interrupt &HE0, Regs, Regs

    FindName = Regs.AX
end function

function GetTeamId
    dim Regs as RegType

    Regs.AX = &H2B

    Interrupt &HE0, Regs, Regs

    GetTeamId = Regs.AX
end function

function Configure(byval Fast, byval Manouevre, byval Range, byval Armour, byval AcceleRation, byval Invisible)
    dim Regs as RegType

    Regs.AX = &H80
    Regs.BX = (Fast AND &H7) + (Manouevre AND &H7) * 8 + (Range AND &H7) * 256 + (Armour AND &H7) * 4096
    Regs.CX = (AcceleRation AND &H7) + (Invisible AND &H1) * 8

    Interrupt &HE0, Regs, Regs

    Configure = Regs.AX
end function
