{ Written by RUSSELL DITTMAR 70624.564@compuserve.com
  With some later additions by Paul Smith in an attempt to keep
  it up to date}

unit PCRobots;
 
interface
 
const
          Arena_Free = 0;
          Arena_Wall = 1;
          Arena_Damage = 3;
          Arena_Refuel = 30;
          Shell_Missed=0;
          Shell_Hit_Wall=1;
          Shell_Close_Blast=2;
          Shell_Near_Miss=3;
          Shell_Direct_Hit=4;
          Shell_Not_Known=5;
          Shell_In_Flight=6;
 
type      Pattern_buffer=array[0..5] of shortint;
          Patbuf_ptr=^Pattern_buffer;
          Map_buffer=array[0..8,0..8] of shortint;
          Mapbuf_ptr=^Map_buffer;
          Int_ptr=^Integer;
 
procedure Swaptask;
procedure Movement(speed,angle:integer);
function  Scan(angle,res:integer;var range:integer):integer;
function  Shoot(angle,range:integer):integer;
procedure Getxy(var x,y:integer);
function  Transmit(target,data:integer):integer;
function  Receive(var source,data:integer):integer;
function  Damage:integer;
function  Speed:integer;
function  Battery:integer;
function  Ticks:longint;
function  L_Sin(angle:integer):longint;
function  L_Cos(angle:integer):longint;
function  L_Tan(angle:integer):longint;
function  L_Atan(ratio:longint):integer;
function  L_Sqrt(value:longint):longint;
procedure Set_Pattern(Buffer:Patbuf_ptr);
procedure Debug_Flag(flag,setflag:integer);
procedure Buy_Armour(armour_units:integer);
procedure Buy_Shells(shells:word);
function  Shells_Left:integer;
procedure Get_Local_Map(pntr:MapBuf_ptr);
procedure Invisibility(invis_flag:integer);
function  Get_Shell_Status:integer;
function  IsInvisible:integer;
function  L_Atan2(y,x:integer):integer;
function Get_Robot_Id:integer;
function Check_Iff(Id:integer):integer;
function Get_Team_Id:integer;
function Get_AShell_Status(ShellId:integer):integer;
function Register_X(X:Int_ptr):integer;
function Register_Y(Y:Int_ptr):integer;
function Configure(speed,manouevre,range,armour,acceleration,invisibility:integer):integer;
 
implementation
 
uses DOS;
 
Const IntAddr = $E0;
 
procedure Swaptask; assembler;
asm
  mov  ax, 0
  int  IntAddr
end;
 
procedure Movement(speed,angle:integer); Assembler;
asm
  mov  ax, 1
  mov  bx, Speed
  mov  cx, Angle
  int  IntAddr
end;
 
function Scan(angle,res:integer;var range:integer):integer; Assembler;
asm
  mov  ax, 2
  mov  bx, angle
  mov  cx, res
  int  IntAddr
  mov  cx, bx
  les  bx, Range
  mov  es:[bx], cx
end;
 
function Shoot(angle,range:integer):integer; Assembler;
asm
  mov  ax, 3
  mov  bx, angle
  mov  cx, range
  int  IntAddr
end;
 
procedure Getxy(var x,y:integer); Assembler;
asm
  mov  ax, $10
  int  IntAddr
  mov  dx, bx
  les  bx, x
  mov  es:[bx], dx
  les  bx, y
  mov  es:[bx], cx
end;
 
function Transmit(target,data:integer):integer; assembler;
asm
  mov  ax, $11
  mov  bx, target
  mov  cx, data
  int  IntAddr
end;
 
function Receive(var source,data:integer):integer; Assembler;
asm
  mov  ax, $12
  int  IntAddr
  mov  dx, bx
  les  bx, Source
  mov  es:[bx], dx
  les  bx, Data
  mov  es:[bx], cx
end;
 
function  Damage:integer; Assembler;
asm
  mov  ax, $13
  int  IntAddr
  mov  ax, bx
end;
 
function  Speed:integer; Assembler;
asm
  mov  ax, $14
  int  IntAddr
  mov  ax, bx
end;
 
function  Battery:integer; Assembler;
asm
  mov  ax, $15
  int  IntAddr
  mov  ax, bx
end;
 
function  Ticks:longint; Assembler;
asm
  mov  ax, $16
  int  IntAddr
  mov  dx, bx
  mov  ax, cx
end;
 
function  L_Sin(angle:integer):longint; Assembler;
asm
  mov  ax, $17
  mov  bx, angle
  int  IntAddr
  mov  dx, bx
  mov  ax, cx
end;
 
function  L_Cos(angle:integer):longint; Assembler;
asm
  mov  ax, $18
  mov  bx, angle
  int  IntAddr
  mov  dx, bx
  mov  ax, cx
end;
 
function  L_Tan(angle:integer):longint; Assembler;
asm
  mov  ax, $19
  mov  bx, angle
  int  IntAddr
  mov  dx, bx
  mov  ax, cx
end;
 
function  L_Atan(ratio:longint):integer; Assembler;
asm
  mov  ax, $1a
  mov  bx, Word(Ratio +2)
  mov  cx, Word(ratio)
  int  IntAddr
end;
 
function  L_Sqrt(value:longint):longint; Assembler;
asm
  mov  ax, $1b
  mov  bx, Word (value +2)
  mov  cx, Word (value)
  int  IntAddr
  mov  dx, bx
  mov  ax, cx
end;
 
procedure Set_Pattern(Buffer:Patbuf_ptr); Assembler;
asm
  mov  ax, $1c
  mov  bx, Word (Buffer +2)
  mov  cx, Word (Buffer)
  int  IntAddr
end;
 
procedure Debug_Flag(flag,setflag:integer); Assembler;
asm
  mov  ax, $1d
  mov  bx, flag
  mov  cx, setflag
  int  IntAddr
end;
 
procedure Buy_Armour(armour_units:integer); Assembler;
asm
  mov  ax, $1e
  mov  bx, armour_units
  int  IntAddr
end;
 
procedure Buy_Shells(shells:word); Assembler;
asm
  mov  ax, $1f
  mov  bx, shells
  int  IntAddr
end;
 
function  Shells_Left:integer; Assembler;
asm
  mov  ax, $20
  int  IntAddr
  mov  ax, bx
end;
 
procedure Get_Local_Map(pntr:MapBuf_ptr); Assembler;
asm
  mov  ax, $21
  mov  bx, word (pntr +2)
  mov  cx, word (pntr)
  int  IntAddr
end;
 
procedure Invisibility(invis_flag:integer); Assembler;
asm
  mov  ax, $22
  mov  bx, invis_flag
  int  IntAddr
end;
 
function Get_Shell_Status:integer; Assembler;
asm
  mov  ax, $23
  int  IntAddr
  mov  ax, bx
end;
 
function IsInvisible:integer; Assembler;
asm
  mov  ax, $24
  int  IntAddr
  mov  ax, bx
end;
 
function L_Atan2(y,x:integer):integer; Assembler;
asm
  mov  ax, $25
  mov  bx, y
  mov  cx, x
  int  IntAddr
end;

function Get_Robot_Id:integer;Assembler;
asm
 mov ax,$25
 int IntAddr
end;

function Check_Iff(Id:integer):integer;Assembler;
asm
 mov ax,$28
 mov bx,Id
 int IntAddr
end;

function Get_Team_Id:integer;Assembler;
asm
 mov ax,$2b
 int IntAddr
end;

function Get_AShell_Status(ShellId:integer):integer;Assembler;
asm
 mov ax,$2c
 mov bx,ShellId
 int IntAddr
end;

function Register_X(X:Int_ptr):integer;Assembler;
asm
  mov  ax,$2d
  mov  bx, word (X+2)
  mov  cx, word (X)
  int  IntAddr
end;

function Register_Y(Y:Int_ptr):integer;Assembler;
asm
  mov  ax,$2e
  mov  bx, word (Y+2)
  mov  cx, word (Y)
  int  IntAddr
end;

function Configure(speed,manouevre,range,armour,acceleration,invisibility:integer):integer;
var
  Pbx, Pcx : word;
 
begin
  Pbx := (speed and 7) + ((manouevre and 7) shl 4) + ((range and 7) shl 8)+
		((armour and 7) shl 12);
  Pcx := (acceleration and 7) + ((invisibility and 1) shl 3);
 
  asm
    mov  ax, $80
    mov  bx, Pbx
    mov  cx, Pcx
    int  IntAddr
  end;
end;
 
end.
 

