
/*--------------------------------------------------------------------------
 *
 *	MOUKEY v1.0 for C/C++
 *	Mouse routines
 *
 *	MOUTEST.C: Test program
 *
 *	May 1997
 *
 *	Copyright (c) 1997 Tanescu A. Horatiu
 *	Author's address: alpha@lego.soroscj.ro
 *
 *	Written and compiled under Borland C++ Version 3.1.
 *
 *	Permission is granted to incorporate any or all code and
 *	information contained in this file into other programs
 *	provided that proper credit is given to Tanescu A. Horatiu.
 *
 *--------------------------------------------------------------------------
 *
 *	Revision history:
 *      1.0	May 1997	Initial coding.
 *
 */

#include "mouse.h"
#include <conio.h>
#include <string.h>
#include <stdlib.h>

/*  Build a text attribute from a background and text color
 */

#define MAKEATTR(backcolor, textcolor)		(backcolor*16 + textcolor)

/*  Mouse information strings
 */

char* mousetypes[]     = {"bus", "serial", "InPort", "PS/2", "HP"};
char* interruptrates[] = {"no interrupts allowed", "30/sec", "50/sec",
			  "100/sec", "200/sec"};
char* cursortypes[]    = {"text, software", "text hardware", "graphic"};

/*  Defines active text-mode window and clears it with a text attribute.
 */

void win(int left, int top, int right, int bottom, int attr)
  { window(left, top, right, bottom); textattr(attr); clrscr(); }

/*  Writes a string in the center of a row.
 */

int ccputs(const char *str, int y)
{
  struct text_info ti; gettextinfo(&ti);
  gotoxy((ti.winright - ti.winleft + 1 - strlen(str))/2 + 1, y);
  return (cputs(str));
}

/*  Init screen, mouse and display mouse information
 */

void init(void)
{
  mouse_info     info;
  mouse_miscinfo info2;
  int horiz, vert, threshold, i;

  /*** init mouse ***/

  mouseReset();					// init mouse driver
  if (!mouseInstalled)
  {
    cputs("Error: can't find a mouse driver\r\n"); exit(-1);
  }

  /*** init screen ***/

  _setcursortype(_NOCURSOR);			// hide hardware cursor
  textmode(C80);				// change text mode to C80x25

  // create caption line, working area, status line
  win( 1,  1, 80,  1, MAKEATTR(1, 15));
  ccputs("Mouse Test Program", 1);
  win( 1,  2, 80,  2, MAKEATTR(3, 0));
  ccputs("MOUKEY v1.0 - Mouse routines for Borland C/C++", 1);
  win( 1,  3, 80, 24, MAKEATTR(0, 15));
  ccputs("Copyright (C) 1997 Tanescu A. Horatiu", 1);
  win( 1, 25, 80, 25, MAKEATTR(1, 15));
  ccputs(" Click any mouse button on this line or press any key to end", 1);

  // create mouse trap area box
  win(46,  7, 78,  7, MAKEATTR(1, 15));
  ccputs("Mouse cursor trap area", 1);
  win(46,  8, 78, 20, MAKEATTR(3, 15));
  win(46, 21, 78, 21, MAKEATTR(1, 15));
  ccputs("[ ] Trap mouse inside this area", 1);

  // create mouse information box
  win( 3,  7, 43,  7, MAKEATTR(3, 0));
  ccputs("Mouse information", 1);
  win( 3,  8, 43, 20, MAKEATTR(1, 15));
  window(4, 9, 43, 20);

  /*** display mouse information ***/

  info2.infoint = mouseGetInfo(&info);		// get mouse information

  // driver version number
  cprintf("Driver Version: %d.%d\r\n", info.majorver, info.minorver);
  // driver type (device driver or TSR)
  cprintf("Driver type:    %s\r\n", info2.info.devicedrv ? "Device driver" : "TSR");
  // mouse type (bus, serial, InPort, PS/2, HP)
  cprintf("Mouse Type:     %s\r\n", (info.mousetype <= 5) &&
  (info.mousetype > 0) ? mousetypes[info.mousetype - 1] : "Unknown");
  // mouse IRQ number
  cprintf("IRQ number:     IRQ%d\r\n", info.IRQ);
  // mouse interrupt rate
  cprintf("Interrupt rate: %s\r\n", interruptrates[info2.info.interruptrate]);
  // mouse cursor type
  cprintf("Cursor type:    %s\r\n\r\n", cursortypes[info2.info.cursortype]);
  // mouse sensitivity and double speed threshold
  mouseGetSensitivity(&horiz, &vert, &threshold);
  cprintf("Horizontal sensitivity: %d\r\n", horiz);
  cprintf("Vertical sensitivity:   %d\r\n", vert);
  cprintf("Double speed threshold: %d\r\n", threshold);

  window(1, 1, 80, 25); textattr(MAKEATTR(0, 15));
  for (i = 3; i < 25; i++)
    { gotoxy( 1, i); putch(''); gotoxy(80, i); putch(''); }
}

/*  Run program
 */

void run(void)
{
  int trap = 0;

  mouseTo(0, 0);	// send mouse cursor to upper-left corner
  mouseShow();		// show mouse

  win(3, 21, 43, 21, MAKEATTR(3, 0));
  while (1)
  {
    mouseRead();	// read mouse coordinates and buttons state

    // display mouse position and buttons state
    gotoxy(3, 1);
    cprintf("X:%2d  Y:%2d   L[%c] M[%c] R[%c]", textX(mouseX), textX(mouseY),
	    mouseLPressed ? '' : ' ',
	    mouseMPressed ? '' : ' ',
	    mouseRPressed ? '' : ' ');

    // if left button is clicked on the trap mouse check box toggle check box
    // state
    if (mouseLPressed && (textY(mouseY) == 21) && (textX(mouseX) >= 46)
	&& (textX(mouseX) <= 78))
    {
      trap = !trap;
      window(48, 21, 78, 21);
      textattr(MAKEATTR(1, 15));
      mouseHide();
      putch(trap ? 'X' : ' ');
      mouseShow();
      textattr(MAKEATTR(3, 0));
      window(3, 21, 43, 21);
      if (trap)		// trap mouse
      {
	mouseSetXRange(virtualX(46), virtualX(78));
	mouseSetYRange(virtualY(7), virtualY(21));
      }
      else		// release mouse
      {
	mouseSetXRange(virtualX(1), virtualX(80));
	mouseSetYRange(virtualY(1), virtualY(25));
      }
      do { mouseRead(); } while (mouseLPressed);
    }

    // if any button is clicked on the bottom line end program
    if ((textY(mouseY) == 25) && mouseButtons) break;

    // if any key is pressed end program
    if (kbhit()) break;
  }
}

/*  Perform clean-up
 */

void done(void)
{
  // hide mouse, clear screen and restore hardware cursor
  mouseHide();
  win(1, 1, 80, 25, MAKEATTR(0, 7));
  _setcursortype(_NORMALCURSOR);
}

/*  Main
 */

int main(void)
{

  init();
  run();
  done();

  return (0);
}