
/*--------------------------------------------------------------------------
 *
 *	MOUKEY v1.0 for C/C++
 *	Keyboard routines
 *
 *	KEY.C: Source code
 *
 *	May 1997
 *
 *	Copyright (c) 1997 Tanescu A. Horatiu
 *	Author's address: alpha@lego.soroscj.ro
 *
 *	Written and compiled under Borland C++ Version 3.1.
 *
 *	Permission is granted to incorporate any or all code and
 *	information contained in this file into other programs
 *	provided that proper credit is given to Tanescu A. Horatiu.
 *
 *--------------------------------------------------------------------------
 *
 *	Revision history:
 *      1.0	May 1997	Initial coding.
 *
 *--------------------------------------------------------------------------
 *
 *	function(s)
 *	  getkey - reads the actual keystroke
 *	  checkkey - tests if a keystroke is available to be read
 *	  shiftstatus - returns the current shift key status
 *	  settypematic - sets keyboard repeat rate
 *	  ungetkey - places a key in the typeahead buffer
 *	  egetkey - reads the actual keystroke (enhanced keyboard)
 *	  echeckkey - tests if a keystroke is available to be read (enhanced keyboard)
 *	  eshiftstatus - returns the current shift key status (enhanced keyboard)
 *
 */

#include "key.h"

#define INT_BIOSKBD		0x16

// use TASM
// #pragma inline

int getkey(void)
{
  asm	xor	ah, ah
  asm	int	INT_BIOSKBD
  return (_AX);
}

int checkkey(void)
{
  asm	mov	ah, 0x01
  asm	int	INT_BIOSKBD
  asm	jne	keydone
  asm	xor	ax, ax
keydone:
  return (_AX);
}

int shiftstatus(void)
{
  asm	mov	ah, 0x02
  asm	int	INT_BIOSKBD
  asm	xor	ah, ah
  return (_AX);
}

void settypematic(unsigned char rate, unsigned char delay)
{
  asm	mov	ax, 0x0305
  asm	mov	bl, rate
  asm	mov	bh, delay
  asm	int	INT_BIOSKBD
}

int ungetkey(int key)
{
  asm	mov	ah, 0x05
  asm	mov	cx, key
  asm	int	INT_BIOSKBD
  return (_AX);
}

int egetkey(void)
{
  asm	mov	ah, 0x10
  asm	int	INT_BIOSKBD
  return (_AX);
}

int echeckkey(void)
{
  asm	mov	ah, 0x11
  asm	int	INT_BIOSKBD
  asm	jne	keydone
  asm	xor	ax, ax
keydone:
  return (_AX);
}

int eshiftstatus(void)
{
  asm	mov	ah, 0x12
  asm	int	INT_BIOSKBD
  return (_AX);
}