/*\c
 * \secb{Declarations for lx2l}
 * Copyright (C) 1995 -- 1998  Michael Plugge (m.plugge@fh-mannheim.de)
 *
 * This file is part of the cvt2ltx package, a package of LaTeX
 * converters. The whole package is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License. See the files
 * config.h and COPYING for further details.
 */

#define NO 0
#define YES 1
#define BOTH 2

/*\c
 * \secb{Options for the makefiles}\index{options!makefiles}
 * This part contains some options that control the building of the makefiles.
 */
 
#define USE_ALIAS    YES   /* use alias names for the auxiliary executables */
#define HAVE_DJP     YES   /* use djp (exe file compressor) for MSDOS */
#define GETOPT_DEP   NO    /* include getopt.o in dependencies (lx2l, idl_format) */

#if VMS
#  define USE_VAXC   NO    /* (VAX only) if NO, use DECC also for VAX */
#  define USE_MMK    YES   /* if YES, use MMK as make; if no use DEC MMS */
#endif


/*\c
 * Define some options for VMS. You may use the (native) VMS CLI interface, the 
 * UNIX-style interface, or both. If both interfaces are selected, the command line
 * arguments are scanned; if an argument containing `-' or '+' as first character is
 * found, the UNIX-interface is used; if an argument containing `/' is found, the
 * VMS CLI is used. If you change the interface, you should also generate a new
 * makefile using the command
 *    lx2l v makefile.lx descrip.mms
 * to adjust the link options.
 */
#if VMS
#   define VMS_CLI  YES             /* use the VMS-CLI interface */
#   define UNIX_CLI YES             /* use the UNIX-style interface */
#   define USE_FOREIGN_COMMAND YES  /* if yes, link the cli definitions to the file */
#endif
