.model tiny
.186
.code
org 100h

start:      mov   ax, 13h           ; set video mode 13h (320x200x256)
            int   10h

            mov   ds, ax            ; seed random number with clock timer,
            xchg  bx, ax            ; also set bx to 13h which is a small
            mov   ax, ds:[033Ch]    ; enough value that the loop below will
                                    ; cover almost the whole screen
            mov   dx, cs            ; ds = segment of the working buffer
            add   dh, 10h           ; here we use the 64K segment immediately
            mov   ds, dx            ; following the code segment

            push  0A000h            ; es = video memory (at 0A000h)
            pop   es
                                    ; random number generation loop:
rand:       imul  ax, 9421          ;  generate random number using linear
            inc   ax                ;  congruential formula 9421*n+1
            xor   [bx], ah          ;  xor into this byte in the buffer, then
            inc   bx                ;  loop back to do next byte
            jnz   rand              ;  bits other than the low bit are set,
                                    ;  but this will only mess up the screen
                                    ;  for the first few frames

            lea   di, [si-322]      ; di = si - 322, it doesn't matter what
                                    ; si contains because this is a byte loop

; The counting loop will not run 3 times on the first pixel, but it will run
; correctly after that (see below).

life:       xor   cl, cl            ; pixel counting loop:
count:      add   cl, [di+bx]       ;  add in the top pixel in this column,
            add   cl, [si+bx-2]     ;  then the middle one, and finally
            add   cl, [si+bx+318]   ;  the bottom pixel; then move to the
            dec   bx                ;  next column and loop until bx is zero
            jnz   count

            mov   al, [si]          ; al = center pixel
            stosb                   ; draw this pixel on the screen

; This is a tricky construct to calculate the new state of this pixel.
; Remember that, in 'Game of Life', a pixel turns on if and only if either
; it had 3 neighbors, or it had 2 neighbors and was already on.
; Equivalently, it turns on if the number of pixels in the 3x3 square around
; it (including itself) is either 3 (always) or 4 (only if the pixel was
; already on).  This is the value that will be in CL.  The carry flag is set,
; so when AL is rotated right by 3 bits (CL=3), bit 5 of AL will be 1, since
; it gets the carry bit.  When AL is rotated right by 4 bits (CL=4), bit 5 of
; AL will contain the bit that was previously in bit 1 of AL (the previous
; state of the pixel).  If CL contains anything but 3 or 4, bit 5 of AL will
; be 0.  A diagram of this follows:

            stc                     ; 1.0000000x---> 0.0x100000 (rcr 3)
            rcr   al, cl            ; ^carry   |         ^
                                    ;          +---> 0.00x10000 (rcr 4)
            and   al, 20h           ; mask for bit 5.....^

            or    [si], al          ; add in new pixel value.
            shr   byte ptr [di], 5  ; set new pixel value for the pixel above
                                    ; and to the left of this pixel (it will
                                    ; not be accessed again on this frame)

            mov   bl, 3             ; bl = 3 for 3 iterations of count loop
            inc   si                ; move to the next pixel, and loop
            jnz   life              ; jump fails once each frame...

            mov   ah, 1             ; check for keypress
            int   16h
            jz    life              ; loop while no key has been pressed

            xchg  ax, bx            ; restore text mode (bx = 3 here)
            int   10h
            ret                     ; return to dos

end start
