.Sall;                                  \ suppress all Macro expansions.
Page 58,132;                            \ 58 lines/page, 132 columns/line.
Name Kaleidoscope;                      \ name of program module in .obj file.
Title "Kaleidm -- Multiple Kaleidoscopes";

main Group code, data;                  \ declare Group main as 2 segments.
Assume cs:main,ss:main,ds:main,es:main; \ all Segment regs point to main Group.

O   Equ <Offset main:>;                 \ define O as Offset operator.
W   Equ <Word Ptr>;                     \ define W as Word Ptr operator.
B   Equ <Byte Ptr>;                     \ define B as Byte Ptr operator.

TIM0    = 40h;                          \ timer zero's port.
TIMC    = 43h;                          \ timer command port.

X = 640;                                \ number of X pixels.
Y = 350;                                \ number of Y pixels.
C = 16;                                 \ number of colors.

psp Struc;                              \ define PSP structure.
        ' [128];                        \ first half of psp.
        ' cmdlen, cmdtail [127];        \ command tail length and data.
psp EndS;                               \ end of PSP structure.

code Segment;                           \ define code Segment.
Org 0100h;                              \ all .com programs start at 0100h.

data Segment;                           \ define data Segment.

        " q =1024;                      \ theoretical size.
        " mx =X, my =Y;                 \ save max. x and max. y here.
        " ix =0, iy =0;                 \ initial x and y offsets.
        " ox =0, oy =0;                 \ save x and y offsets here.
        " sx, sy, ex, ey;               \ save start and end coords here.

umsg Label Byte;
        ' ="   Usage:",=(13,10);
        ' =(13,10);
        ' ="    Kaleidm [ SquareRoot(NumberOfKaleidoscopes) ]",=(13,10);
        ' =(13,10);
        ' ="    Default is random 1-10, Maximum is 30.",=(13,10,'$');

data EndS;                              \ close data segment, goes after code.

Kaleidm:                                \ program starts here.

        !-; &al; @TIMC =;               \ latch timer zero.
        = @TIM0; ah = al;               \ fetch LSB.
        = @TIM0; al == ah; !+;          \ fetch MSB, ax = count.

        seed[0] = ax; ah == al;         \ save timer in LSW of seed.
        seed[2] = ax;                   \ save swapped timer in MSW of seed.

        si = cmdtail;                   \ si = command tail pointer.
        &cx; cl = ds:cmdlen;            \ cx = length of command tail.

        =.Number; ax? ==                \ get number to do.
        {                               \ if user doesn't care, then...
          ax = 10; =.Rand;              \ get a random number to do.
          bx = ax+;                     \ bx = square root of number to do.
        },                              \ else...
        {                               \ he cares...
          ax - 30 ? >>{ ax = 30; };     \ if too big, use the max.
          bx = ax;                      \ bx = square root of number to do.
        };                              \ end get number to do.

        ax = X; &dx; // bx;             \ compute max. x.
        mx = ax;                        \ save max. x.
        ax = Y; &dx; // bx;             \ compute max. y.
        my = ax;                        \ save max. y.

        ax = X; &dx; //mx; **mx;        \ compute max. x pixels across.
        ox = ix = dx = X - ax > 1;      \ save initial x offset.
        ax = Y; &dx; //my; **my;        \ compute max. y pixels down.
        oy = iy = dx = Y - ax > 1;      \ save initial y offset.

        ax = 10h; !10h;                 \ select 640-by-350 graphics

        {                               \ do...
          =.Kaleid;                     \ put up a Kaleidoscope.
          ox = ax = ox + mx;            \ compute next x offset.
          ax + mx - X ? >>              \ if beyond the physical limit...
          {                             \ then...
            ox = ax = ix;               \ re-set it to start, and...
            oy = ax = oy + my;          \ compute next y offset.
            ax + my - Y ? >>            \ if beyond the physical limit...
            { oy = ax = iy; };          \ then, re-set it to start.
          };                            \ end, x beyond limit.

          ah = 11h; !16h;               \ if a key is waiting then exit...
        }==;                            \ loop 'til done...

quit:   ax = 03h; !10h;                 \ select 25-by-80 text
        al = cl; ah = 4Ch; !21h;        \ return to DOS.
\
\\\\\\\\\\
\ Kaleid \
\\\\\\\\\\
\
\
\   Kaleid puts a Kaleidoscope on the screen.  This routine builds a
\   Kaleidoscope on the screen at position
\
\   Entry Conditions:
\       ax = scratch.
\       cx = scratch.
\       dx = scratch.
\       si = scratch.
\       di = scratch.
\
\   Exit Conditions:
\       ax = scratch.
\       cx = scratch.
\       dx = scratch.
\       si = scratch.
\       di = scratch.
\

Kaleid Proc Near;                       \ procedure to put a Kaleidoscope up.

        ax = q; =.Rand; sx = ax;        \ get and save start x coord.
        dx = mx; ** dx; //q;            \ ax = scaled x value.
        si = ax;                        \ save x coord.
        ax = si + ox; =ax;              \ get x coord.
        ax = q; =.Rand; sy = ax;        \ get and save start y coord.
        dx = my; ** dx; //q;            \ ax = scaled y value.
        di = ax;                        \ save y coord.
        ax = di + oy; =ax;              \ get y coord.
        ax = (C-1); =.Rand; ax+; =ax;   \ compute color.
        cx = ax;                        \ save color.
        =.PSet;                         \ plot the point.
        ax = q; =.Rand; ex = ax;        \ get and save end x coord.
        dx = mx; ** dx; //q;            \ ax = scaled x value.
        bx = ax;                        \ save x coord.
        ax = bx + ox; =ax;              \ get x coord.
        ax = q; =.Rand; ey = ax;        \ get and save end y coord.
        dx = my; ** dx; //q;            \ ax = scaled y value.
        bp = ax;                        \ save y coord.
        ax = bp + oy; =ax;              \ get y coord.
        =cx;                            \ same color.
        =.Line;                         \ plot the line.

        =.Quad;                         \ duplicate it in the other quadrants.

        ax = sx; ax == sy;              \ exchange sx and sy.
        dx = mx; ** dx; //q;            \ ax = scaled x value.
        si = ax;                        \ save x coord.
        ax = si + ox; =ax;              \ get x coord.
        ax = sy;                        \ get new sy.
        dx = my; ** dx; //q;            \ ax = scaled y value.
        di = ax;                        \ save y coord.
        ax = di + oy; =ax;              \ get y coord.
        =cx;                            \ same color.
        =.PSet;                         \ plot the point.
        ax = ex; ax == ey;              \ exchange ex and ey.
        dx = mx; ** dx; //q;            \ ax = scaled x value.
        bx = ax;                        \ save x coord.
        ax = bx + ox; =ax;              \ swap and get x coord.
        ax = ey;                        \ get new ey.
        dx = my; ** dx; //q;            \ ax = scaled y value.
        bp = ax;                        \ save y coord.
        ax = bp + oy; =ax;              \ get y coord.
        =cx;                            \ same color.
        =.Line;                         \ plot the line.

        =.Quad;                         \ duplicate it in the other quadrants.

        .=;                             \ return...............................

Kaleid EndP;                            \ end proc to put a Kaleidoscope up.
\
\\\\\\\\
\ Quad \
\\\\\\\\
\
\
\   Quad is called to duplicate a line in quadrant II in the other
\   three quadrants (I, III, and IV).
\
\   Entry Conditions:
\       ax = scratch.
\       bx = ending x coord.
\       cx = color.
\       dx = scratch.
\       bp = ending y coord.
\       si = starting x coord.
\       di = starting y coord.
\
\   Exit Conditions:
\       ax = scratch.
\       bx = ending x coord.
\       cx = color.
\       dx = scratch.
\       bp = ending y coord.
\       si = starting x coord.
\       di = starting y coord.
\
\

Quad Proc Near;                         \ procedure to duplicate in quads.

        ax = mx - 1 - si + ox; =ax;     \ compute quad I x coord.
        ax = di + oy; =ax;              \ use quad II y for quad I y coord.
        =cx;                            \ same color.
        =.PSet;                         \ plot the point.
        ax = mx - 1 - bx + ox; =ax;     \ compute quad I x coord.
        ax = bp + oy; =ax;              \ use quad II y for quad I y coord.
        =cx;                            \ same color.
        =.Line;                         \ plot the line.

        ax = si + ox; =ax;              \ use quad II x for quad III x coord.
        ax = my - 1 - di + oy; =ax;     \ compute quad III y coord.
        =cx;                            \ same color.
        =.PSet;                         \ plot the point.
        ax = bx + ox; =ax;              \ use quad II x for quad III x coord.
        ax = my - 1 - bp + oy; =ax;     \ compute quad III y coord.
        =cx;                            \ same color.
        =.Line;                         \ plot the line.

        ax = mx - 1 - si + ox; =ax;     \ compute quad IV x coord.
        ax = my - 1 - di + oy; =ax;     \ compute quad IV y coord.
        =cx;                            \ same color.
        =.PSet;                         \ plot the point.
        ax = mx - 1 - bx + ox; =ax;     \ compute quad IV x coord.
        ax = my - 1 - bp + oy; =ax;     \ compute quad IV y coord.
        =cx;                            \ same color.
        =.Line;                         \ plot the line.

        .=;                             \ return...............................

Quad EndP;                              \ end proc to duplicate in quads.
\
\\\\\\\\\\
\ Number \
\\\\\\\\\\
\
\
\   Number converts an ASCII decimal number from the buffer at [si] and
\   returns it in ax.  If no number exists, zero is returned.  If the
\   number is not delimited by white space, the Usage message is displayed
\   and control is returned to DOS with ErrorLevel 255.  No check is made
\   for overflow so the actual number returned is modulo 65536.
\
\   Entry Conditions:
\       ax = scratch.
\       dx = scratch.
\       si = address of input string.
\       di = scratch.
\
\   Exit Conditions:
\       ax = number.
\       dx = scratch.
\       si = pointer to delimiter (non-numeric).
\       di = number.
\
\

Number Proc Near;                       \ procedure to get a number.

        &di;                            \ di = initial value (zero).
        {                               \ scan off leading white space.
          = *; al - 13 ? ==;            \ get char, break if cr.
          al - ' ' ?                    \ if space, tab or ctrl char...
        }<<=;                           \ loop 'til white space gone...
        {                               \ now get the number...
          al - '0'; <<{ si-; . };       \ if below zero back up & break.
          al - 9 ?; >>{ si-; . };       \ if above nine back up & break.
          &ah; di == ax;                \ ax = old, di = new.
          dx = 10; **dx; di + ax;       \ di = new value.
          = *;                          \ al = next char.
        }.;                             \ loop 'til done...
        B [si] - ' ' ? <<=              \ if delimiter is space or ctrl char...
        { ax = di; .=; };               \ return with number...................
        dx = O(umsg); ah = 9; !21h;     \ non-numeric, print usage message.
        ax = 4CFFh; !21h;               \ return with ErrorLevel 255.

Number EndP;                            \ end of procedure to get a number.
\
\\\\\\\\
\ Rand \
\\\\\\\\
\
\
\   Rand is a random number generator.
\
\   Entry Conditions:
\       ax = largest random number desired + 1.  Zero => 65536.
\       dx = scratch.
\
\   Exit Conditions:
\       ax = the random number.
\       dx = the random number.
\
\

data Segment;                           \ define data Segment.

        " seed =5678h, =1234h;          \ define the default seed.

data EndS;                              \ close data segment, goes after code.

Rand Proc Near;                         \ procedure to generate random numbers.

        =bx =ax;                        \ save bx and max. random number.
        ax = 3; **seed[0];              \ ax = 3.  dxax = LSW seed * 3.
        bx = ax;                        \ bx = LSW seed * 3.
        ax = 43FDh; **seed[2];          \ ax = 43FD.  dxax = MSW seed * 43FD.
        bx + ax;                        \ bx = LSW seed * 3 + MSW seed * 43FD.
        ax = 43FDh; **seed[0];          \ ax = 43FD.  dxax = LSW seed * 43FD.
        dx + bx;                        \ dxax = seed * 343FDh.
        ax + 9EC3h; dx ++ 26h;          \ dxax = seed * 343FDh + 269EC3h.
        seed[0] = ax; seed[2] = dx;     \ save new seed for next time.
        bx=; bx ? <>                    \ if max. random < 65536, then...
        { ax = dx; &dx; //bx; };        \ random is MSW of seed MOD max.
        ax = dx;                        \ ax = dx = random number.
        bx=; .=;                        \ restore bx and return................

Rand EndP;                              \ end proc to generate random numbers.
\
\\\\\\\\
\ PSet \
\\\\\\\\
\
\
\   PSet sets the specified EGA pixel to the specified color (0-15).
\   This routine is Pascal callable.  8088 or better compatible.
\
\   Calling Sequence:
\       =xpos =ypos =color; =.PSet;             \ plot a point.
\
\   Entry Conditions:
\       Stack Frame contains:
\          return address.
\          pc (pixel color).
\          yi (y input).
\          xi (x input).
\
\   Exit Conditions:
\       Stack Frame removed.
\       All Registers preserved.
\
\

xi      Equ     [bp][8];                \ x input.
yi      Equ     [bp][6];                \ y input.
pc      Equ     [bp][4];                \ pixel color.
NARGS = 3;                              \ number of arguments.

data Segment;

        " xo =0, yo =0;                 \ save locations for last coords.

data EndS;

EGA_CCR Equ     03D4h;                  \ CRT Control Register port address.
EGA_GCR Equ     03CEh;                  \ Graphics Controller Reg port addr.
EGA_SQR Equ     03C4h;                  \ Sequencer port address.
EGA_MMR Equ     02h;                    \ wo Map Mask Register sub index.

EGA_RAM Equ     0A000h;                 \ start segment for EGA text RAM.
GL      Equ     80;                     \ number of bytes in line of graphics.

PSet Proc Near;                         \ proc to plot a point.

        =bp; bp = sp;                   \ save bp & set-up stack frame.
        =ax =cx =dx =di;                \ save regs.

        dx = EGA_SQR;                   \ dx = Sequencer Port Address.
        ah = 0Fh; al = EGA_MMR; @@=;    \ enable all four planes.

        dx = EGA_GCR;                   \ dx = Graphic Ctrl Reg Port.
        ax = 0005h; @@=;                \ al = sub reg 5, ah = mode 0.
        ax = 0F01h; @@=;                \ ax = enable all S/R.
        ah = pc; &al; @@=;              \ set S/R register to color.

        yo = ax = yi;                   \ yo = ax = yi.
        dx = GL; **dx; di == ax;        \ di = row address.
        xo = ax = xi;                   \ xo = ax = xi.
        cl = al & 7;                    \ cl = bit number.
        ax > 1 > 1 > 1; di + ax;        \ di = byte address in GRAM.
        dx = EGA_GCR;                   \ dx = Graphic Ctrl Reg Port.
        ax = 8008h; ah > cl; @@=;       \ write bit pattern to mask register.
        bp = ds; ds = ax = EGA_RAM;     \ save ds, ds = screen segment address.
        [di] == al;                     \ draw the pixel.
        ds = bp;                        \ restore ds.

        ax = 0FF08h; @@=;               \ restore unimpeded writes.
        ax = 00001h; @@=;               \ disable all set/reset regs.

        bp= ax= cx= dx= di=;            \ restore registers.
        .=NARGS*2;                      \ return with clean stack......

PSet EndP;                              \ end proc to plot a point.
\
\\\\\\\\
\ Line \
\\\\\\\\
\
\
\   Line draws a line from last EGA point to the specified point in
\   the specified color (0-15).  This routine is Pascal callable.
\   8088 or better compatible.
\
\   Calling Sequence:
\       =xpos =ypos =color; =.Line;             \ plot a line.
\
\   Entry Conditions:
\       Stack Frame contains:
\          return address.
\          pc (pixel color).
\          yi (y input).
\          xi (x input).
\
\   Exit Conditions:
\       Stack Frame removed.
\       All Registers are preserved.
\
\

data Segment;

        " t =0, l =0;                           \ total segs, line length.

data EndS;

Line Proc Near;                                 \ proc to draw a line.

        =bp; bp = sp;                           \ set-up stack frame.
        =ax =cx =dx =di =bx =si;                \ save registers.

        dx = EGA_SQR;                           \ dx = Sequencer Port Address.
        ah = 0Fh; al = EGA_MMR; @@=;            \ enable all four planes.

        dx = EGA_GCR;                           \ dx = Graphic Ctrl Reg Port.
        ax = 0005h; @@=;                        \ al = sub reg 5, ah = mode 0.
        ax = 0F01h; @@=;                        \ ax = enable all S/R.
        ah = pc; &al; @@=;                      \ set S/R register to color.

        ax = xi - xo;                           \ ax = x-diff.
        bx = yi - yo;                           \ bx = y-diff.
        {                                       \ case of x ? y.

          ==                                    \ case of y same.
          {                                     \ yes then...
            ax ?                                \ test direction of draw.
            di = xo; xo = si = xi;              \ to right, di = xo, si = xi.
            --{ di == si; };                    \ to left, di = xi, si = xo.
            cx = di & 7; di > 1 > 1 > 1;        \ cl = bit numb, di = byte numb
            bx = si & 7;                        \ bl = end bit number in byte.
            si > 1 > 1 > 1 - di;                \ si = numb of bytes involved.
            ax = GL; **yo; di + ax;             \ di = start byte offset.
            bh = 0FFh > cl;                     \ bh = start byte mask.
            cx = si;                            \ cx = numb of bytes involved.
            si = ds; ds = ax = EGA_RAM;         \ si = ds, ds = GRAM segment.
            al = 08h; dx = EGA_GCR;             \ al = reg #, dx = GCR port.
            ?<>                                 \ cx = number of bytes involved
            {                                   \ if start and end bytes diff
              ah = bh; @@=;                     \ write 1st pattern to mask reg
              [di+] == ah; cx-;                 \ plot 1st byte pattern.
              ah = bh = 0FFh; @@=;              \ write bit pattern to mask reg
              ?<>{ [di+] == ah; }-.;            \ plot cx whole byte patterns.
            };                                  \ endif diff start and end byte
            cl = bl; ah = 80h +-> cl & bh;      \ ah = end pattern mask.
            @@=; [di] == ah;                    \ plot last byte's worth.
            ds = si; ..                         \ restore ds and exit.
          };                                    \ end y same.

          bx == ax ? ==                         \ case of x same.
          {                                     \ yes then...
            bx == ax ?                          \ bx = n, test draw direction.
            ax = yo; yo = dx = yi;              \ down, ax = yo, dx = yi, bx=n
            --{ ax == dx; -bx; };               \ up, ax = yi, dx = yo. abs(bx)
            si = GL; **si; di == ax;            \ si = increment, di = strt row
            ax = xo;                            \ ax = x-old.
            cl = al & 7;                        \ cl = bit number.
            ax > 1 > 1 > 1; di + ax;            \ di = start GRAM address.
            ax = 8008h; ah > cl;                \ ah = bit pattern, al = reg #
            dx = EGA_GCR; @@=;                  \ write bit pattern to mask reg
            cx = bx+;                           \ cx = number to do.
            bx = ds; ds = ax = EGA_RAM;         \ bx = ds, ds = GRAM segment.
            { [di] == al; di + si; }-.;         \ draw vertical line.
            ds = bx; ..                         \ restore ds and exit.
          };                                    \ end x same.

          Cwd; ax ^ dx - dx+;                   \ ax = y pixels to do.
          bx == ax; si = GL ^ dx - dx;          \ bx = numb y pixels, si = dir.
          Cwd; ax ^ dx - dx+;                   \ ax = numb x pixels, dx = dir.
          di = yi; di == yo;                    \ di = old y, save new y.
          dx ? cx = xi; xo == cx; --            \ cx = old x, save new x.
          { cx = xo; di = yo; -si; };           \ don't let x move to the left.
          ax == di; dx = GL; **dx; di == ax;    \ di = start row GRAM address.

          ax - bx ? ==                          \ case of x and y pixels same.
          {                                     \ yes then...
            ax = cx;                            \ ax = start x coord.
            cl & 7;                             \ cl = bit number.
            ax > 1 > 1 > 1; di + ax;            \ di = start GRAM address.
            ax = 8008h; ah > cl;                \ ah = bit pattern, al = reg #
            cx = bx;                            \ cx = number to do.
            bp = ds; ds = dx = EGA_RAM;         \ bp = ds, ds = GRAM segment.
            dx = EGA_GCR;                       \ dx = bit pattern to mask reg
            {                                   \ draw diagonal line.
              @@=; [di] == bl;                  \ set mask reg and draw pixel.
              ah >> 1; di ++ si;                \ adjust mask and GRAM address.
            }-.;                                \ loop 'til done...
            ds = bp;                            \ restore ds.
          },                                    \ end x and y pixels same.

          <<                                    \ case of less x than y pixels.
          {                                     \ yes, then...
            t = ax;                             \ save total segs (x pixels).
            l = bx;                             \ save total pixels (Y pixels).
            dx = ax; &ax; //bx;                 \ ax = increment.
            dx < 1; bx - dx ? bx = ax ++ 0; &ax;\ bx = rounded inc, ax = acc.
            bp = cx;                            \ bp = initial x.
            cl & 7;                             \ cl = bit number.
            bp > 1 > 1 > 1; di + bp;            \ di = start GRAM address.
            dx = 8008h; dh > cl;                \ dh = bit pattern, dl = reg #.
            {                                   \ while segments to do...
              t - 1 ? <>                        \ if not least segment...
              {                                 \ then, compute segment len...
                cx = (-1);                      \ -line minimum segment length.
                { ax + bx; <<; }-.;             \ add inc, break if cy, loop.
                -cx; l - cx;                    \ cx = Seg len, l = remaining.
              },{ cx = l; ?== };                \ else, use rem, break if none.
              =ax =bx =ds;                      \ save acc, inc and ds.
              ds = ax = EGA_RAM;                \ ds = GRAM segment.
              ax = dx;                          \ ah = bit pattern, al = reg #.
              dx = EGA_GCR;                     \ dx = GCR port.
              {                                 \ draw next vertical segment...
                @@=; [di] == bl;                \ set mask reg and draw pixel.
                di + si;                        \ adjust GRAM address.
              }-.;                              \ loop 'til segment done...
              ah >> 1; di ++ 0;                 \ adjust mask and GRAM address.
              dx = ax;                          \ dh = bit pattern, dl = reg #.
              ax= bx= ds=;                      \ restore acc, inc, ds.
              t-;                               \ decrement total numb segments
            }<>;                                \ loop until done...
          },.                                   \ end more y than x pixels.

          {                                     \ case of more x than y pixels.
            t = bx;                             \ save total segs (y pixels).
            l = ax;                             \ save total pixels (x pixels).
            dx = bx; bx = ax; &ax; //bx;        \ ax = increment.
            dx < 1; bx - dx ? bx = ax ++ 0; &ax;\ bx = rounded inc, ax = acc.
            bp = cx;                            \ bp = initial x coord.
            bp > 1 > 1 > 1; di + bp;            \ di = initial GRAM address.
            bp = cx & 7;                        \ bp = initial x bit position.
            dx = EGA_GCR;                       \ dx = GCR port.
            {                                   \ for each line segment...
              t - 1 ? <>                        \ if not least segment...
              {                                 \ then, compute segment len...
                cx = (-1);                      \ -line minimum segment length.
                { ax + bx; <<; }-.;             \ add inc, break if cy, loop.
                -cx; l - cx;                    \ cx = Seg len, l = remaining.
              },{ cx = l; ?== };                \ else, use rem, break if none.
              =ax =bx =ds;                      \ save acc, inc and ds.
              ds = ax = EGA_RAM;                \ ds = GRAM segment.
              cx + bp; ax = cx-; bp == cx & 7;  \ cx = x bit pos, bp = next pos
              bl = al & 7;                      \ bl = end bit number in byte.
              bh = 0FFh > cl;                   \ bh = start byte mask.
              cx == ax > 1 > 1 > 1;             \ cx = numb of bytes involved.
              al = 08h;                         \ al = reg #.
              ?<>                               \ cx = number of bytes involved
              {                                 \ if start and end bytes diff
                ah = bh; @@=;                   \ write 1st pattern to mask reg
                [di+] == ah; cx-;               \ plot 1st byte pattern.
                bh = ah = 0FFh; @@=;            \ write bit pattern to mask reg
                ?<>{ [di+] == ah; }-.;          \ plot cx whole byte patterns.
              };                                \ endif diff start and end byte
              cl = bl; ah = 80h +-> cl & bh;    \ ah = end pattern mask.
              @@=; [di] == al;                  \ plot last byte's worth.
              ah > 1; di ++ si;                 \ di = next GRAM address.
              ax= bx= ds=;                      \ restore acc, inc, ds.
              t-;                               \ decrement total numb segments
            }<>;                                \ loop until done...
          };                                    \ end more x than y pixels.

        };                                      \ end case of x ? y.

        ax = 0FF08h; @@=;                       \ restore unimpeded writes.
        ax = 00001h; @@=;                       \ disable all set/reset regs.

        bp= ax= cx= dx= di= bx= si=;            \ restore registers.
        .=NARGS*2;                              \ return with clean stack......

Line EndP;                                      \ end proc to draw a line.

code EndS;                              \ close code Segment, goes before data.
End Kaleidm;                            \ end of source, start at Kaleidm.
