/*=============================*/
/*           NETS              */
/*                             */
/* a product of the AI Section */
/* NASA, Johnson Space Center  */
/*                             */
/* principal author:           */
/*       Paul Baffes           */
/*                             */
/* contributing authors:       */
/*      Bryan Dulock           */
/*      Chris Ortiz            */
/*=============================*/


/*
----------------------------------------------------------------------
  Code For Semi-linear Activation Function (Prefix = A_)
----------------------------------------------------------------------
  This code is divided into 3 major sections:

  (1) include files
  (2) global variables
  (3) subroutines
 
  Each section is further explained below.
----------------------------------------------------------------------
*/



/*
----------------------------------------------------------------------
  INCLUDE FILES
----------------------------------------------------------------------
*/
#include  "common.h"


/*
----------------------------------------------------------------------
  GLOBAL VARIABLES
----------------------------------------------------------------------
  The only global variable used by this code is a table needed for storing
  all of the values of the semilinear funciton. This table is generated
  to help speed things up when node outputs are being calculated. Rather
  than run the rather long semilinear function, a table reference is 
  made which will generate the appropriate answer.  In short, we pre-
  calculate all possible values for the semilinear funciton and store
  them in a table using the incoming sum value as an index for finding
  the precalculated activation value.
----------------------------------------------------------------------
*/

     /* see "semi_linears" variable below */


/*
======================================================================
  ROUTINES IN NET.C                                                   
======================================================================
  The only routine in this file is one which takes a Sint value which
  represents a sum and returns the semilinear activation value.

  Type Returned                 Routine                                 
  -------------                 -------                                 
                                                                      
    Sint                        A_activation
======================================================================
*/



/*
----------------------------------------------------------------------
  Below is the definition for the global variable "semi_linears". This
  table is of size MAX_SUM.
----------------------------------------------------------------------
*/
#if  USE_SCALED_INTS
static Sint  semi_linears[] ={
512, 512, 512, 512, 512, 513, 513, 513,
513, 514, 514, 514, 514, 515, 515, 515,
515, 516, 516, 516, 516, 517, 517, 517,
517, 518, 518, 518, 518, 519, 519, 519,
519, 520, 520, 520, 520, 521, 521, 521,
521, 522, 522, 522, 522, 523, 523, 523,
523, 524, 524, 524, 524, 525, 525, 525,
525, 526, 526, 526, 526, 527, 527, 527,
527, 528, 528, 528, 528, 529, 529, 529,
529, 530, 530, 530, 530, 531, 531, 531,
531, 532, 532, 532, 532, 533, 533, 533,
533, 534, 534, 534, 534, 535, 535, 535,
535, 536, 536, 536, 536, 537, 537, 537,
537, 538, 538, 538, 538, 539, 539, 539,
539, 540, 540, 540, 540, 541, 541, 541,
541, 542, 542, 542, 542, 543, 543, 543,
543, 544, 544, 544, 544, 545, 545, 545,
545, 546, 546, 546, 546, 547, 547, 547,
547, 548, 548, 548, 548, 549, 549, 549,
549, 550, 550, 550, 550, 551, 551, 551,
551, 552, 552, 552, 552, 553, 553, 553,
553, 554, 554, 554, 554, 555, 555, 555,
555, 556, 556, 556, 556, 557, 557, 557,
557, 558, 558, 558, 558, 559, 559, 559,
559, 560, 560, 560, 560, 561, 561, 561,
561, 562, 562, 562, 562, 563, 563, 563,
563, 564, 564, 564, 564, 565, 565, 565,
565, 566, 566, 566, 566, 567, 567, 567,
567, 568, 568, 568, 568, 569, 569, 569,
569, 569, 570, 570, 570, 570, 571, 571,
571, 571, 572, 572, 572, 572, 573, 573,
573, 573, 574, 574, 574, 574, 575, 575,
575, 575, 576, 576, 576, 576, 577, 577,
577, 577, 578, 578, 578, 578, 579, 579,
579, 579, 580, 580, 580, 580, 581, 581,
581, 581, 582, 582, 582, 582, 583, 583,
583, 583, 584, 584, 584, 584, 584, 585,
585, 585, 585, 586, 586, 586, 586, 587,
587, 587, 587, 588, 588, 588, 588, 589,
589, 589, 589, 590, 590, 590, 590, 591,
591, 591, 591, 592, 592, 592, 592, 593,
593, 593, 593, 594, 594, 594, 594, 595,
595, 595, 595, 595, 596, 596, 596, 596,
597, 597, 597, 597, 598, 598, 598, 598,
599, 599, 599, 599, 600, 600, 600, 600,
601, 601, 601, 601, 602, 602, 602, 602,
603, 603, 603, 603, 603, 604, 604, 604,
604, 605, 605, 605, 605, 606, 606, 606,
606, 607, 607, 607, 607, 608, 608, 608,
608, 609, 609, 609, 609, 610, 610, 610,
610, 610, 611, 611, 611, 611, 612, 612,
612, 612, 613, 613, 613, 613, 614, 614,
614, 614, 615, 615, 615, 615, 616, 616,
616, 616, 616, 617, 617, 617, 617, 618,
618, 618, 618, 619, 619, 619, 619, 620,
620, 620, 620, 621, 621, 621, 621, 622,
622, 622, 622, 622, 623, 623, 623, 623,
624, 624, 624, 624, 625, 625, 625, 625,
626, 626, 626, 626, 627, 627, 627, 627,
627, 628, 628, 628, 628, 629, 629, 629,
629, 630, 630, 630, 630, 631, 631, 631,
631, 631, 632, 632, 632, 632, 633, 633,
633, 633, 634, 634, 634, 634, 635, 635,
635, 635, 635, 636, 636, 636, 636, 637,
637, 637, 637, 638, 638, 638, 638, 639,
639, 639, 639, 639, 640, 640, 640, 640,
641, 641, 641, 641, 642, 642, 642, 642,
643, 643, 643, 643, 643, 644, 644, 644,
644, 645, 645, 645, 645, 646, 646, 646,
646, 646, 647, 647, 647, 647, 648, 648,
648, 648, 649, 649, 649, 649, 650, 650,
650, 650, 650, 651, 651, 651, 651, 652,
652, 652, 652, 653, 653, 653, 653, 653,
654, 654, 654, 654, 655, 655, 655, 655,
656, 656, 656, 656, 656, 657, 657, 657,
657, 658, 658, 658, 658, 658, 659, 659,
659, 659, 660, 660, 660, 660, 661, 661,
661, 661, 661, 662, 662, 662, 662, 663,
663, 663, 663, 664, 664, 664, 664, 664,
665, 665, 665, 665, 666, 666, 666, 666,
666, 667, 667, 667, 667, 668, 668, 668,
668, 669, 669, 669, 669, 669, 670, 670,
670, 670, 671, 671, 671, 671, 671, 672,
672, 672, 672, 673, 673, 673, 673, 673,
674, 674, 674, 674, 675, 675, 675, 675,
676, 676, 676, 676, 676, 677, 677, 677,
677, 678, 678, 678, 678, 678, 679, 679,
679, 679, 680, 680, 680, 680, 680, 681,
681, 681, 681, 682, 682, 682, 682, 682,
683, 683, 683, 683, 684, 684, 684, 684,
684, 685, 685, 685, 685, 686, 686, 686,
686, 686, 687, 687, 687, 687, 688, 688,
688, 688, 688, 689, 689, 689, 689, 690,
690, 690, 690, 690, 691, 691, 691, 691,
691, 692, 692, 692, 692, 693, 693, 693,
693, 693, 694, 694, 694, 694, 695, 695,
695, 695, 695, 696, 696, 696, 696, 697,
697, 697, 697, 697, 698, 698, 698, 698,
698, 699, 699, 699, 699, 700, 700, 700,
700, 700, 701, 701, 701, 701, 701, 702,
702, 702, 702, 703, 703, 703, 703, 703,
704, 704, 704, 704, 704, 705, 705, 705,
705, 706, 706, 706, 706, 706, 707, 707,
707, 707, 707, 708, 708, 708, 708, 709,
709, 709, 709, 709, 710, 710, 710, 710,
710, 711, 711, 711, 711, 712, 712, 712,
712, 712, 713, 713, 713, 713, 713, 714,
714, 714, 714, 714, 715, 715, 715, 715,
716, 716, 716, 716, 716, 717, 717, 717,
717, 717, 718, 718, 718, 718, 718, 719,
719, 719, 719, 720, 720, 720, 720, 720,
721, 721, 721, 721, 721, 722, 722, 722,
722, 722, 723, 723, 723, 723, 723, 724,
724, 724, 724, 725, 725, 725, 725, 725,
726, 726, 726, 726, 726, 727, 727, 727,
727, 727, 728, 728, 728, 728, 728, 729,
729, 729, 729, 729, 730, 730, 730, 730,
730, 731, 731, 731, 731, 731, 732, 732,
732, 732, 733, 733, 733, 733, 733, 734,
734, 734, 734, 734, 735, 735, 735, 735,
735, 736, 736, 736, 736, 736, 737, 737,
737, 737, 737, 738, 738, 738, 738, 738,
739, 739, 739, 739, 739, 740, 740, 740,
740, 740, 741, 741, 741, 741, 741, 742,
742, 742, 742, 742, 743, 743, 743, 743,
743, 744, 744, 744, 744, 744, 745, 745,
745, 745, 745, 746, 746, 746, 746, 746,
747, 747, 747, 747, 747, 748, 748, 748,
748, 748, 748, 749, 749, 749, 749, 749,
750, 750, 750, 750, 750, 751, 751, 751,
751, 751, 752, 752, 752, 752, 752, 753,
753, 753, 753, 753, 754, 754, 754, 754,
754, 755, 755, 755, 755, 755, 756, 756,
756, 756, 756, 756, 757, 757, 757, 757,
757, 758, 758, 758, 758, 758, 759, 759,
759, 759, 759, 760, 760, 760, 760, 760,
761, 761, 761, 761, 761, 761, 762, 762,
762, 762, 762, 763, 763, 763, 763, 763,
764, 764, 764, 764, 764, 764, 765, 765,
765, 765, 765, 766, 766, 766, 766, 766,
767, 767, 767, 767, 767, 768, 768, 768,
768, 768, 768, 769, 769, 769, 769, 769,
770, 770, 770, 770, 770, 770, 771, 771,
771, 771, 771, 772, 772, 772, 772, 772,
773, 773, 773, 773, 773, 773, 774, 774,
774, 774, 774, 775, 775, 775, 775, 775,
775, 776, 776, 776, 776, 776, 777, 777,
777, 777, 777, 777, 778, 778, 778, 778,
778, 779, 779, 779, 779, 779, 779, 780,
780, 780, 780, 780, 781, 781, 781, 781,
781, 781, 782, 782, 782, 782, 782, 783,
783, 783, 783, 783, 783, 784, 784, 784,
784, 784, 785, 785, 785, 785, 785, 785,
786, 786, 786, 786, 786, 787, 787, 787,
787, 787, 787, 788, 788, 788, 788, 788,
788, 789, 789, 789, 789, 789, 790, 790,
790, 790, 790, 790, 791, 791, 791, 791,
791, 791, 792, 792, 792, 792, 792, 792,
793, 793, 793, 793, 793, 794, 794, 794,
794, 794, 794, 795, 795, 795, 795, 795,
795, 796, 796, 796, 796, 796, 796, 797,
797, 797, 797, 797, 798, 798, 798, 798,
798, 798, 799, 799, 799, 799, 799, 799,
800, 800, 800, 800, 800, 800, 801, 801,
801, 801, 801, 801, 802, 802, 802, 802,
802, 802, 803, 803, 803, 803, 803, 803,
804, 804, 804, 804, 804, 804, 805, 805,
805, 805, 805, 806, 806, 806, 806, 806,
806, 807, 807, 807, 807, 807, 807, 808,
808, 808, 808, 808, 808, 809, 809, 809,
809, 809, 809, 809, 810, 810, 810, 810,
810, 810, 811, 811, 811, 811, 811, 811,
812, 812, 812, 812, 812, 812, 813, 813,
813, 813, 813, 813, 814, 814, 814, 814,
814, 814, 815, 815, 815, 815, 815, 815,
816, 816, 816, 816, 816, 816, 817, 817,
817, 817, 817, 817, 817, 818, 818, 818,
818, 818, 818, 819, 819, 819, 819, 819,
819, 820, 820, 820, 820, 820, 820, 821,
821, 821, 821, 821, 821, 821, 822, 822,
822, 822, 822, 822, 823, 823, 823, 823,
823, 823, 824, 824, 824, 824, 824, 824,
824, 825, 825, 825, 825, 825, 825, 826,
826, 826, 826, 826, 826, 826, 827, 827,
827, 827, 827, 827, 828, 828, 828, 828,
828, 828, 829, 829, 829, 829, 829, 829,
829, 830, 830, 830, 830, 830, 830, 831,
831, 831, 831, 831, 831, 831, 832, 832,
832, 832, 832, 832, 832, 833, 833, 833,
833, 833, 833, 834, 834, 834, 834, 834,
834, 834, 835, 835, 835, 835, 835, 835,
836, 836, 836, 836, 836, 836, 836, 837,
837, 837, 837, 837, 837, 837, 838, 838,
838, 838, 838, 838, 838, 839, 839, 839,
839, 839, 839, 840, 840, 840, 840, 840,
840, 840, 841, 841, 841, 841, 841, 841,
841, 842, 842, 842, 842, 842, 842, 842,
843, 843, 843, 843, 843, 843, 843, 844,
844, 844, 844, 844, 844, 844, 845, 845,
845, 845, 845, 845, 845, 846, 846, 846,
846, 846, 846, 846, 847, 847, 847, 847,
847, 847, 847, 848, 848, 848, 848, 848,
848, 848, 849, 849, 849, 849, 849, 849,
849, 850, 850, 850, 850, 850, 850, 850,
851, 851, 851, 851, 851, 851, 851, 852,
852, 852, 852, 852, 852, 852, 853, 853,
853, 853, 853, 853, 853, 854, 854, 854,
854, 854, 854, 854, 854, 855, 855, 855,
855, 855, 855, 855, 856, 856, 856, 856,
856, 856, 856, 857, 857, 857, 857, 857,
857, 857, 857, 858, 858, 858, 858, 858,
858, 858, 859, 859, 859, 859, 859, 859,
859, 860, 860, 860, 860, 860, 860, 860,
860, 861, 861, 861, 861, 861, 861, 861,
862, 862, 862, 862, 862, 862, 862, 862,
863, 863, 863, 863, 863, 863, 863, 864,
864, 864, 864, 864, 864, 864, 864, 865,
865, 865, 865, 865, 865, 865, 865, 866,
866, 866, 866, 866, 866, 866, 867, 867,
867, 867, 867, 867, 867, 867, 868, 868,
868, 868, 868, 868, 868, 868, 869, 869,
869, 869, 869, 869, 869, 869, 870, 870,
870, 870, 870, 870, 870, 871, 871, 871,
871, 871, 871, 871, 871, 872, 872, 872,
872, 872, 872, 872, 872, 873, 873, 873,
873, 873, 873, 873, 873, 874, 874, 874,
874, 874, 874, 874, 874, 875, 875, 875,
875, 875, 875, 875, 875, 876, 876, 876,
876, 876, 876, 876, 876, 877, 877, 877,
877, 877, 877, 877, 877, 877, 878, 878,
878, 878, 878, 878, 878, 878, 879, 879,
879, 879, 879, 879, 879, 879, 880, 880,
880, 880, 880, 880, 880, 880, 881, 881,
881, 881, 881, 881, 881, 881, 881, 882,
882, 882, 882, 882, 882, 882, 882, 883,
883, 883, 883, 883, 883, 883, 883, 883,
884, 884, 884, 884, 884, 884, 884, 884,
885, 885, 885, 885, 885, 885, 885, 885,
885, 886, 886, 886, 886, 886, 886, 886,
886, 887, 887, 887, 887, 887, 887, 887,
887, 887, 888, 888, 888, 888, 888, 888,
888, 888, 888, 889, 889, 889, 889, 889,
889, 889, 889, 890, 890, 890, 890, 890,
890, 890, 890, 890, 891, 891, 891, 891,
891, 891, 891, 891, 891, 892, 892, 892,
892, 892, 892, 892, 892, 892, 893, 893,
893, 893, 893, 893, 893, 893, 893, 894,
894, 894, 894, 894, 894, 894, 894, 894,
895, 895, 895, 895, 895, 895, 895, 895,
895, 896, 896, 896, 896, 896, 896, 896,
896, 896, 897, 897, 897, 897, 897, 897,
897, 897, 897, 897, 898, 898, 898, 898,
898, 898, 898, 898, 898, 899, 899, 899,
899, 899, 899, 899, 899, 899, 900, 900,
900, 900, 900, 900, 900, 900, 900, 900,
901, 901, 901, 901, 901, 901, 901, 901,
901, 902, 902, 902, 902, 902, 902, 902,
902, 902, 902, 903, 903, 903, 903, 903,
903, 903, 903, 903, 904, 904, 904, 904,
904, 904, 904, 904, 904, 904, 905, 905,
905, 905, 905, 905, 905, 905, 905, 905,
906, 906, 906, 906, 906, 906, 906, 906,
906, 906, 907, 907, 907, 907, 907, 907,
907, 907, 907, 907, 908, 908, 908, 908,
908, 908, 908, 908, 908, 908, 909, 909,
909, 909, 909, 909, 909, 909, 909, 909,
910, 910, 910, 910, 910, 910, 910, 910,
910, 910, 911, 911, 911, 911, 911, 911,
911, 911, 911, 911, 912, 912, 912, 912,
912, 912, 912, 912, 912, 912, 913, 913,
913, 913, 913, 913, 913, 913, 913, 913,
913, 914, 914, 914, 914, 914, 914, 914,
914, 914, 914, 915, 915, 915, 915, 915,
915, 915, 915, 915, 915, 915, 916, 916,
916, 916, 916, 916, 916, 916, 916, 916,
917, 917, 917, 917, 917, 917, 917, 917,
917, 917, 917, 918, 918, 918, 918, 918,
918, 918, 918, 918, 918, 918, 919, 919,
919, 919, 919, 919, 919, 919, 919, 919,
919, 920, 920, 920, 920, 920, 920, 920,
920, 920, 920, 920, 921, 921, 921, 921,
921, 921, 921, 921, 921, 921, 921, 922,
922, 922, 922, 922, 922, 922, 922, 922,
922, 922, 923, 923, 923, 923, 923, 923,
923, 923, 923, 923, 923, 924, 924, 924,
924, 924, 924, 924, 924, 924, 924, 924,
924, 925, 925, 925, 925, 925, 925, 925,
925, 925, 925, 925, 926, 926, 926, 926,
926, 926, 926, 926, 926, 926, 926, 926,
927, 927, 927, 927, 927, 927, 927, 927,
927, 927, 927, 927, 928, 928, 928, 928,
928, 928, 928, 928, 928, 928, 928, 929,
929, 929, 929, 929, 929, 929, 929, 929,
929, 929, 929, 930, 930, 930, 930, 930,
930, 930, 930, 930, 930, 930, 930, 931,
931, 931, 931, 931, 931, 931, 931, 931,
931, 931, 931, 931, 932, 932, 932, 932,
932, 932, 932, 932, 932, 932, 932, 932,
933, 933, 933, 933, 933, 933, 933, 933,
933, 933, 933, 933, 934, 934, 934, 934,
934, 934, 934, 934, 934, 934, 934, 934,
934, 935, 935, 935, 935, 935, 935, 935,
935, 935, 935, 935, 935, 935, 936, 936,
936, 936, 936, 936, 936, 936, 936, 936,
936, 936, 937, 937, 937, 937, 937, 937,
937, 937, 937, 937, 937, 937, 937, 938,
938, 938, 938, 938, 938, 938, 938, 938,
938, 938, 938, 938, 939, 939, 939, 939,
939, 939, 939, 939, 939, 939, 939, 939,
939, 939, 940, 940, 940, 940, 940, 940,
940, 940, 940, 940, 940, 940, 940, 941,
941, 941, 941, 941, 941, 941, 941, 941,
941, 941, 941, 941, 942, 942, 942, 942,
942, 942, 942, 942, 942, 942, 942, 942,
942, 942, 943, 943, 943, 943, 943, 943,
943, 943, 943, 943, 943, 943, 943, 943,
944, 944, 944, 944, 944, 944, 944, 944,
944, 944, 944, 944, 944, 944, 945, 945,
945, 945, 945, 945, 945, 945, 945, 945,
945, 945, 945, 945, 946, 946, 946, 946,
946, 946, 946, 946, 946, 946, 946, 946,
946, 946, 947, 947, 947, 947, 947, 947,
947, 947, 947, 947, 947, 947, 947, 947,
947, 948, 948, 948, 948, 948, 948, 948,
948, 948, 948, 948, 948, 948, 948, 949,
949, 949, 949, 949, 949, 949, 949, 949,
949, 949, 949, 949, 949, 949, 950, 950,
950, 950, 950, 950, 950, 950, 950, 950,
950, 950, 950, 950, 950, 951, 951, 951,
951, 951, 951, 951, 951, 951, 951, 951,
951, 951, 951, 951, 952, 952, 952, 952,
952, 952, 952, 952, 952, 952, 952, 952,
952, 952, 952, 952, 953, 953, 953, 953,
953, 953, 953, 953, 953, 953, 953, 953,
953, 953, 953, 954, 954, 954, 954, 954,
954, 954, 954, 954, 954, 954, 954, 954,
954, 954, 954, 955, 955, 955, 955, 955,
955, 955, 955, 955, 955, 955, 955, 955,
955, 955, 955, 956, 956, 956, 956, 956,
956, 956, 956, 956, 956, 956, 956, 956,
956, 956, 956, 957, 957, 957, 957, 957,
957, 957, 957, 957, 957, 957, 957, 957,
957, 957, 957, 957, 958, 958, 958, 958,
958, 958, 958, 958, 958, 958, 958, 958,
958, 958, 958, 958, 958, 959, 959, 959,
959, 959, 959, 959, 959, 959, 959, 959,
959, 959, 959, 959, 959, 959, 960, 960,
960, 960, 960, 960, 960, 960, 960, 960,
960, 960, 960, 960, 960, 960, 960, 961,
961, 961, 961, 961, 961, 961, 961, 961,
961, 961, 961, 961, 961, 961, 961, 961,
962, 962, 962, 962, 962, 962, 962, 962,
962, 962, 962, 962, 962, 962, 962, 962,
962, 962, 963, 963, 963, 963, 963, 963,
963, 963, 963, 963, 963, 963, 963, 963,
963, 963, 963, 963, 964, 964, 964, 964,
964, 964, 964, 964, 964, 964, 964, 964,
964, 964, 964, 964, 964, 964, 965, 965,
965, 965, 965, 965, 965, 965, 965, 965,
965, 965, 965, 965, 965, 965, 965, 965,
965, 966, 966, 966, 966, 966, 966, 966,
966, 966, 966, 966, 966, 966, 966, 966,
966, 966, 966, 966, 967, 967, 967, 967,
967, 967, 967, 967, 967, 967, 967, 967,
967, 967, 967, 967, 967, 967, 967, 968,
968, 968, 968, 968, 968, 968, 968, 968,
968, 968, 968, 968, 968, 968, 968, 968,
968, 968, 969, 969, 969, 969, 969, 969,
969, 969, 969, 969, 969, 969, 969, 969,
969, 969, 969, 969, 969, 969, 970, 970,
970, 970, 970, 970, 970, 970, 970, 970,
970, 970, 970, 970, 970, 970, 970, 970,
970, 970, 971, 971, 971, 971, 971, 971,
971, 971, 971, 971, 971, 971, 971, 971,
971, 971, 971, 971, 971, 971, 971, 972,
972, 972, 972, 972, 972, 972, 972, 972,
972, 972, 972, 972, 972, 972, 972, 972,
972, 972, 972, 972, 973, 973, 973, 973,
973, 973, 973, 973, 973, 973, 973, 973,
973, 973, 973, 973, 973, 973, 973, 973,
973, 974, 974, 974, 974, 974, 974, 974,
974, 974, 974, 974, 974, 974, 974, 974,
974, 974, 974, 974, 974, 974, 974, 975,
975, 975, 975, 975, 975, 975, 975, 975,
975, 975, 975, 975, 975, 975, 975, 975,
975, 975, 975, 975, 975, 976, 976, 976,
976, 976, 976, 976, 976, 976, 976, 976,
976, 976, 976, 976, 976, 976, 976, 976,
976, 976, 976, 976, 977, 977, 977, 977,
977, 977, 977, 977, 977, 977, 977, 977,
977, 977, 977, 977, 977, 977, 977, 977,
977, 977, 977, 978, 978, 978, 978, 978,
978, 978, 978, 978, 978, 978, 978, 978,
978, 978, 978, 978, 978, 978, 978, 978,
978, 978, 979, 979, 979, 979, 979, 979,
979, 979, 979, 979, 979, 979, 979, 979,
979, 979, 979, 979, 979, 979, 979, 979,
979, 979, 980, 980, 980, 980, 980, 980,
980, 980, 980, 980, 980, 980, 980, 980,
980, 980, 980, 980, 980, 980, 980, 980,
980, 980, 980, 981, 981, 981, 981, 981,
981, 981, 981, 981, 981, 981, 981, 981,
981, 981, 981, 981, 981, 981, 981, 981,
981, 981, 981, 981, 982, 982, 982, 982,
982, 982, 982, 982, 982, 982, 982, 982,
982, 982, 982, 982, 982, 982, 982, 982,
982, 982, 982, 982, 982, 982, 983, 983,
983, 983, 983, 983, 983, 983, 983, 983,
983, 983, 983, 983, 983, 983, 983, 983,
983, 983, 983, 983, 983, 983, 983, 983,
984, 984, 984, 984, 984, 984, 984, 984,
984, 984, 984, 984, 984, 984, 984, 984,
984, 984, 984, 984, 984, 984, 984, 984,
984, 984, 984, 985, 985, 985, 985, 985,
985, 985, 985, 985, 985, 985, 985, 985,
985, 985, 985, 985, 985, 985, 985, 985,
985, 985, 985, 985, 985, 985, 985, 986,
986, 986, 986, 986, 986, 986, 986, 986,
986, 986, 986, 986, 986, 986, 986, 986,
986, 986, 986, 986, 986, 986, 986, 986,
986, 986, 986, 987, 987, 987, 987, 987,
987, 987, 987, 987, 987, 987, 987, 987,
987, 987, 987, 987, 987, 987, 987, 987,
987, 987, 987, 987, 987, 987, 987, 987,
988, 988, 988, 988, 988, 988, 988, 988,
988, 988, 988, 988, 988, 988, 988, 988,
988, 988, 988, 988, 988, 988, 988, 988,
988, 988, 988, 988, 988, 988, 989, 989,
989, 989, 989, 989, 989, 989, 989, 989,
989, 989, 989, 989, 989, 989, 989, 989,
989, 989, 989, 989, 989, 989, 989, 989,
989, 989, 989, 989, 989, 990, 990, 990,
990, 990, 990, 990, 990, 990, 990, 990,
990, 990, 990, 990, 990, 990, 990, 990,
990, 990, 990, 990, 990, 990, 990, 990,
990, 990, 990, 990, 991, 991, 991, 991,
991, 991, 991, 991, 991, 991, 991, 991,
991, 991, 991, 991, 991, 991, 991, 991,
991, 991, 991, 991, 991, 991, 991, 991,
991, 991, 991, 991, 991, 992, 992, 992,
992, 992, 992, 992, 992, 992, 992, 992,
992, 992, 992, 992, 992, 992, 992, 992,
992, 992, 992, 992, 992, 992, 992, 992,
992, 992, 992, 992, 992, 992, 993, 993,
993, 993, 993, 993, 993, 993, 993, 993,
993, 993, 993, 993, 993, 993, 993, 993,
993, 993, 993, 993, 993, 993, 993, 993,
993, 993, 993, 993, 993, 993, 993, 993,
993, 994, 994, 994, 994, 994, 994, 994,
994, 994, 994, 994, 994, 994, 994, 994,
994, 994, 994, 994, 994, 994, 994, 994,
994, 994, 994, 994, 994, 994, 994, 994,
994, 994, 994, 994, 994, 995, 995, 995,
995, 995, 995, 995, 995, 995, 995, 995,
995, 995, 995, 995, 995, 995, 995, 995,
995, 995, 995, 995, 995, 995, 995, 995,
995, 995, 995, 995, 995, 995, 995, 995,
995, 995, 996, 996, 996, 996, 996, 996,
996, 996, 996, 996, 996, 996, 996, 996,
996, 996, 996, 996, 996, 996, 996, 996,
996, 996, 996, 996, 996, 996, 996, 996,
996, 996, 996, 996, 996, 996, 996, 996,
997, 997, 997, 997, 997, 997, 997, 997,
997, 997, 997, 997, 997, 997, 997, 997,
997, 997, 997, 997, 997, 997, 997, 997,
997, 997, 997, 997, 997, 997, 997, 997,
997, 997, 997, 997, 997, 997, 997, 997,
998, 998, 998, 998, 998, 998, 998, 998,
998, 998, 998, 998, 998, 998, 998, 998,
998, 998, 998, 998, 998, 998, 998, 998,
998, 998, 998, 998, 998, 998, 998, 998,
998, 998, 998, 998, 998, 998, 998, 998,
998, 999, 999, 999, 999, 999, 999, 999,
999, 999, 999, 999, 999, 999, 999, 999,
999, 999, 999, 999, 999, 999, 999, 999,
999, 999, 999, 999, 999, 999, 999, 999,
999, 999, 999, 999, 999, 999, 999, 999,
999, 999, 999, 999, 1000, 1000, 1000, 1000,
1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
1001, 1001, 1001, 1001, 1001, 1001, 1001, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1002, 1002, 1002, 1002, 1002, 1002, 1002, 1002,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
1003, 1003, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
1006, 1006, 1006, 1006, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
1007, 1007, 1007, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
1008, 1008, 1008, 1008, 1008, 1008, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
1009, 1009, 1009, 1009, 1009, 1009, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
1010, 1010, 1010, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
1011, 1011, 1011, 1011, 1011, 1011, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
1013, 1013, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
1014, 1014, 1014, 1014, 1014, 1014, 1014, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015,
1015, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
1016, 1016, 1016, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
1017, 1017, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018,
1018, 1018, 1018, 1018, 1018, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019,
1019, 1019, 1019, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
1020, 1020, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022 };

/* end semi_linears table definition */
#endif


Sint  A_activation(sum)
D_Sint  sum;
/*
----------------------------------------------------------------------
 All that is done here is to take the incoming argument, convert it to
  an index, and then use the 'semi_linears' table to return the value   
  stored for the resulting Sint.  The only trick is to remember that  
  if a NEGATIVE value comes in, then you need to return 1 (in Sint    
  form) minus the value retrieved from 'semi_linears'.                
----------------------------------------------------------------------
*/
BEGIN
#if   USE_SCALED_INTS
   static Sint  high_Sint = (MAX_SUM - 1);
   static Sint  low_Sint  = ((MAX_SUM -1) * -1);
   int          isum;

   if (sum > high_Sint) 
      sum = high_Sint;
   else if (sum < low_Sint)
      sum = low_Sint;

   isum = (int) sum;                /* isum = sum as an index the array */
   if (isum >= 0)
      return(semi_linears[isum]);
   return(SINT_SCALE - semi_linears[isum * -1]);
#else
   return( (Sint)(1.0 / (1.0 + exp(-1.0 * sum))) );
#endif

END /* A_activation */

