;;****************************************************************************
;;                      declare.inc         declare.inc
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; Due to limitations in TURBO ASSEMBLER, we have to compile PCroute in 
;; pieces.  declare.inc is a 'header' file that constains the declarations
;; of all compile-time information that is shared among seperately compiled
;; pieces.  
;;
;;  AUTHOR: Vance Morrison  
;;  DATE:   4/28/89  
;;****************************************************************************

    .MODEL SMALL

    JUMPS                       ;; deal with long jump displacements 
                                ;; automatically
    .CODE                       ;; extablish the default segment

    include debug.inc
    include log.inc
    include timer.inc
    include tasks.inc
    include buffer.inc
    include queue.inc
    include memory.inc 

        ;; files for hardware support
   ;include wd8003.inc           ;; need for starlan cards
   ;include wd8003e.inc     
    include 3c507.inc
   ;include packet.inc
   ;include bridge.inc           ;; need for the bridge-router only
   ;include qif.inc              ;; needed for slip only
   ;include slip.inc             ;; needed for slip only 
   ;include i8250.inc            ;; needed for slip only
   ;include pp.inc               ;; needed for slip only
   ;include atalk.inc

        ;; high level code
    include if.inc
    include ether.inc
    include arptab.inc
    include arp.inc
    include dl_ip.inc
    include rip.inc
    include ip.inc
    include icmp.inc
    include udp.inc
    include bootp.inc 

    DB_DECLARE                  ;; declare debugging routines

    cur_dl = 1

            ;; designed for 1st WD card (assumes D0000-D7FFF is free)
        ; this is a wd8013EBT entry
 ;  WDE_DECLARE %cur_dl, 280H, 0D000H, 0,0,64,1  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003EBT entry
 ;  WDE_DECLARE %cur_dl, 280H, 0D000H, 0,0,128,0 ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003E entry
 ;  WDE_DECLARE %cur_dl, 280H, 0D000H, 0,0,32,0  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a starlan entry
 ;  WD_DECLARE %cur_dl, 280H, 0D000H, 0,10,16 ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task>
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

            ;; designed for 2nd WD card (assumes D8000-DFFFF is free)
        ; this is a wd8013EBT entry
 ;  WDE_DECLARE %cur_dl, 2A0H, 0D800H, 0,0,64,1  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003EBT entry
 ;  WDE_DECLARE %cur_dl, 2A0H, 0D800H, 0,0,128,0 ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003E entry
 ;  WDE_DECLARE %cur_dl, 2A0H, 0D800H, 0,0,32,0  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a starlan entry
 ;  WD_DECLARE %cur_dl, 2A0H, 0D800H, 0,10,16 ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

            ;; designed for 3rd WD card (assumes A0000-A7FFF is free)
 ;      ; this is a wd8013EBT entry
 ;  WDE_DECLARE %cur_dl, 2C0H, 0A000H, 0,0,64,1  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003EBT entry
 ;  WDE_DECLARE %cur_dl, 2C0H, 0A000H, 0,0,128,0 ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a wd8003E entry
 ;  WDE_DECLARE %cur_dl, 2C0H, 0A000H, 0,0,32,0  ;;<name>, <I/O>, <seg>, <off>
 ;      ; this is a starlan entry
 ;  WD_DECLARE %cur_dl, 2E0H, 0A000H, 0,10,16 ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %cur_dl, %cur_dl, WDE        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; a 3C507 card entry 64K of memory at D0000H
    C507_DECLARE %cur_dl, 280H, 0D000H, 10000H, 0   ;; name,io,seg,len,prom
    IF_DECLARE %cur_dl, %cur_dl, C507
    ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
    ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
    DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
    cur_dl = cur_dl + 1

        ;; a 3C507 card entry 64K of memory at C0000H
    C507_DECLARE %cur_dl, 2A0H, 0C000H, 10000H, 0   ;; name,io,seg,len,prom
    IF_DECLARE %cur_dl, %cur_dl, C507
    ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
    ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
    DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
    cur_dl = cur_dl + 1

    ;; this is a packet driver entry
 ;  PKT_DECLARE %cur_dl, 60H, 01        ;; <name>, <Int Num> <Class (Eth=1)>
 ;  IF_DECLARE %cur_dl, %cur_dl, PKT        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

    ;; this is a packet driver entry
 ;  PKT_DECLARE %cur_dl, 61H, 01        ;; <name>, <Int Num> <Class (Eth=1)>
 ;  IF_DECLARE %cur_dl, %cur_dl, PKT        ;; <if name>, <real if>, <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task> 
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; this is a SLIP entry for COM1
 ;  I8250_DECLARE %cur_dl, SLIP, %cur_dl, IBM_COM1_PORT, IBM_COM1_IRQ, 0
 ;  tmp = cur_dl*100                                 ;; generate temp names
 ;  BUFF_DECLARE %(tmp+1), 3200                      ;; the read buffer
 ;  QUEUE_DECLARE %(tmp+2), 5, %(size qif_entry)     ;; the read queue
 ;  BUFF_DECLARE %(tmp+3), 10240                     ;; the write buffer
 ;  QUEUE_DECLARE %(tmp+4), 16, %(size qif_entry) ;; the write queue
 ;  SLIP_DECLARE %cur_dl,%cur_dl,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4)
 ;  Q_IF_DECLARE %cur_dl,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4),SLIP,%cur_dl
 ;  IF_DECLARE %cur_dl, %cur_dl, Q
 ;  PP_DECLARE %cur_dl, %cur_dl, %cur_dl
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, PP   ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; this is a SLIP entry for COM2
 ;  I8250_DECLARE %cur_dl, SLIP, %cur_dl, IBM_COM2_PORT, IBM_COM2_IRQ, 0
 ;  tmp = cur_dl*100                                 ;; generate temp names
 ;  BUFF_DECLARE %(tmp+1), 3200                      ;; the read buffer
 ;  QUEUE_DECLARE %(tmp+2), 5, %(size qif_entry)     ;; the read queue
 ;  BUFF_DECLARE %(tmp+3), 10240                     ;; the write buffer
 ;  QUEUE_DECLARE %(tmp+4), 16, %(size qif_entry) ;; the write queue
 ;  SLIP_DECLARE %cur_dl,%cur_dl,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4)
 ;  Q_IF_DECLARE %cur_dl,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4),SLIP,%cur_dl
 ;  IF_DECLARE %cur_dl, %cur_dl, Q
 ;  PP_DECLARE %cur_dl, %cur_dl, %cur_dl
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, PP   ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; localtalk interface
 ;  ATP_DECLARE %cur_dl, 60H, %cur_dl, 10, 2000 ;; <name> <int> <task> <wqueue>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ATP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1

        ;; FOR A BRIDGE ROUTER
;;***************************************************************************
    bdg_start = 5
    bdg_dl = bdg_start

        ;; declare IF 1
 ;  WDE_DECLARE %bdg_dl, 280H, 0D000H,0,1,32,0  ;;<name>, <I/O>, <seg>, <off>
 ;  WDE_DECLARE %bdg_dl, 280H, 0D000H,0,1,64,1  ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %bdg_dl, %bdg_dl, WDE       ;; <if name>, <real if>, <prefix>
 ;  bdg_dl = bdg_dl + 1

        ;; a 3C507 card entry 64K of memory at D0000H
 ;  C507_DECLARE %bdg_dl, 280H, 0D000H, 10000H, 1   ;; name,io,seg,len,prom
 ;  IF_DECLARE %bdg_dl, %bdg_dl, C507
 ;  bdg_dl = bdg_dl + 1

        ;; declare IF 2
 ;  WDE_DECLARE %bdg_dl, 2A0H, 0D800H, 0,1,32,0  ;;<name>, <I/O>, <seg>, <off>
 ;  WDE_DECLARE %bdg_dl, 2A0H, 0D800H, 0,1,64,1  ;;<name>, <I/O>, <seg>, <off>
 ;  IF_DECLARE %bdg_dl, %bdg_dl, WDE       ;; <if name>, <real if>, <prefix>
 ;  bdg_dl = bdg_dl + 1

        ;; a 3C507 card entry 64K of memory at C0000H
 ;  C507_DECLARE %bdg_dl, 2A0H, 0C000H, 10000H, 1   ;; name,io,seg,len,prom
 ;  IF_DECLARE %bdg_dl, %bdg_dl, C507
 ;  bdg_dl = bdg_dl + 1

        ;; declare that these are BRIDGED
 ;  BDG_DECLARE 1,%bdg_start,%(bdg_dl-1),0  ;; <name> <start> <end> <forward ip>
 ;  bdg_dl = bdg_start

 ;  IF_DECLARE %cur_dl, %bdg_dl, BDG        ;; <name> <real if> <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task>
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1
 ;  bdg_dl = bdg_dl + 1

 ;  IF_DECLARE %cur_dl, %bdg_dl, BDG        ;; <name> <real if> <prefix>
 ;  ETH_DECLARE %cur_dl, %cur_dl, %cur_dl   ;; <eth name>, <if>, <task>
 ;  ARP_DECLARE %cur_dl, %cur_dl            ;; <arp name>, <ether>
 ;  DL_IP_DECLARE %cur_dl, %cur_dl, ARP     ;; <dlip name>, <real dlip> <prefix>
 ;  cur_dl = cur_dl + 1
 ;  bdg_dl = bdg_dl + 1

;; end of declarations
;;****************************************************************************

    num_dls = cur_dl - 1
    task_timer = cur_dl
    num_tasks  = cur_dl

    SCHED_DECLARE %num_tasks

    mytimer     = 10                        ;; WD_DECLARE Depends on this value
    TIMER_DECLARE %mytimer, %task_timer

    myip = 11
    myrip = 12
    myicmp = 13
    myudp = 14
    mybootp = 15
    mylog = 16
    dlog = 17
    IP_DECLARE %myip, %myrip, %num_dls, %myicmp
    UDP_DECLARE %myudp, %myip, %myicmp
    RIP_DECLARE %myrip, %myip, %mytimer, %myudp
    ICMP_DECLARE %myicmp, %myip, %myrip
    BOOTP_DECLARE %mybootp, %myudp, %num_dls
    LOG_DECLARE %mylog, LOG_LOCAL0, %myudp, %mytimer
