Unit Editify;
{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}

Interface

Uses
    Crt,Dos,Errorify;

Var
   TextName : String;
   Size,SizBuf : Word;
 { ***********************************************************************
   - Modified, c'est par rapport au disque : le contenu du buffer concide
     t'il avec le contenu du fichier sur disque ???
   - Touched, c'est par rapport  l'tat d'origine du buffer en mmoire.
     Le contenu du buffer a t'il t modifi ??? C'est DE L'EXTERIEUR
     qu'on est cens mettre Touched  False. Dans l'ed, on le met tou-
     -jours  True, jamais  False (Sauf dans l'init).
   *********************************************************************** }
   Modified,Touched : Boolean;

{ T_CTRL(x)     (x-'@')
  T_F(n)        (0x3a00+0x100*n)
  T_ALT_F(n)    (0x6700+0x100*n)
  T_CTRL_F(n)   (0x5d00+0x100*n) }
Const
     T_CR        =$000D;
     T_BS        =$0008;
     T_TAB       =$0009;
     T_CTRL_CR   =$000A;
     T_ESC       =$001B;
     T_RIGHT     =$4D00;
     T_LEFT      =$4B00;
     T_UP        =$4800;
     T_DOWN      =$5000;
     T_HOME      =$4700;
     T_END       =$4F00;
     T_PGUP      =$4900;
     T_PGDWN     =$5100;
     T_INS       =$5200;
     T_DEL       =$5300;
     T_CTRL_RIGHT=$7400;
     T_CTRL_LEFT =$7300;
     T_CTRL_HOME =$7700;
     T_CTRL_END  =$7500;
     T_CTRL_PGUP =$8400;
     T_CTRL_PGDWN=$7600;
     T_CTRL_I    =Ord('I')-Ord('@');
     T_CTRL_K    =Ord('K')-Ord('@');
     T_CTRL_B    =Ord('B')-Ord('@');
     T_CTRL_C    =Ord('C')-Ord('@');
     T_CTRL_V    =Ord('V')-Ord('@');
     T_CTRL_Y    =Ord('Y')-Ord('@');
     T_CTRL_Q    =Ord('Q')-Ord('@');
     T_CTRL_R    =Ord('R')-Ord('@');
     T_CTRL_W    =Ord('W')-Ord('@');
     T_ALT_C     =$2E00;
     T_ALT_R     =$1300;
     T_ALT_Q     =$1000;
     T_ALT_E     =$1200;
     T_ALT_M     =$3200;
     T_ALT_X     =$2D00;
     T_ALT_D     =$2000;
     T_F1        =$3A00+$100*1;
     T_F2        =$3A00+$100*2;
     T_F3        =$3A00+$100*3;
     T_F4        =$3A00+$100*4;

Function GetCar : Word;
Function GetCurPos : Word;
Procedure Locate(Li,Col : Word);
Procedure SetCursShape(S : Word);

Var
   EditErrorHandler : ErrorHandler1;

Procedure PrintMessage(Li,Col : Word; S : String);

Function ScaSB(Ptr : Pointer; V : Byte; N : Word) : Word;
Procedure StoSB(Ptr : Pointer; V : Byte; N : Word);
Procedure StoSW(Ptr : Pointer; V,N : Word);
Procedure MovSB(Src,Dest : Pointer; N : Word);
Procedure UpCaseString(Var S : String);

Procedure LCNPutString(Li,Col : Word; Color : Byte; Ptr : Pointer; Len : Byte);
Function LCInput(Li,Col0 : Word; Width,Color : Byte; Var Buf : String; LenMax : Byte) : Word;

Function AtBeg(Ptr : Word) : Word;
Function Ptr2Line(Count : Word) : Word;
Function Line2Ptr(L : Word) : Word;

Procedure DelCharsAndInsert(Where,ND,V,NI : Word);
Procedure DelCharsAndInsBlock(Where,ND : Word; Block : Pointer; NI : Word);
Procedure ResetEditDataStruct;
Procedure SetBuffer(Buffer : Pointer; Len : Word);
Function GetBuffer : Pointer;

Function AllocTextBuf(SizeBlock : Word) : Pointer;
Procedure LoadText(S : String);
Procedure SaveText(S : String);

Procedure PrintText(First,Col0,Li0,Li1 : Word);
Procedure PrintBanner(Li0 : Word);

Var
   EnterMessage : String;
   LiToGo : Word;

Function EditText(LiBanner,LiEOT : Word) : Word;

Type
    ProcVarString=Procedure(Var S : String);
Var
   AdjustFileName : ProcVarString;

Procedure ActUpRename(Li0Banner,Col : Word);
Procedure ActUpSave(Li0Banner,Col : Word);
Procedure ActUpModified(Li0Banner,Col : Word);
Procedure ActUpLoad(Li0Banner,Col : Word);

Var
   RefreshFlag : Boolean;

Implementation

{ **************
  Struct data ed
  ************** }
Type
    ByteBuf=Array[0..$FFFE] Of Byte;
    ByteBufPtr=^ByteBuf;
    WordBuf=Array[0..$7FFE] Of Word;
    TextBuf=ByteBuf;
    TextBufPtr=^TextBuf;
    BytePtr=^Byte;
    WordPtr=^Word;
Var
   Buf : TextBufPtr;
   K1,K2 : Word;
   Col0,Col,Li,LiHome,First,N : Word;
   Li0Banner,Li0,Li1 : Word;
   ColorText,ColorMarked,ColorTildas,ColorBanner : Word;
   Insert,Indent : Boolean;

{ ***********
  cran texte
  *********** }
Const
     Screen : ^WordBuf=Pointer($B8000000);
     NormalShape=$0008;
Var
   NbCol,CursShape : Word;


{ ****************
  Fonctions KbdScr
  **************** }
Function GetCar : Word;
Var
   R : Registers;
Begin
  R.AX:=0;
  Intr($16,R);
  If R.AX And $00FF<>0 Then GetCar:=R.AX And $00FF
                       Else GetCar:=R.AX And $FF00;
End;

Function GetCurPos : Word;
Var
   R : Registers;
Begin
  R.AX:=$0300;
  R.BX:=0;
  Intr($10,R);
  GetCurPos:=R.DX;
End;

Procedure Locate(Li,Col : Word);
Var
   R : Registers;
Begin
  R.AX:=$0200;
  R.BX:=0;
  R.DX:=((Li-1) Shl 8)+Col-1;
  Intr($10,R);
End;

Procedure SetCursShape(S : Word);
Var
   R : Registers;
Begin
  R.AX:=$0100;
  R.CX:=S;
  Intr($10,R);
End;


{ *******************
  Traitement d'erreur
  ******************* }
Procedure PrintMessage(Li,Col : Word; S : String);
Begin
  Locate(Li,Col);
  TextAttr:=ColorBanner;
  ClrEOL;
  Write(S);
End;

Var
   ErrorReturnInitialized : Boolean;
   ErrorReturn : JumpBuf;

{$F+}
Procedure Handler(S : String);
Var
   Touche : Word;
Begin
  PrintMessage(Li0Banner,1,Concat(S,' -- Press any key '));
  Touche:=GetCar;
  PrintBanner(1);
  If ErrorReturnInitialized Then LongJump(ErrorReturn,1)
                            Else Halt;
End;
{$F-}


{ *************************************************
  Fonctions de traitement des chanes de caractres
  ************************************************* }
Function ScaSB(Ptr : Pointer; V : Byte; N : Word) : Word;
Var
   Resu : Word;
Begin
{ CLD }
  InLine($FC);
{ LES DI,[Ptr] }
  InLine($C4/$BE/Ptr);
{ MOV AL,[V] }
  InLine($8A/$86/V);
{ MOV CX,[N] }
  InLine($8B/$8E/N);
{ REPNZ SCASW }
  InLine($F2/$AE);
{ MOV Resu,CX }
  InLine($89/$8E/Resu);
  ScasB:=Resu;
End;

Procedure StoSB(Ptr : Pointer; V : Byte; N : Word);
Begin
{ CLD }
  InLine($FC);
{ LES DI,[Ptr] }
  InLine($C4/$BE/Ptr);
{ MOV AL,[V] }
  InLine($8A/$86/V);
{ MOV CX,[N] }
  InLine($8B/$8E/N);
{ REPZ STOSB }
  InLine($F3/$AA);
End;

Procedure StoSW(Ptr : Pointer; V,N : Word);
Begin
{ CLD }
  InLine($FC);
{ LES DI,[Ptr] }
  InLine($C4/$BE/Ptr);
{ MOV AX,[V] }
  InLine($8B/$86/V);
{ MOV CX,[N] }
  InLine($8B/$8E/N);
{ REPZ STOSW }
  InLine($F3/$AB);
End;

Procedure MovSB(Src,Dest : Pointer; N : Word);
Var
   OfsS,OfsD : LongInt;
Begin
{ Mmes segments }
  If LongInt(Src) And $FFFF0000<>LongInt(Dest) And $FFFF0000 Then EditErrorHandler('MovSB(1)');
{ Pas de dbordement }
  OfsS:=Word(Src);
  OfsD:=Word(Dest);
  If (OfsS+LongInt(N)>$FFFF) Or (OfsD+LongInt(N)>$FFFF) Then EditErrorHandler('MovSB(2)');
{ Choix direction }
  If OfsS>OfsD Then
  Begin
  { CLD }
    InLine($FC)
  End
  Else
  Begin
  { Se placer  la fin des deux blocs }
    Inc(Word(Src),N-1);
    Inc(Word(Dest),N-1);
  { STD }
    InLine($FD);
  End;
{ PUSH DS }
  InLine($1E);
{ LES SI,[Src] }
  InLine($C4/$B6/Src);
{ MOV BX,ES }
  InLine($8C/$C3);
{ MOV DS,BX }
  InLine($8E/$DB);
{ LES DI,[Dest] }
  InLine($C4/$BE/Dest);
{ MOV CX,[N] }
  InLine($8B/$8E/N);
{ REPZ MOVSB }
  InLine($F3/$A4);
{ POP DS }
  InLine($1F);
End;

Procedure UpCaseString(Var S : String);
Var
   I : Byte;
Begin
  For I:=1 To Ord(S[0]) Do S[I]:=UpCase(S[I]);
End;


{ ************************
  Fonction d'input Blinde
  ************************ }
Function Min(A,B : Word) : Word;
Begin
  If A>B Then Min:=B Else Min:=A;
End;

Procedure LCNPutString(Li,Col : Word; Color : Byte; Ptr : Pointer; Len : Byte);
Var
   I : Word;
Begin
  If Len>0 Then
    For I:=0 To Len-1 Do
       Screen^[(Li-1)*NbCol+Col+I-1]:=(Color Shl 8)+ByteBufPtr(Ptr)^[I];
End;

Function LCInput(Li,Col0 : Word; Width,Color : Byte; Var Buf : String; LenMax : Byte) : Word;
Var
   Insert : Boolean;
   Ptr,Col,I,L,Touche,Out : Word;
   OCursShape : Word;
Begin
  If LenMax>$FE Then LenMax:=$FE;
  OCursShape:=CursShape;
  Insert:=True;
  Ptr:=Length(Buf)+1;
  Col:=1;
  Out:=0;

  Repeat
    If Length(Buf)>LenMax Then Byte(Buf[0]):=LenMax;
    While (Length(Buf)>0) And (Buf[Length(Buf)]=' ') Do Dec(Byte(Buf[0]));
    If Ptr<1 Then Ptr:=1;
    If Ptr>=LenMax Then Ptr:=LenMax;
    If Ptr<Col Then Col:=Ptr;
    If Ptr-Col+1>Width Then Col:=Ptr+1-Width;
    If LenMax>=Width Then I:=Min(Col,LenMax-Width+1) Else I:=1;
    If Col>Length(Buf) Then L:=0 Else L:=Min(Length(Buf)-Col+1,Width);
    LCNPutString(Li,Col0,Color,@Buf[I],L);
    If L<Width Then StoSW(@Screen^[(Li-1)*NbCol+Col0+L-1],(Color Shl 8) Or $20,Width-L);
    Locate(Li,Col0+Ptr-I);
    If Insert Then SetCursShape(NormalShape) Else SetCursShape($0408);
    Touche:=GetCar;
    Case Touche Of
      T_RIGHT: Inc(Ptr);
      T_LEFT: Dec(Ptr);
      T_END:
      Begin
        Ptr:=Length(Buf);
        If (Ptr<>0) And (Buf[Ptr]<>' ') Then Inc(Ptr);
      End;
      T_HOME: Ptr:=1;
      T_INS: Insert:=Not Insert;
      T_BS: If Ptr>1 Then
      Begin
        Dec(Ptr);
        If (Length(Buf)<>0) And (Ptr<=Ord(Buf[0])) Then
        Begin
          For I:=Ptr To Length(Buf)-1 Do Buf[I]:=Buf[I+1];
          Dec(Byte(Buf[0]));
        End;
      End;
      T_DEL:
      If (Length(Buf)<>0) And (Ptr<=Ord(Buf[0])) Then
      Begin
        For I:=Ptr To Length(Buf)-1 Do Buf[I]:=Buf[I+1];
        Dec(Byte(Buf[0]));
      End;
      T_CR : Out:=Touche;
      T_ESC: Out:=Touche;
      T_CTRL_Y:
      Begin
        Byte(Buf[0]):=0;
        Ptr:=1;
      End;
      Else
      If Touche Shr 8=0 Then
      Begin
        If Length(Buf)<Ptr Then
        Begin
          For I:=Length(Buf)+1 To Ptr Do Buf[I]:=' ';
          Byte(Buf[0]):=Ptr;
        End;
        If Insert Then
        Begin
          For I:=LenMax-1 DownTo Ptr Do Buf[I+1]:=Buf[I];
          If Length(Buf)<=LenMax Then Inc(Byte(Buf[0]));
        End;
        Buf[Ptr]:=Chr(Touche);
        Inc(Ptr);
      End
      Else
        Out:=Touche;
    End;
  Until Out<>0;
  CursShape:=OCursShape;
  LCInput:=Out;
End;


{ **********************************************
  Fonctions de positionnement ds la struct. data
  ********************************************** }
Function AtBeg(Ptr : Word) : Word;
Begin
  If Ptr<Size Then
    While (Ptr<>0) And (Buf^[Ptr-1]<>$0A) Do Dec(Ptr)
  Else
    Ptr:=Size
  ;
  AtBeg:=Ptr;
End;

Var
   SkippedLines : Word;

Function NLinesBefore(Ptr,N : Word) : Word;
Label
     PrecLine;
Begin
  SkippedLines:=0;
  While N<>0 do
  Begin
    If Ptr<Size Then
      Begin
        While (Ptr<>0) And (Buf^[Ptr]<>$0A) Do Dec(Ptr);
        If Ptr<>0 Then
          Begin
PrecLine:
            Inc(SkippedLines);
            Dec(Ptr);
            If Buf^[Ptr]<>$0D Then EditErrorHandler('NLinesBefore');
          End;
      End
    Else
      Begin
        Ptr:=Size;
        If Ptr<>0 Then
          Begin
            Dec(Ptr);
            If Buf^[Ptr]=$0A Then
              If Ptr=0 Then EditErrorHandler('NLinesBefore(2)')
                       Else Goto PrecLine;
          End;
      End
    ;
    Dec(N);
  End;
  Ptr:=AtBeg(Ptr);
  NLinesBefore:=Ptr;
End;

Function NLinesAfter(Ptr,N : Word) : Word;
Begin
  SkippedLines:=0;
  While N<>0 Do
  Begin
    If Ptr<Size Then
      Begin
        While (Ptr<Size) And (Buf^[Ptr]<>$0D) Do Inc(Ptr);
        If Ptr<Size Then
          Begin
            Inc(Ptr);
            If (Ptr>=Size) Or (Buf^[Ptr]<>$0A) Then EditErrorHandler('NLinesAfter');
            Inc(Ptr);
          End
        Else
          Ptr:=Size;

        Inc(SkippedLines);
        Dec(N);
      End
    Else
      N:=0;
  End;
  NLinesAfter:=Ptr;
End;

Function Ptr2Line(Count : Word) : Word;
Var
   OldCount,Result,Ptr : Word;
Begin
  Ptr:=0;
  Result:=1;
  While Count<>0 Do
  Begin
    OldCount:=Count;
    Count:=ScaSB(@Buf^[Ptr],$0D,Count);
    If Count=0 Then
    Begin
      If (Buf^[Ptr+OldCount-1]=$0D) Then EditErrorHandler('Ptr2Line');
    End
    Else
    Begin
      Inc(Result);
      Inc(Ptr,OldCount-Count);
    End;
  End;
  Ptr2Line:=Result;
End;

Function TNbLig : Word;
Begin
  TNBlig:=Ptr2Line(Size);
End;

Function Line2Ptr(L : Word) : Word;
Var
   Count,OldCount,LiCour,Ptr : Word;
Begin
  Ptr:=0;
  LiCour:=1;
  Count:=Size;
  While (Count<>0) And (LiCour<L) Do
  Begin
    OldCount:=Count;
    Count:=ScaSB(@Buf^[Ptr],$0D,Count);
    If Count=0 Then
    Begin
      If (Buf^[Ptr+OldCount-1]=$0D) Then EditErrorHandler('Line2Ptr');
      Line2Ptr:=Size;
      Exit;
    End
    Else
    Begin
      Inc(LiCour);
      Inc(Ptr,OldCount-Count);
    End;
  End;
  If LiCour=1 Then Line2Ptr:=0 Else Line2Ptr:=Ptr+1;
End;

Function LineLength(Ptr : Word) : Word;
Var
   Ptr0 : Word;
Begin
  If Ptr>=Size Then Begin LineLength:=0;Exit; End;
  Ptr0:=Ptr;
  While (Ptr0>0) And (Buf^[Ptr0]<>$0A) Do Dec(Ptr0);
  If Buf^[Ptr0]=$0A Then
    If Ptr0=0 Then EditErrorHandler('LineLength')
    Else
      Inc(Ptr0);

  While (Ptr<Size) And (Buf^[Ptr]<>$0D) Do Inc(Ptr);
  LineLength:=Ptr-Ptr0;
End;

Function AtColNo(Ptr,Col : Word) : Word;
Var
   C : Word;
Begin
  C:=1;
  Ptr:=AtBeg(Ptr);
  While (Ptr<Size) And (C<Col) And (Buf^[Ptr]<>$0D) Do
  Begin
    Inc(Ptr);
    Inc(C);
  End;
  AtColNo:=Ptr;
End;

{ Ptr non compris }
Function NbSPacesBefore(Ptr : Word) : Word;
Var
   Resu : Word;
Begin
  Resu:=0;
  If Ptr<>0 Then
  Begin
    Dec(Ptr);
    While Buf^[Ptr]=$20 Do
    Begin
      Dec(Ptr);
      Inc(Resu);
    End;
  End;
  NbSPacesBefore:=Resu;
End;

Function NbSpacesAtBeg(Ptr : Word) : Word;
Var
   NS : Word;
Begin
  NS:=0;
  While (Ptr+NS<Size) And (Buf^[Ptr+NS]=$20) Do Inc(NS);
  NbSPacesAtBeg:=NS;
End;

Function NLinesBetween(A,B : Word) : Word;
Var
   Resu,I : Word;
Begin
  Resu:=0;
  For I:=A To B Do If Buf^[I]=$0D Then Inc(Resu);
  NLinesBetween:=Resu;
End;


{ **************************************
  Fonctions de modif. de la struct. data
  ************************************** }
Procedure MAJPtrs(W0,W1 : Word);
Begin
  If W0<W1 Then
  Begin
    If K1>W0 Then Inc(K1,W1-W0);
    If K2>W0 Then Inc(K2,W1-W0);
  End
  Else
  Begin
    If K1>=W0 Then Dec(K1,W0-W1) Else If K1>=W1 Then K1:=W1;
    If K2>=W0 Then Dec(K2,W0-W1) Else If K2>=W1 Then K2:=W1;
  End;
End;

{ Si High(V)<>0 Alors il faut NI=2
  Sinon, Si FillBlock=Nil on recopie NI fois Low(V)
         Sinon on copie les NI premiers bytes de FillBlock }
Var
   FillBlock : Pointer;

Procedure DelCharsAndInsert(Where,ND,V,NI : Word);
Var
   I : Word;
Begin
  If Where+ND>Size Then EditErrorHandler('Delchars&Ins(1)');
  If (LongInt(Size)+LongInt(NI)-LongInt(ND)>SizBuf) Or
     (LongInt(Size)+LongInt(NI)-LongInt(ND)<0)
  Then
    EditErrorHandler('Buffer too small')
  ;
  MAJPtrs(Where+ND,Where);
  MAJPtrs(Where,Where+NI);
  MovSB(@Buf^[Where+ND],@Buf^[Where+NI],Size-Where-ND);
  If V And $FF00<>0 Then
    Begin
      If NI<>2 Then EditErrorHandler('DelChars&Ins(2)');
      WordPtr(@Buf^[Where])^:=V;
    End
  Else
    If FillBlock<>Nil Then MovSB(FillBlock,@Buf^[Where],NI)
                      Else StoSB(@Buf^[Where],Byte(V),NI);
  Dec(Size,ND);
  Inc(Size,NI);
  If (ND<>0) Or (NI<>0) Then
  Begin
    Modified:=True;
    Touched:=True;
  End;
End;

Procedure DelCharsAndInsBlock(Where,ND : Word; Block : Pointer; NI : Word);
Var
   OFillBlock : Pointer;
Begin
  If Block=Nil Then EditErrorHandler('DelCharsAndInsBlock');
  OFillBlock:=FillBlock;
  FillBlock:=Block;
  DelCharsAndInsert(Where,ND,0,NI);
  FillBlock:=OFillBlock;
End;

{ Dtruit tous les spaces before Where, Where compris }
Var
   NbDeletedSpaces : Word;

Function DelSpacesBefore(Where : Word) : Word;
Begin
  NbDeletedSpaces:=1;
  While (Where>0) And (Buf^[Where]=$20) Do
  Begin
    Dec(Where);
    Inc(NbDeletedSpaces);
  End;
  If Buf^[Where]<>$20 Then
  Begin
    Inc(Where);
    Dec(NbDeletedSpaces);
  End;
  DelCharsAndInsert(Where,NbDeletedSpaces,0,0);
  DelSpacesBefore:=Where;
End;

Procedure ResetEditDataStruct;
Begin
  K1:=0;
  K2:=0;
  First:=0;
  Insert:=True;
  Indent:=True;
  RefreshFlag:=True;
  Col0:=1;
  Col:=Col0;
  LiHome:=1;
  Li:=LiHome;
  CursShape:=NormalShape;
  N:=1;
  Size:=0;
  TextName:='';
  Touched:=False;
  Modified:=False;
End;

Procedure SetBuffer(Buffer : Pointer; Len : Word);
Begin
  ResetEditDataStruct;
  Buf:=Buffer;
  SizBuf:=Len;
End;

Function GetBuffer : Pointer;
Begin
  GetBuffer:=Buf;
End;


{ ***************************
  Fonctions alloc, load, save
  *************************** }
Function AllocTextBuf(SizeBlock : Word) : Pointer;
Var
   Resu : Pointer;
Begin
  If SizeBlock>$FFF7 Then EditErrorHandler('AllocTextBuf(1)');
  GetMem(Resu,SizeBlock);
  If Resu=Nil Then EditErrorHandler('AllocTextBuf : out of memory');
  Buf:=Resu;
  SizBuf:=SizeBlock;
  AllocTextBuf:=Resu;
  ResetEditDataStruct;
End;

Procedure LoadText(S : String);
Var
   F : File;
Begin
  ResetEditDataStruct;
  If FileExists(S) Then
  Begin
    Assign(F,S);
    Reset(F,1);
    If FileSize(F)>LongInt(SizBuf) Then EditErrorHandler('File too big');
    Size:=FileSize(F);
    BlockRead(F,Buf^,FileSize(F));
    Close(F);
  End;
  TextName:=S;
  N:=TNbLig;
  Touched:=True;
End;

Procedure SaveText(S : String);
Var
   F : File;
Begin
  If S='' Then EditErrorHandler('Save : void name');
  Assign(F,S);
  Rewrite(F,1);
  BlockWrite(F,Buf^,Size);
  Close(F);
  Modified:=False;
End;


{ **********************
  Procdures d'affichage
  ********************** }
Procedure PrintText(First,Col0,Li0,Li1 : Word);
Var
   Scr : ^ByteBuf;
   I : Word;
   Scp,ColorShift,J0 : Word;
Begin
  For I:=Li0 To Li1 Do
  Begin
    Scp:=(I-1)*NbCol;
    First:=AtColNo(First,Col0);

    J0:=1;
    If First<Size Then
      While (First<Size) And (J0<=NbCol) And (Buf^[First]<>$0D) Do
      Begin
        If (First>=K1) And (First<K2) Then
          Screen^[Scp]:=(ColorMarked Shl 8) Or Buf^[First]
        Else
          Screen^[Scp]:=(ColorText Shl 8) Or Buf^[First];

        Inc(Scp);
        Inc(First);
        Inc(J0);
      End
    Else
      Begin
        Screen^[Scp]:=(ColorTildas Shl 8) Or Ord('~');
        Inc(Scp);
        StoSW(@Screen^[Scp],(ColorTildas Shl 8) Or $20,NbCol-1);
        J0:=NbCol+1;
      End;

    If J0<=NbCol Then
      If (First>=K1) And (First<K2) And (First<Size) Then
        StoSW(@Screen^[Scp],(ColorMarked Shl 8) Or $20,NbCol-J0+1)
      Else
        StoSW(@Screen^[Scp],(ColorText Shl 8) Or $20,NbCol-J0+1);

    While (First<Size) And (Buf^[First]<>$0D) Do Inc(First);
    If First<Size Then
    Begin
      Inc(First);
      If (First>=Size) Or (Buf^[First]<>$0A) Then EditErrorHandler('PrintText : NextLine');
      Inc(First);
    End;
  End;
End;

Procedure PrintBanner(Li0 : Word);
Var
   OldCurPos : Word;
Begin
  OldCurPos:=GetCurPos;
  SetCursShape($FF);
  TextAttr:=ColorBanner;
  Locate(Li0,1);
  Write('   ',TextName,'  Line ',Li,'  Col ',Col,'  Lines ',N,'  Size ',Size,'  ');
  If Insert Then Write('Insert  ') Else Write('UpDate  ');
  If Indent Then Write('Indent') Else Write('Direct');
  If Modified Then Write('  *');
  ClrEOL;
  Locate((OldCurPos Shr 8)+1,(OldCurPos And $FF)+1);
  SetCursShape(CursShape);
End;


{ ******************
  dition d'un texte
  ****************** }
Procedure ActUpEOL;
Begin
  Col:=Linelength(NLinesAfter(First,Li-LiHome))+1;
  If Col0>Col Then Col0:=Col
  Else
  If (Col0+NbCol-1<Col) Then Col0:=Col-NbCol+1
  Else
    RefreshFlag:=False;
End;

Procedure ActUpDEL;
Var
   Where,L : Word;
Begin
  Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
  If Where=Size Then
  Else
  If Buf^[Where]=$0D Then
  Begin
    If Where+1<Size Then
    Begin
      L:=LineLength(NLinesAfter(First,Li-LiHome));
      If Buf^[Where+2]<>$0D Then L:=Col-L-1 Else L:=0;
      DelCharsAndInsert(Where,2,$20,L);
      Dec(N);
    End;
  End
  Else
  Begin
    If (Where<>0) And
       ( ((Where+1<Size) And (Buf^[Where+1]=$0D)) Or
         (Where+1=Size)
       )
    Then
      Where:=DelSpacesBefore(Where-1)
    ;
    DelCharsAndInsert(Where,1,0,0);
  End;
End;

Var
   S : String;

{$F+}
Procedure Adjust0(Var S : String);
Begin
  UpCaseString(S);
End;
{$F-}

Procedure ActUpRename(Li0Banner,Col : Word);
Var
   Out,Touche : Word;
Begin
  S:='';
  PrintMessage(Li0Banner,Col,'Rename : ');
  Out:=LCInput(Li0Banner,Col+9,16,ColorBanner,S,28);
  AdjustFileName(S);
  If Out=T_CR Then
  Begin
    If FileExists(S) And (TextName<>S) Then
    Begin
      PrintMessage(Li0Banner,Col,'OverWrite (Y/N) ? ');
      Repeat
        Locate(Li0Banner,Col+18);
        Touche:=GetCar;
        If (Chr(Touche)='Y') Or (Chr(Touche)='y') Then
        Begin
          TextName:=S;
          SaveText(TextName);
        End;
      Until
           (Chr(Touche)='Y') Or (Chr(Touche)='y') Or
           (Chr(Touche)='N') Or (Chr(Touche)='n');
    End
    Else
    Begin
      TextName:=S;
      SaveText(TextName);
    End;
  End;
  S:='';
End;

Procedure ActUpSave(Li0Banner,Col : Word);
Begin
  If TextName='' Then ActUpRename(Li0Banner,Col);
  SaveText(TextName);
End;

Procedure ActUpModified(Li0Banner,Col : Word);
Var
   Touche : Word;
Begin
  If Modified Then
  Begin
    PrintMessage(Li0Banner,Col,'Modified !!! Save (Y/N) ? ');
    Repeat
      Locate(Li0Banner,Col+26);
      Touche:=GetCar;
      If (Chr(Touche)='Y') Or (Chr(Touche)='y') Then SaveText(TextName);
    Until
         (Chr(Touche)='Y') Or (Chr(Touche)='y') Or
         (Chr(Touche)='N') Or (Chr(Touche)='n');
  End;
End;

Procedure ActUpLoad(Li0Banner,Col : Word);
Var
   Out,Touche : Word;
   F : File;
Begin
  PrintMessage(Li0Banner,Col,'Load file name : ');
  Out:=LCInput(Li0Banner,Col+17,16,ColorBanner,S,28);
  AdjustFileName(S);
  If Out=T_CR Then
  Begin
    ActUpModified(Li0Banner,Col);
    LoadText(S);
  End;
  S:='';
End;

{Procedure ActUpExec(Li0Banner,Col : Word);
Var
   Out,Touche : Word;
   F : File;
Begin
  PrintMessage(Li0Banner,Col,'Exec file name : ');
  Out:=LCInput(Li0Banner,Col+17,16,ColorBanner,S,28);
  If Out=T_CR Then
  Begin
    Spawn(S);
  End;
  S:='';
End;}

Procedure ActUpInsert(Touche : Byte; N : Word);
Var
   L,Where : Word;
Begin
  Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
  If (Where=Size) Or (Buf^[Where]=$0D) Then
  Begin
    If (N<>1) Or (Touche<>$20) Then
    Begin
      L:=LineLength(NLinesAfter(First,Li-LiHome));
      DelCharsAndInsert(Where,0,Touche,N);
      DelCharsAndInsert(Where,0,$20,Col-L-1);
    End;
  End
  Else
  Begin
    If (N=1) And (Not Insert) Then
      If ((Where+1=Size) Or (Buf^[Where+1]=$0D)) And (Touche=$20) Then
      Begin
        Buf^[Where]:=$20;
        L:=DelSpacesBefore(Where);
      End
      Else
      Begin
        Buf^[Where]:=Byte(Touche);
        Modified:=True;
        Touched:=True;
      End
    Else
      DelCharsAndInsert(Where,0,Touche,N);

  End;
End;

Var F : File;

Function EditText(LiBanner,LiEOT : Word) : Word;
Label
     Burst;
Var
   Touche,Out : Word;
   Where,Line,L,NS : Word;
   K10,K20,NLi,KInc,I : Word;
   OHandler : ErrorHandler1;
   OERI : Boolean;
Begin
  If RefreshFlag Then TextMode(3);
  SetCursShape(CursShape);
  Li0Banner:=LiBanner;
  Li0:=LiBanner+1;
  Li1:=LiEOT;

  OERI:=ErrorReturnInitialized;
  OHandler:=EditErrorHandler;
  EditErrorHandler:=Handler;
  I:=SetJump(ErrorReturn);
  ErrorReturnInitialized:=True;
  Out:=0;

  If EnterMessage<>'' Then
  Begin
    If LiToGo>=((Li1-Li0) Shr 1) Then L:=LiToGo-((Li1-Li0) Shr 1)+1 Else L:=1;
    First:=Line2Ptr(L);
    LiHome:=L;
    Li:=LiToGo;
    Col0:=1;
    Col:=Col0;
    PrintText(First,Col0,Li0,Li1);
    PrintMessage(Li0Banner,1,EnterMessage);
    EnterMessage:='';
    Locate(Li0+Li-LiHome,Col-Col0+1);
    Touche:=GetCar;
    PrintBanner(Li0Banner);
    Goto Burst;
  End;

  Repeat
    If RefreshFlag Then PrintText(First,Col0,Li0,Li1) Else RefreshFlag:=True;
    Locate(Li0+Li-LiHome,Col-Col0+1);
    PrintBanner(Li0Banner);

    Touche:=GetCar;
Burst:
    Case Touche Of
      T_ESC: Out:=T_ESC;
      T_F1:
      Begin
        ActUpRename(Li0Banner,1);
        RefreshFlag:=False;
      End;
      T_F4:
      Begin
        ActUpSave(Li0Banner,1);
        RefreshFlag:=False;
      End;
      T_F3:
      Begin
        ActUpLoad(Li0Banner,1);
      End;
      T_INS:
      Begin
        Insert:=Not Insert;
        RefreshFlag:=False;
      End;
      T_CTRL_PGUP,T_CTRL_HOME:
      Begin
        First:=0;
        Li:=1;LiHome:=1;
        Col:=1;Col0:=1;
      End;
      T_CTRL_PGDWN,T_CTRL_END:
      Begin
        First:=NLinesBefore(Size,Li1-Li0);
        Li:=N;LiHome:=N-SkippedLines;
      End;
      T_PGDWN:
      Begin
        First:=NLinesAfter(First,Li1-Li0);
        Inc(LiHome,SkippedLines);
        Inc(Li,SkippedLines);
        If LiHome>N Then
        Begin
          First:=NLinesBefore(First,1);
          LiHome:=N;
          Li:=N;
        End;
        If Li>N Then Li:=N;
      End;
      T_PGUP:
      Begin
        First:=NLinesBefore(First,Li1-Li0);
        Dec(LiHome,SkippedLines);
        If Li>SkippedLines Then Dec(Li,SkippedLines)
                           Else Li:=1;
      End;
      T_HOME:
      Begin
        If Col0=1 Then RefreshFlag:=False;
        Col:=1;
        Col0:=1;
      End;
      T_END: ActUpEOL;
      T_DOWN:
      Begin
        If Li<N Then
          If Li-LiHome=Li1-Li0 Then
          Begin
            Inc(Li);
            Inc(LiHome);
            First:=NLinesAfter(First,1);
          End
          Else
          Begin
            Inc(Li);
            RefreshFlag:=False;
          End
        Else
          RefreshFlag:=False;
      End;
      T_UP:
      Begin
        If Li>1 Then
          If Li=LiHome Then
          Begin
            Dec(Li);
            Dec(LiHome);
            First:=NLinesBefore(First,1);
          End
          Else
          Begin
            Dec(Li);
            RefreshFlag:=False;
          End
        Else
          RefreshFlag:=False;
      End;
      T_CTRL_RIGHT: ;
      T_CTRL_LEFT : ;
      T_RIGHT:
      Begin
        If Col-Col0+1=NbCol Then
        Begin
          Inc(Col0);
          Inc(Col);
        End
        Else
        Begin
          Inc(Col);
          RefreshFlag:=False;
        End;
      End;
      T_LEFT:
      Begin
        If Col=1 Then RefreshFlag:=False
        Else
        If Col=Col0 Then
        Begin
          Dec(Col0);
          Dec(Col);
        End
        Else
        Begin
          Dec(Col);
          RefreshFlag:=False;
        End;
      End;
      T_CTRL_Q:
      Begin
        Case GetCar Of
          T_CTRL_I:
          Begin
            Indent:=Not Indent;
            RefreshFlag:=False;
          End;
          Else ;
        End;
      End;
      T_CTRL_K:
      Begin
        Case GetCar Of
          T_CTRL_B: K1:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
          T_CTRL_K: K2:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
          T_CTRL_C: Begin
            Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
            If (K1>=K2) Or ((Where>K1) And (Where<K2)) Then
            Else
            Begin
              K10:=K1;K20:=K2;
              If (Where=Size) Or ((Where<Size) And (Buf^[Where]=$0D)) Then
              Begin
                KInc:=0;
                L:=LineLength(NLinesAfter(First,Li-LiHome));
                If Where<=K1 Then KInc:=K2-K1;
                DelCharsAndInsBlock(Where,0,@Buf^[K1+KInc],K2-K1);
                DelCharsAndInsert(Where,0,$20,Col-l-1);
                Inc(Where,Col-L-1);
              End
              Else
              Begin
                KInc:=0;
                If Where<=K1 Then KInc:=K2-K1;
                DelCharsAndInsBlock(Where,0,@Buf^[K1+KInc],K2-K1);
              End;
              K1:=Where;
              K2:=K1+K20-K10;
              For I:=K1 To K2-1 Do If Buf^[I]=$0D Then Inc(N);

              Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
              If (Where+K2-K1=Size) Or
                 ((Where+K2-K1<Size) And (Buf^[Where+K2-K1]=$0D))
              Then
                I:=DelSpacesBefore(K2-1);
            End;
          End;
          T_CTRL_Y:
          Begin
            If (K1>=K2) Then
            Else
            Begin
              NLi:=NLinesBetween(K1,K2-1);
              NS:=NbSpacesBefore(K1);
              Dec(K1,NS);
              Col:=K1+NS-AtBeg(K1)+1;
              DelCharsAndInsert(K1,K2-K1,0,0);
              K2:=K1;
              If Col-Col0>=NbCol Then Col0:=Col-NbCol+1
              Else
              If Col0>Col Then Col0:=Col;
              Li:=Ptr2Line(AtBeg(K1));
              Dec(N,NLi);
              If Li1-Li0+1>=N Then LiHome:=1
              Else
              Begin
                If Li<LiHome Then LiHome:=Li;
                If Li>LiHome+Li1-Li0 Then LiHome:=Li-Li1+Li0;
                If LiHome+Li1-Li0>N Then LiHome:=N-Li1+Li0;
              End;
              First:=Line2Ptr(LiHome);
            End;
          End;
          T_CTRL_V:
          Begin
            Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
            If (K1>=K2) Or ((Where>K1) And (Where<K2)) Then
            Else
            Begin
              If (Where=Size) Or
                 ((Where<Size) And (Buf^[Where]=$0D))
              Then
                I:=DelSpacesBefore(K2-1);

              K10:=K1;K20:=K2;
              Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);

              If (Where=Size) Or ((Where<Size) And (Buf^[Where]=$0D)) Then
              Begin
                L:=LineLength(NLinesAfter(First,Li-LiHome));
                KInc:=0;
                If Where<=K1 Then KInc:=K2-K1;
                DelCharsAndInsBlock(Where,0,@Buf^[K1+KInc],K2-K1);
                DelCharsAndInsert(Where,0,$20,Col-L-1);
                Inc(Where,Col-L-1);
              End
              Else
              Begin
                KInc:=0;
                If Where<=K1 Then KInc:=K2-K1;
                DelCharsAndInsBlock(Where,0,@Buf^[K1+KInc],K2-K1);
              End;

              If Where>K10 Then NLi:=NLinesBetween(K10,K20-1) Else NLi:=0;
              NS:=NbSpacesBefore(K1);

              DelCharsAndInsert(K1-NS,K2-K1+NS,0,0);
              If (Where>K10) Then
              Begin
                Dec(Li,NLi);
                If First>=K20 Then
                Begin
                  Dec(LiHome,NLi);
                  First:=Line2Ptr(LiHome);
                End
                Else
                If First>K10 Then
                Begin
                  First:=AtBeg(K10);
                  LiHome:=Ptr2Line(First);
                End;
              End;
              If (Where>K10) Then Dec(Where,K20-K10+NS);
              K1:=Where;
              K2:=K1+K20-K10;
            End;
          End;
          T_CTRL_R:
          Begin
            PrintMessage(Li0Banner,1,'Insert file : ');
            Out:=LCInput(Li0Banner,15,16,ColorBanner,S,28);
            AdjustFileName(S);
            If Out=T_CR Then
            Begin
              If Not FileExists(S) Then EditErrorHandler('File not found');
              Assign(F,S);
              Reset(F,1);
              If FileSize(F)>LongInt(SizBuf) Then EditErrorHandler('File too big');
              ActUpInsert(Byte(' '),FileSize(F));
              Where:=AtColNo(NLinesAfter(First,Li-LiHome),Col);
              BlockRead(F,Buf^[Where],FileSize(F));
              Close(F);
              N:=TNbLig;
            End;
            S:='';
            Out:=0;
          End;
          Else ;
        End;
      End;
      T_CR:
      Begin
        If Insert Then
        Begin
          Line:=NLinesAfter(First,Li-LiHome);
          Where:=AtColNo(Line,Col);
          If Where<>0 Then Where:=DelSpacesBefore(Where-1);
          DelCharsAndInsert(Where,0,$0A0D,2);
          If Li-LiHome=Li1-Li0 Then
          Begin
            Inc(LiHome);
            First:=NLinesAfter(First,1);
          End;
          Inc(Li);
          Inc(N);
          If Indent And (Col<>1) Then
          Begin
            NS:=NbSPacesAtBeg(Line);
            If (Where+2<Size) And (Buf^[Where+2]<>$0D) Then DelcharsAndInsert(Where+2,0,$20,NS);
            Col:=NS+1;
            If Col<Col0 Then Col0:=Col;
          End
          Else
          Begin
            Col0:=1;
            Col:=Col0;
          End;
        End
        Else
        If Li<N Then
        Begin
          RefreshFlag:=False;
          Line:=NLinesAfter(First,Li-LiHome+1);

          If (Li-LiHome=Li1-Li0) Then
          Begin
            Inc(LiHome);
            First:=NLinesAfter(First,1);
            RefreshFlag:=True;
          End;
          Inc(Li);
          If Indent Then
          Begin
            Col:=NbSpacesAtBeg(Line)+1;
            If Col<Col0 Then
            Begin
              Col0:=Col;
              RefreshFlag:=True;
            End;
            If Col>NbCol Then
            Begin
              Col0:=Col-NbCol+1;
              RefreshFlag:=True;
            End;
          End
          Else
          Begin
            If Col0<>1 Then RefreshFlag:=True;
            Col0:=1;
            Col:=Col0;
          End;
        End;
      End;
      T_DEL: ActUpDEL;
      T_BS:
      Begin
        If Col=1 Then
        Begin
          If Li<>1 Then Begin
            Dec(Li);
            If Li<LiHome Then
            Begin
              Dec(LiHome);
              First:=NLinesBefore(First,1);
            End;
            ActUpEOL;
            ActUpDEL;
            RefreshFlag:=True; { A cause du EOL qui cleare RefreshFlag }
          End
          Else
            RefreshFlag:=False;
        End
        Else
        If Col>LineLength(NLinesAfter(First,Li-LiHome))+1 Then ActUpEOL
        Else
        Begin
          Dec(Col,1);
          If Col0>Col Then Col0:=Col;
          ActUpDEL;
        End;
      End;
      T_CTRL_Y:
      Begin
        Where:=AtBeg(NLinesAfter(First,Li-LiHome));
        L:=LineLength(Where);
        If Li<N Then DelCharsAndInsert(Where,L+2,0,0)
        Else
        If Li<>1 Then
        Begin
          DelCharsAndInsert(Where-2,L+2,0,0);
          Dec(Li);
        End
        Else
          DelCharsAndInsert(Where,L,0,0);

        If (Li<N) Or (Li<>1) Then
        Begin
          If LiHome>Li Then
          Begin
            LiHome:=Li;
            First:=NLinesBefore(First,1);
          End;
          Dec(N);
        End;
      End;
      Else
      If (Touche And $FF<>0) And (Touche And $FF<>$0A) Then
      Begin
        ActUpInsert(Touche,1);
        Inc(Col); If Col-Col0=NbCol Then Inc(Col0);
      End
      Else
        Out:=Touche;
    End
  ;
  Until Out<>0;

  EditErrorHandler:=OHandler;
  ErrorReturnInitialized:=OERI;
  EditText:=Out;
End;


{ ***************
  Fonction d'init
  *************** }
Begin
{ Init scr }
  NbCol:=80;
{ Init Handler }
  ErrorReturnInitialized:=False;
{ Init editor }
  ColorText:=$07;
  ColorTildas:=$02;
  ColorMarked:=$70;
  ColorBanner:=$02;
  FillBlock:=Nil;
  Li0Banner:=1;
  S:='';
  EnterMessage:='';
  AdjustFileName:=Adjust0;
End.