// fixlabel.c                    2231                           7/19/98

// A short program to ensure that asm-code labels are not alone
// on a line.

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE *infile;
FILE *outfile;
     
char command[50], *fptr, infilename[20], outfilename[20];
char copy[150], instring[150];
int incode, line;

// Function Prototypes:

void copy_top(void);          // copy file up to "text"
void clear_strings(void);     // clear "copy" and "instring"
void fix_code(void);          // put code on "label" lines

void main(int argc, char *argv[])
     {
     if(argc < 2)
          {
          printf("\n\n\t\aUSAGE: fixlabel <filename>\n\n");
          exit(1);
          }

     sprintf(infilename, "%s.asm", argv[1]);
     infile = fopen(infilename, "rt");
     if(!infile)
          {
          printf("\n\n\t\aCan't open %s!\n\n", command);
          exit(1);
          }
          
     sprintf(outfilename, "%s.tmp", argv[1]);
     outfile = fopen(outfilename, "wt");
     if(!outfile)
          {
          printf("\n\n\t\aCan't open %s!\n\n", command);
          exit(1);
          }

     copy_top();              // copy file up to "text"
     fix_code();              // put code on "label" lines     

     fclose(infile);
     fclose(outfile);
     
     sprintf(command, "rm %s", infilename);
     system(command);
     sprintf(command, "mv %s %s", outfilename, infilename);
     system(command);     
     }     
     
void clear_strings(void)      // clear "copy" and "instring"
     {
     int n;
     
     for(n=0; n < 150; n++)
          {
          copy[n] = 0;
          instring[n] = 0;
          }
     }     
     
void copy_top(void)           // copy file up to "text"
     {
     for(line = 1; line <= 10000; line++)
          {
          clear_strings();
          fgets(instring, 150, infile); // read line from "cod file
          
          fprintf(outfile, "%s", instring);

          if(strstr(instring, ".text"))
               {
               line++;
               break;
               }
               
          if(feof(infile)) exit(1); // should never happen!
          }
     }          

void fix_code(void)           // put code on "label" lines
     {
     char label[25], *tok;
     int j;
     
     for(; line <= 10000; line++)
          {
          clear_strings();
          fgets(instring, 150, infile); // read line from "asm" file
          retry: if(instring[0] == '\n') // blank line
               {
               fprintf(outfile, "%s", instring);
               continue;
               }
               
          else if(isspace(instring[0]))
               {
               fprintf(outfile, "%s", instring);
               continue;
               }
               
          else if(isalnum(instring[0]))
               {
               strcpy(copy, instring); // make copy for parsing
               fptr = strtok(copy, " \n\t"); // find label
               strcpy(label, fptr); // save it
               tok = strtok(NULL, " \n\t"); // test for code
               if(tok)        // line already has code
                    {
                    fprintf(outfile, "%s", instring);
                    continue;
                    }
               else
                    {
                    line++;                                       
                    clear_strings();
                    fgets(instring, 150, infile); // read line from "cod file
                    if(isalnum(instring[0])) // another label
                         {
                         fprintf(outfile, "%s\n", label); // give up!
                         goto retry;
                         }
                    else
                         {
                         fptr = instring; // point to string
                         for(j=0; j < strlen(instring); j++, fptr++)
                              {
                              if(isgraph(*fptr)) break;
                              }
                         if(strlen(label) < 7)
                              {
                              fprintf(outfile, "%s\t%s", label, fptr); // label + code
                              }
                         else
                              {
                              fprintf(outfile, "%s %s", label, fptr); // label + code
                              }                              
                         for(j=0; j < strlen(label); j++)
                              {
                              label[j] = 0; // clear "label"
                              }                             
                         }           
                    }                              
               }

          if(feof(infile)) return;
          }
     }     
               
