// newlib.h                     1606                          5/14/98

// An expanded "b" library for WDOSX.

// NOTE: Most "string" functions returning "int" are really returning
// string pointers which are of size "int".  This greaty simplifies
// parsing of the function prototypes.

char attrib = 0x1E;
char btemp;
char bval;
char chr;
char chval;
char col;
char flag;
char exitcode;
char *dptr;
char *filptr;
char *limit;
char *oldptr;
char *ptr;
char *sbegin;
char *send;
char *ssave;
char mode;
char row;
char tail[127];
int buffsize;
int divisor;
int ercode;
int fbytes;
int first;
int found;
int handle;
int j;
int keyval;
int length;
int memtop;
int n;
int rowcount;
int stdin;
int stdout = 1;
int testval;
int wtemp;
int wval;

void add_memory(int bytecount); // expand segment "bytecount" bytes
void blockcur(void);          // display block cursor
void clear(void);             // clear screen with "attrib"
void clear_buffer(void);      // clear file buffer
void crlf(void);              // emit a video <cr><lf> pair
void fclose(int file);        // close open file
int fgetc(int file);          // read one byte from "file"
void fgets(char *fdest);      // read string to "dest"
int fopen(char *nameptr, int mode); // open file for reading or writing
int fputc(char ch, int file); // write "ch" to "file"
void fputs(char *ptr, int fname); // write string at "ptr" to "fname"
void fread(void);             // read file to "filebuff"
void fwrite(void);            // write "filebuff" to open file
int getchar(void);            // get charactter from STDIN
void getkey(void);            // get keypress in al
void get_mode(void);          // get video mode
void get_rows(void);          // read byte at 40:84 to get screen rows
void get_tail(void);          // get "command tail" from PSP
void nocur(void);             // hide text cursor
void putcur(char scol, char srow); // move cursor to scol:srow
void show_byte(void);         // show value in "bval"
void show_char(void);         // display "chval" at current cursor position
void show_decimal(int size);  // show decimal value (byte or word)
void show_four(void);         // show 4 "hex" digits in "wval"
void show_hex(void);          // show "hex" value of byte in "bval"   
void show_line(char col, char row, char *tex); // display text line
void show_long(void);         // show value >= 100,000 in "wval"
int show_text(char *tex);     // show "tex" at current cursor position
void show_word(void);         // show value in "wval"
int strchr(char *s, char c);  // find first "c" in "s"
int strcspn(char *str1, char *str2); // find index of 1st "str2" char in "str1"
int strcpy(char *strdest, char *src); // copy "src" to "dest"
int strspn(char *str3, char *str4); // find index of 1st "str3" char not in "str4"
int strlen(char *ptr);        // return length of string
int strstr(char *s1, char *s2); // find "s2" in "s1"
int strtok(char *t, char *delim); // find "token" in "t"
char toupper(char inch);      // convert "inch" to upper case
