//-------------------------------------------------------------------//

//  Syntax:     loaddir ( DIRNAME )

//  Description:

//  loaddir loads all of the Rfiles in the directory DIRNAME. DIRNAME
//  is a string identifying the directory of Rfiles to be loaded. Only
//  files with a postfix of `.r' will be loaded.

//  Example: 
//  > loaddir ("/u1/ian/rlab/testmatrix");
//  > loaddir (".");

//-------------------------------------------------------------------//


loaddir = function ( dir )
{
  local (dir)

  dirnm = "| ls " + dir + "/*.r";
  while (length (fn = getline (dirnm)))
  {
    printf ("\tLoading:\t%s\n", fn.[1]);
    load (fn.[1]);
  }
  close (dirnm);
};
