#
#   BASIC.R
#   Sample programmable mail form for Pegasus Mail v3.0
#   Copright (c) 1993, David Harris, All Rights Reserved.
#
#   You are granted the right to modify and distribute this
#   form in any way you wish provided you do not sell it or
#   any derivative either on its own or as part of any other
#   package.
#
#   By using this form you agree to hold the author blameless
#   for all or any damages or losses resulting from its use.
#
#   This form duplicates the standard PMail message editing
#   screen in every way.
#

include defines.rh
include forms.rh

string form_title     "Basic Message Editor";

window fwindow    # The window in which the form appears
   {
   1, 1, 80, 25, BBLUE | LIGHTGREY | wplain,
   BBLUE | LIGHTGREY, ' ', BSINGLE,
   " Send Message: Editing Screen "
   };

block field_text
   {
   2, 1, BBLUE | LIGHTGREY,
   "To   :",
   "Subj :"
   };

data to         # The "to" field when sending files or messages
   {
   10, 1, 65, 179, 0, 0, 0, GT_STRING, GNOCLEAR
   };

data subject    # The "subject" field when sending files or messages
   {
   10, 2, 63, 64, 0, 0, 0, GT_STRING, 0
   };

text subject_help
   {
   " The Subject Field \n",
   "The subject is a one-line prcis of the contents of the\n",
   "message which will be displayed in the recipient's browse\n",
   "list. You may leave this field blank, but it is considered\n",
   "good e-mail etiquette to provide a meaningful subject."
   };

line xline_1
   {
   0, 3, 80, 0, LIGHTGREY, ''
   };

line xline_2
   {
   0, 21, 80, 0, LIGHTGREY, ''
   };

line xline_3
   {
   1, 20, 80, 0, BLIGHTGREY, ' '
   };

editor message
   {
   1, 4, 77, 16, 70, 0, 0, BBLUE | LIGHTGREY
   };

block help_text
   {
   1, 22, dim | wcentre,
   "F1-Help  F2-Local user lists  F3-Address books  F6-Distribution lists",
   "F7-File attachments  F9-More options  Ctrl-Enter-Send the message"
   };

formtable formdata
   {
#  Name........ Correlation. Help text.... Validation... Status...... Default
   fwindow,     F_WINDOW,    0,            0,            0,           0,
   field_text,  0,           0,            0,            0,           0,
   help_text,   0,           0,            0,            0,           0,
   xline_1,     0,           0,            0,            0,           0,
   xline_2,     0,           0,            0,            0,           0,
   xline_3,     0,           0,            0,            0,           0,
   to,          F_TO,        0,            0,            0,           0,
   subject,     F_SUBJECT,   subject_help, 0,            0,           0,
   message,     F_MESSAGE,   0,            0,            0,           0
   };

