/*

   CIO.H

   (c) 1996 Oliver Kraus

   kraus@lrs.e-technik.uni-erlangen.de

*/

#ifndef _CIO_H
#define _CIO_H

char *c_get_vol_info(const char *root, int *flags);
/* 0: current, 1: A:\, 2: B:\, 3:C:\ etc */
int c_is_long_filename(int drive);
void c_chdrive(int drive);
int c_getdrive(void);
int c_chdir(const char *newdir);
int c_mkdir(const char *newdir);
char *c_getcwd(void);

void c_io_clear(void);

void c_strncpy(char *dest, const char *src, size_t n);
int c_create_path(const char *path);
int c_set_path(const char *path);

/* file access */
/* O_CREAT O_TRUNC O_WRONLY O_RDONLY O_RDWR  */
int c_open(const char *filename, int oflag, int pmode);
int c_close(int fhandle);
long c_write(int fhandle, void *buffer, long count);
long c_read(int fhandle, void *buffer, long count);


#endif
