/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       UDP.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/6/22
**
** DESCRIPTION: Contains the UDP implementation
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   UDP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/UDP/VCS/UDP.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 11:21:42   etstjan
**              No explicit note
**              
**                 Rev 1.0   21 Nov 1990 12:17:04   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/UDP/VCS/UDP.C_V   1.1   01 Feb 1991 11:21:42   etstjan  $";
#endif

#include      <stdio.h>
#include      <stdlib.h>
#include      <string.h>
#include      <beholder.h>             /* include buffer management */

#include      "ip.h"                   /* general ip defines */
#include      "ipcodes.h"              /* and ip return codes */
#include      "iplib.h"                /* include ip library */
#include      "iplayer.h"              /* ip send/receive */
#include      "socklib.h"              /* socket library interface */

/**************************************************************
** NAME:        UDPRec
** SYNOPSIS:    int UDPRec(PRREQ ThisReq, CIPHEAD *IPHeader,
**                         DATALINK *IPPacket, int BCast,
**                         int ECode);
**  
** DESCRIPTION: Processes reception of UDP packets.
**              ThisReq specifies the type of request.
**              For RECREQ, first some checks on the UDP
**              header are performed first. Next a fitting
**              socket is searched. If such a socket can not
**              be found, an error is returned.
**              For ERRREQ, the error code in ECode is passed
**              to a socket, if available.
** RETURNS:     NO_ERR      -->   no error or processing
**                                finished
**              NO_PORT     -->   no fitting socket found
**              ILL_REQUEST -->   illgal ThisReq
**************************************************************/
int UDPRec(PRREQ ThisReq, CIPHEAD *IPHeader,
           DATALINK *IPPacket, int BCast, int ECode)
{
  CUDPHEAD       TempHead;
  SOCKET         *DestSock;
  int            Value;

  switch (ThisReq) {
    case RECREQ :
      if (IPPacket->Length < 8) {
        IPStat.NrUDPShort++;
        IPReport(UDPSHORT, IPHeader, IPPacket);
        return NO_ERR;
        }
      IPStat.NrUDPRec++;
  
      ByteToCudp(&TempHead, IPPacket->DataStart);
  
      if (TempHead.CheckSum != 0) {
        if (UDPCheckSum(IPHeader, IPPacket) != 0) {
          IPStat.NrUDPChkErr++;
          IPReport(UDPCHERR, IPHeader, IPPacket);
          return NO_ERR;
          }
        }
      else {
        IPStat.NrNoUDPCheck++;
        }
  
      if (BCast) {
        IPHeader->Destin = IPHeader->ExtraAddress;
        }
  
      /* search a destination socket in the UDP socket list */
      if ((DestSock = So_Locate(TempHead.DPort, IPHeader->Destin,
                                TempHead.SPort, IPHeader->Source,
                                UDPProt, &Value)) == NULL) {
        IPStat.NrNoUDPSock++;
        return NO_PORT;
        }
      IPPacket->DataStart += 8;
      IPPacket->Length -= 8;
      MessToSock(DestSock, IPHeader, IPPacket);
      return NO_ERR;

    case ERRREQ :
      ByteToCudp(&TempHead, IPPacket->DataStart + IPHeader->HLength);
      if (((DestSock = So_Locate(TempHead.SPort, IPHeader->Source,
                                 TempHead.DPort, IPHeader->Destin,
                                 UDPProt, &Value)) != NULL) &&
          (Value == 15)) {
        DestSock->So_Error = ECode;
        }
      return NO_ERR;

    case SRCQNCHREQ :
      return NO_ERR;

    default :
      return ILL_REQUEST;
    }
}

