/**<pubkey.c>************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <pubkey.man> for documentation. 
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <mem.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <io.h>
#include "pubkey.h"

#define NMAX 50

extern unsigned Nres ;

unsigned pLen = 16 ;
unsigned bLen = 180 ;
/*  4*[  2 * ( word_length_of_number + p_sor_overhead ) + 1 ]  bytes*/

extern char keyW[80] ;
char pswd[64] ="VOUCH - the signature software";
 
lenLN  Lqq, Lpp, Lpn, Lgg, Lh1 ;
ptrLN  qq, pp, pn, gg, h1  ;
int    init_ed ;

void bell( int len ) /* "chaotic bell" */
{
  int i ;
  float xn ;
  float cp=3.93 ; /* 0 < cp < 4.0 ; choose cp > 3.6 for chaos */

  xn = rand() / (float) RAND_MAX ;
  for (i=len; i>0; --i) {
    xn = cp * xn * (1.0-xn) ; /* logistic-map: [0,1] -> [0,1] */
    sound( (int) (xn * 3000 + 1000)   ) ;
    delay( 30 ) ;
  }
  nosound() ;
}/*bell*/


void randomLN_2( unsigned *Lrr, ptrLN rr )
{
  long unsigned  rwd = 0 ;
  long rmI = rr[*Lrr-1] ;
  unsigned char *pb = (unsigned char*) rr, 
                *pb_end = pb + 4*(*Lrr) ;

  for (;pb < pb_end; pb++)
    *pb = random(0x100) ;
  /* rwd = number of left_most zeros in rr[Lrr-1] */
  while (!(rmI<0)) {
    rwd++ ; rmI <<= 1 ;
  }
  rr[*Lrr-1] &= 0xFFFFFFFFL >> rwd ;
  while ( (rr[*Lrr-1]==0) && (*Lrr>1) )  (*Lrr)-- ;
}/* randomLN_2 */

int rzeros( lenLN Lpn, ptrLN pn )
{
  int i, zz=0 ;
  long xw ;
  ptrLN pn_end = pn + Lpn ;

  if ((Lpn==1) && (*pn==0)) return(zz) ;
  do {
    i = 0 ;
    do {
      xw = (1L << i) & *pn ;
      if (xw==0)  zz++ ; else return(zz) ;
    } while (++i<32) ;
  } while (++pn<pn_end) ;
  return(zz) ;
}/* rzeros */


static void clr_mem( ptrLN hh, ptrLN pn, ptrLN bb, ptrLN zz, ptrLN mm)
/* for primeLikely() */
{
  free(mm) ;
  free(zz) ;
  free(bb) ;
  free(hh) ;
  free(pn) ;
}

int primeLikely( int nmax, lenLN Lpp, ptrLN pp )
{
  lenLN Lhh, Lpn, Lbb, Lzz, Lmm ;
  ptrLN hh, pn, bb, zz, mm ;
  unsigned aa ;
  int i, j, passTest, Xc, Yc ;

  pn = (ptrLN) malloc( bLen ) ;
  hh = (ptrLN) malloc( bLen ) ;
  bb = (ptrLN) malloc( bLen ) ;
  zz = (ptrLN) malloc( bLen ) ;
  mm = (ptrLN) malloc( bLen ) ;
  Lhh = 1 ; *hh = 1 ;
  Lpn = Lpp ; movmem( pp, pn, 4*Lpp ) ;
  subt( Lhh, hh, &Lpn, pn ) ;
  aa = rzeros( Lpn, pn ) ;
  shiftR( aa, Lpn, pn, &Lmm, mm ) ;
  Xc = wherex() ; Yc = wherey() ;
  for (i=0; i<nmax; ++i ) {
    gotoxy( Xc, Yc ) ; delline() ;
    printf("   Primality check # %i", i+1 ) ;
    Lhh = 1 ; hh[0] = 2 ;
    do {
      Lbb = Lpp ; bb[Lbb-1] = pp[Lpp-1] ;
      randomLN_2( &Lbb, bb ) ;
      if (!isGreater( Lpp, pp, Lbb, bb ))
	subt( Lpp, pp, &Lbb, bb ) ;
    } while ( !isLess(Lbb,bb,Lpn,pn) || isLess(Lbb,bb,Lhh,hh) ) ;
    dexp( Lbb, bb, Lmm, mm, Lpp, pp, &Lzz, zz ) ;
    if ( !( ((Lzz==1) && (*zz==1)) || isEqual(Lzz, zz, Lpn, pn)) ) {
      j = 1 ; passTest = 0 ;
      while ( (j<aa) &&  !passTest ) {
        mult( Lzz, zz, Lzz, zz, &Lhh, hh ) ;
        psor( Lhh, hh, Lpp, pp, &Lbb, bb ) ;
        modR( Lbb, bb, Lpp, pp, &Lzz, zz ) ;
        j++  ;
        if (isEqual(Lzz,zz,Lpn,pn))  passTest = 1 ;
        if ( (Lzz==1) && (*zz==1) ) {
          puts( " Failed. ") ;
	  clr_mem(hh, pn, bb, zz, mm) ; 
          if (i>0) {
	    puts("pseudo-prime detected\n") ;
            bell(11) ;
      	  }  
	  return(0) ;
        }
      }/* while */
      if (!passTest) {
         puts( " Failed. ") ;
	 clr_mem(hh, pn, bb, zz, mm) ; 
         if (i>0) {
           puts("pseudo-prime detected\n") ;
           bell(11) ;
         }  
	 return(0) ;
      }
    }/* if */
  }/* for */
  puts(" Passed.") ;
  clr_mem(hh, pn, bb, zz, mm) ;
  return(1) ;
}/* primeLikely */


void gen_q( lenLN Lqt )
{
  lenLN Lrr ;
  ptrLN rr ;
  long unsigned nqq = 0 ;
  int Xc, Yc ;

  rr = (ptrLN) malloc( bLen ) ;
  Xc = wherex() ; Yc = wherey() ;
  do {
    Lrr = Lqt ; rr[Lrr-1] = 0x7FFFFFFFL ;
    randomLN( &Lrr, rr ) ;
    rr[Lrr-1] |= 0x40000000L ;
    shiftL( 1, Lrr, rr, &Lqq, qq ) ;
    Lrr = 1 ; *rr = 1 ;
    accum( Lrr, rr, &Lqq, qq ) ;
    while (Lqq==Lqt) {
      nqq++ ;
      gotoxy( Xc, Yc ) ;
      printf("q_trial # %i\n", nqq ) ;
      Nres = Lqq ;
      if (primeLikely( NMAX, Lqq, qq )) {
        free( rr ) ;
        clear_rs( Lqq ) ;
        return ;
      }
      clear_rs( Lqq ) ;
      Lrr = 1 ; *rr = 2 ;
      accum( Lrr, rr, &Lqq, qq ) ;
    }
  } while (1) ;
}/* gen_q */


void gen_p( lenLN Lpt ) 
{
  lenLN  Lhh, Lnn ;
  ptrLN  hh, nn ;
  long unsigned npp=0 ;
  int Xc, Yc ;

  Xc = wherex() ; Yc = wherey() ;
  hh = (ptrLN) malloc( bLen ) ;
  nn = (ptrLN) malloc( bLen ) ; 
  shiftL( 1, Lqq, qq, &Lhh, hh ) ;
  do {
    Lpp = Lpt ; pp[Lpp-1] = 0xFFFFFFFFL ;
    randomLN( &Lpp, pp ) ;
    pp[Lpp-1] |=  0x80000000L ;
    divide( Lhh, hh, Lpp, pp, &Lnn, nn, &Lh1, h1 ) ;
    subt( Lh1, h1, &Lpp, pp ) ;
    Lh1 = 1 ; *h1 = 1 ;
    accum( Lh1, h1, &Lpp, pp ) ;
    Nres = Lpp ;
    npp++ ;
    gotoxy( Xc, Yc ) ;
    printf("p_trial # %i\n", npp ) ;
    if (primeLikely( NMAX, Lpp, pp )) {
      free( hh ) ; free( nn ) ;
      clear_rs( Lpp ) ;
      return ;
    }
    clear_rs( Lpp ) ;
  } while(1) ;
}/* gen_p */


int gen_g( void ) 
{
  lenLN Lhh, Lmm, Lun ;
  ptrLN hh, mm, un ; 
  unsigned ngg=0 ;

  Nres = Lpp ; 
  mm = (ptrLN) malloc( bLen ) ;  
  hh = (ptrLN) malloc( bLen ) ;
  un = (ptrLN) malloc( bLen ) ;  
  Lun = 1 ; *un = 1 ;
  Lpn = Lpp ; movmem( pp, pn, 4*Lpp ) ;
  subt( Lun, un, &Lpn, pn ) ;
  divide( Lqq, qq, Lpn, pn, &Lmm, mm, &Lgg, gg ) ;
  Lgg = 1 ; *gg = 1 ;
  while ( (Lgg==1) && (*gg==1) ) {
    ngg++ ; printf("g_trial # %i\n", ngg  ) ;
    do {
      Lhh = Lpn ; hh[Lhh-1] = pn[Lpn-1] ;
      randomLN( &Lhh, hh  ) ;
    } while ( !isLess( Lhh, hh, Lpn, pn) || !isGreater( Lhh, hh, Lun, un ) ) ;
    dexp( Lhh, hh, Lmm, mm, Lpp, pp, &Lgg, gg ) ;
  }
  dexp( Lgg, gg, Lqq, qq, Lpp, pp, &Lhh, hh ) ;
  if ( !( (Lhh==1) && (*hh==1) ) ) {
    puts("*** Sorry, an internal error occured." ) ; getch() ;
    return(-1) ;
  }
  free( un ) ;  free( hh ) ;  free( mm ) ;
  clear_rs( Lpp ) ;
  return(0) ;
}/* gen_g */


void helpScr( void )
{
  puts("PubKey Version 1.1, VOUCH Utility, Copyright (c) 1993, 1994  Awais M. Hussain") ;
  puts("      Generate public_key parameters (q, p, g) ") ;
  puts("Usage: ") ;
  puts("      PubKey /q  <filename>  [Length in 32_bit words] ") ;
  puts("      PubKey /p  <filename>  [Length in 32_bit words] ") ;
  puts("      PubKey /g  <filename>  \n") ;
  puts("Valid sequence: pubkey /q; pubkey /p; pubkey /g; ") ;
}/* helpScr */

void init( void ) 
{
  unsigned ovhd = 6 ;

  bLen = 4 * (2*(pLen+ovhd) + 1 ) ;
  pp = (ptrLN) malloc( bLen ) ;
  qq = (ptrLN) malloc( bLen ) ;
  pn = (ptrLN) malloc( bLen ) ;
  h1 = (ptrLN) malloc( bLen ) ;
  gg = (ptrLN) malloc( bLen ) ;
  init_ed = 1 ;
}/* init */

void exit_proc( char *fn ) 
{
  if (strlen(fn)>0) printf("*** <%s> error\n", fn ) ;
  free(gg) ;
  free(h1) ;
  free(pn) ;
  free(qq) ;
  free(pp) ;
  exit( 1 ) ;
}/*exit_proc*/

main( int argc, char *argv[] )
{

  int err, option ;
  float tm ;
  char fname[80], fn1[80], keyWfile[80]="init.vch" ;
  FILE *ff ;


/*1*/

  init_ed = 0 ;
/*2*/
  if ( (argc<3) || (argc>4) || !strcmp(argv[1],"/?") ) {
    helpScr() ; exit(0) ;
  }  
/*3*/
  if (stricmp(argv[1],"/q")==0)
    option = 1 ;
  else
  if (stricmp(argv[1],"/p")==0)
    option = 2 ;
  else
  if (stricmp(argv[1],"/g")==0) 
    option = 3 ;
  strcpy( fname, argv[2] ) ;

/*4*/
  if (access( keyWfile, 0 )==0)
    read_keyW( keyWfile ) ;
  else
    init_keyW( keyWfile ) ;

  randomize() ;
  init_rndm() ;

/*5*/
  if (option == 1) { /*   /q    */
    timeI() ;
    if (argc==4) {
      pLen = atoi( argv[3] ) ;
      if (pLen==0) exit(1) ;
    } else pLen = 5 ;
    init() ;
    Lqq = pLen ;
    printf("q_Length = %i bits\n", 32*Lqq ) ;
    gen_q( Lqq ) ;
    err = writeLN( 1, fname, Lqq, qq ) ;
    printf( "q_parameter: <%s> created.\n", fname ) ;
    timeF( &tm ) ;
    printf(" %.2f  seconds \n", tm ) ;
    bell( Lqq * 4 ) ;
  }

/*6*/
  if (option == 2) {/*  /p   */
    timeI() ;
    if (argc==4) {
      pLen = atoi( argv[3] ) ;
      if (pLen==0) exit(1) ;
    } else pLen = 16 ;
    Lpp = pLen ;
    printf("p_Length = %i bits\n", 32*Lpp) ;
    init() ;
    Lqq = 10*pLen ; err = readLN( 1, fname, &Lqq, qq ) ;
    if (err) exit_proc( fname ) ;
    if (Lqq>=pLen) {
      puts("** q_Length  p_Length ") ;
      exit_proc( "" ) ;
    }
    gen_p( Lpp ) ;
    Lh1 = 1 ; *h1 = 1 ;
    Lpn = Lpp ; movmem( pp, pn, 4*Lpp ) ;
    subt( Lh1, h1, &Lpn, pn ) ;
    modR( Lpn, pn, Lqq, qq, &Lh1, h1 ) ;
    if (!( (Lh1==1) && (*h1==0) ) ) {
      puts("*** Sorry, an internal error occured.") ;
      exit_proc( "" ) ;
    }
    fExt( fname, ".old", fn1 ) ;
    if (access(fn1,0)==0) remove(fn1) ;
    rename( fname, fn1 ) ;
    if ( (ff = (FILE*) fopen( fname, "w" )) == (FILE*) NULL )
      exit_proc( fname ) ;
    fprintf( ff,"%i\n", Lpp ) ;
    fclose( ff ) ;
    writeLN( 0, fname, Lpp, pp ) ;
    writeLN( 0, fname, Lqq, qq ) ;
    printf("p_parameter: <%s> updated.\n", fname ) ;
    timeF( &tm ) ; printf(" %.2f  seconds \n", tm ) ;
    bell( Lpp*4 ) ;
  }

/*7*/
  if (option==3) {/*   /g    */
    timeI() ;
    if (argc==4) { helpScr() ; exit(0) ; }
    if (access(fname,0)) {
      printf("** file <%s> not found\n", fname ) ;
      exit(1);
    }
    ff = (FILE*) fopen( fname, "r" ) ;
    err = fscanf( ff,"%i", &pLen ) ;
    fclose( ff ) ;
    init() ;
    Lpp = 1000 ; err = readLN( 2, fname, &Lpp, pp ) ;
    if (err)  exit_proc( fname ) ;
    Lqq = Lpp ; err = readLN( 3, fname, &Lqq, qq ) ;
    if (err) exit_proc( fname ) ;
    if (gen_g()) { remove(fname) ; exit(77) ; } ;
    writeLN( 0, fname, Lgg, gg ) ;
    printf("g_parameter: <%s> updated. \n", fname ) ;
    timeF( &tm ) ;
    printf("%.2f seconds\n", tm ) ;
    bell( 4 ) ;
  }
  if (init_ed) exit_proc("") ;
}
