          



          Chapter 4 - JAWS Macros



          Macros                                            page - 66
          

          INTRODUCTION.

          JAWS provides the ability to define or record a "Macro".  A macro
          is defined as a sequence of simple, commonly performed operations
          grouped together as a single operation.  

          For  example,  every  morning  you probably perform the following
          sequence of operations:  you  find  your  tooth  brush  with your
          right hand, you pick up your tooth brush, with your left hand you
          find your toothpaste and pick it up.  You remove the cap from the
          toothpaste.    Next  you  squeeze  the toothpaste onto the brush,
          replace the cap on the tube of toothpaste and put  the tube down.
          Following  that,  you  place  the  toothbrush into your mouth and
          begin scrubbing.  When  you're  done  scrubbing,  you  rinse your
          mouth and  toothbrush, then you put your toothbrush back where it
          was.  All  these  operations  are  grouped  into  a  macro called
          "Brushing Your Teeth".  The individual steps are still performed,
          but you don't need to think  about all  the details  - you simply
          brush your teeth.

          Computer macros  are similar  - any sequence of keystrokes can be
          assigned to a single  "macro" key.   So,  for example,  you could
          assign the  sequence "Control-/,  V, G, V, Right Arrow, Alt-X" to
          the key Zero-F2; and  the  sequence  "Control-/,  V,  G,  V, Left
          Arrow, Alt-X"  to the  key Zero-F1.  Then, whenever you hold down
          the Zero key and press function key "F1",  you will  decrease the
          global volume  one level.   Similarly,  "Zero-F2" (with the macro
          definition) will increase the global volume one level.  Both will
          operate from within any of your favorite applications, as long as
          JAWS is running.

          JAWS Macro  keys can  not only  control JAWS  functions, they can
          also  control  application  programs.   For example, the sequence
          "F7, Y, Enter, Y, Y" could be assigned to a key such as Zero-X to
          provide  a  quick  "save  and  exit"  key  to operate within Word
          Perfect.

          JAWS provides two ways  for  you  to  create  a  macro,  from the
          keyboard or through the JAWS Menu System.  The functions provided
          in the menu system also allow you to  revise or  edit an existing
          definition, duplicate  or erase a definition, and display defined
          macro keys and their definitions.

          RECORDING MACROS FROM THE KEYBOARD.

          Recording a macro  from  the  keyboard  will  simply  capture the
          keystrokes typed - it will not allow editing of those keystrokes.
          To place JAWS in a "Record Macro" mode, simply hold down the Zero
          key on  the numeric  pad and  press the number "2" on the numbers
          row.  The synthesizer will respond:  "Enter  key to  be defined".

          Macros                                            page - 67
          

          At this point, simply type the key to be assigned the definition.
          Any key can be used as well as five different "Shifted" states of
          any of  the keys.   The  available shifted  states are:  "Shift",
          "Control", "Alt", "Zero", and "Num Lock".   Simply  hold down one
          of these "Shift" keys and type the key to define.

          Next, the  synthesizer will ask you to enter the definition to be
          assigned to that key.  At this point, type the  key sequence that
          you want  executed when  the single  key is pressed.  When you're
          done entering  the  sequence,  simply  type  Zero-2  again.   The
          synthesizer will  respond "RECORD MACROS" and the definition will
          be complete.

          After a macro has been recorded in the manner just  described, it
          can be  executed by  pressing the key assigned the definition or,
          by using  the  menu  system,  duplicated,  erased,  identified or
          revised.

          MACRO ENABLE/DISABLE.

          Holding down  the Zero  key and pressing the 4 on the numbers row
          will toggle macros on or off.  When  macros are  turned on  and a
          defined macro key is pressed, the definition assigned to that key
          will be used.  When macros are turned  off and  a defined  key is
          pressed,  that  key  will  simply bypass the macros, the assigned
          definition will not be used.

          The default is for  macro  keys  to  be  turned  on;  however, if
          several  of   the  macro   key  definitions   conflicts  with  an
          application  program,  macros  can  be  turned   off  while  that
          application is in use.

          As an  alternative, if  only one  or two keys are in conflict, it
          may be simpler to use the JAWS Pass Key Through function whenever
          a conflicting  key is needed by the application.  By holding down
          the Zero key and pressing the  number 3  on the  numbers row, the
          next key typed will be passed directly through to the application
          without any  interpretation by  JAWS.   For example,  if you have
          assigned a  JAWS macro  to Control-F1  which will read a frame of
          text and you decide to run an application  which also  provides a
          definition for  Control-F1, then  by pressing Zero-3 (the numbers
          row  3)  and  Control-F1,  you  will   pass  Control-F1   to  the
          application, without turning off the macros.

          THE JAWS MACROS MENU.

          On the Main Menu of the JAWS Menu System is a selection entitled:
          "Macro".  It can be selected by either  moving the  highlight bar
          to that  point and  pressing "Enter" or "Next Line", or by typing
          the letter "M" from  anywhere within  the main  menu.   When this

          Macros                                            page - 68
          

          menu is entered, the selection "Revise" will be selected, it will
          allow you to create or revise a macro key definition.   The other
          selections  on  this  menu  are:    Duplicate,  to  copy  a macro
          definition; Erase, to eliminate a macro definition; and Identify,
          to display the defined macro keys.

          Revise - Create or Revise a Macro.

          Selecting the  option "Revise" will allow you to create or revise
          a macro definition.  This selection, as compared  to the keyboard
          macro record function, provides full editing capabilities.  After
          you select "Revise", you  will be  asked to  enter the  key to be
          revised.   Enter the key whose definition you wish to edit or the
          key you wish to assign a definition to.

          If the key entered has a  macro definition  assigned to  it, that
          definition will be displayed on the screen on line 1 (or  as much
          of that definition as  is possible  to display).   The definition
          which exists  or which  is entered can be edited at any time.  To
          edit a definition,  simply  hold  down  the  "Control"  and "Left
          Shift" keys  simultaneously, and  press any  cursor movement key.
          Pressing the "Left Arrow" key will move the  cursor to  the prior
          key typed, pressing the "Right Arrow" will move the cursor to the
          next key in the definition.  Pressing the "5" will  speak the key
          symbol which appears under the cursor.

          "Control-Left Shift"  and the  "Home" key will move the cursor to
          the beginning of the definition and "Control-Left Shift" plus the
          "End" key  will move the cursor to the vary end of the definition
          - the position where the next key typed should go.

          The default  is "insert"  mode.   Anything typed  while in insert
          mode  will  be  placed  before  the  key symbol under the cursor;
          "Control-Left Shift"  and the  "Delete" (or  "Decimal Point") key
          will delete  the key  symbol under  the cursor and move the other
          symbols to the right of the cursor over to fill the space.  

          When the definition is  complete, press  "Control-Left Shift" and
          the  "Enter"  or  "Next  Line"  keys  and you will exit the macro
          revise system and return to the Macro menu - the  definition will
          be  saved.    If  you  decide  not  to  save  the  new or altered
          definition, simply press "Control-Left Shift" and either "Escape"
          or "Prior  Line".  You will return to the Macro menu, but the old
          definition, if any, will be restored.

          Duplicate - Duplicate a Definition.

          If you select this option from the Macro menu, you  will be asked
          to  enter  the  macro  key  you  wish to duplicate and the key to
          receive the duplicate definition.   Simply  press  the  key which

          Macros                                            page - 69
          

          contains the  definition (or  any of  its shifted states:  Shift,
          Control, Alt, Zero, or Num Lock) followed by  the key  to receive
          the definition (or any of its shifted states).

          After  you  enter  both  keys  and  if the receiving key does not
          already have  a definition,  the key  will be  duplicated and you
          will be  returned to  the Macro  menu.   If the  receiving key is
          already defined, or if the original key is not defined,  you will
          be asked to re-enter the incorrect key.  To copy to a key that is
          already defined you must first erase that definition  in order to
          give it a new one. 

          Erase - Erase a Definition.

          If you  select this option from the Macro menu, you will be asked
          which key you wish to erase.  Simply enter the key (or any of its
          shifted states:  Shift, Control, Alt, Zero, or Num Lock) and JAWS
          will erase the definition assigned to this key.

          Identify - Identify Defined Keys.

          If you select this option from the Macro menu, JAWS  will display
          the defined keys on line one of the menu.  Since all the possible
          macro keys will not  fit  on  one  line  the  screen  will scroll
          horizontally.   Use the  left or right arrow keys or the prior or
          next word keys to move the highlight and speak the macro key.



          Macros                                            page - 70
