/* SBIO.H  */
/* Copyright 1995 by Ethan Brodsky.  All rights reserved */
/* Modified extensively by Philip VanBaren to suit my purposes */
/* 1997 (C) Emil Laurentiu */
/* Last Modified Wednesday, 06 August 1997 */

typedef enum
{
  input, output
}	      mode;

/* Low level I/O functions */
void	      write_dsp( unsigned char value );
unsigned char read_dsp( void );
int	      reset_dsp( void );

/* Interface procedures and functions */
int	      init_sb( int baseio, char irq, char dma16, mode io, unsigned int length );
void	      shutdown_sb( void );
void	      startio( unsigned int rate, unsigned long length );
void	      stopio( void );

/* Mixer functions */
void	      set_cd_level( unsigned int );
void	      set_mic_level( unsigned int );
void	      set_line_level( unsigned int );
unsigned int  get_cd_level( void );
unsigned int  get_mic_level( void );
unsigned int  get_line_level( void );
void	      set_master_level( int level );
void	      set_fm_level( int level );
void	      installhandler( void );
void	      uninstallhandler( void );
void	      sb_exitproc( void );

/* Asm functions */
void far      set_SB_address( int base );
int far	      dma_reset( int Channel );
int far	      dma_setup( int Channel, char far * Buffer, unsigned Length, int Dir );
int far	      dma_done( int Channel );
void far      dsp_voice( int );
int far	      dsp_reset( void );
void far      dsp_time( int );
void far      dsp_dma_prepare( int Dir, int Length );

extern int    sb_irq;		/* IRQ used by the Soundblaster card */
extern int    sb_dma;		/* DMA channel used by the Soundblaster card */
extern int    sb_addr;		/* I/O address of the Soundblaster card */

extern int    dma_errno;
extern char  *dma_errlist[];

extern volatile int sb16dmarunning;
extern volatile char curblock;
extern int far *dmaptr;		/* Pointer to beginning of DMA buffer */
