/*
 *  Global variable definitions
 */

/* Soundcard function pointers */
extern void   ( *reset_soundcard ) ( void );
extern void   ( *halt_soundcard ) ( void );
extern void   ( *cleanup_soundcard ) ( void );
extern void   ( *recordblock ) ( void far * );
extern void   ( *set_mixer ) ( int, int );

extern int    mixers;		/* Flag for mixer available */
extern int    sample_size;	/* Sample size, in bits (8 or 16) */
extern int    mic_level;	/* Storage for mic input mixer level (0-100) */
extern int    ext_level;	/* Storage for ext input mixer level (0-100) */
extern int    int_level;	/* Storage for int input mixer level (0-100) */
extern int    Soundcard;	/* Soundcard number (as defined in freq.h) */

/* Data for display updates */
extern int    x[];		/* Array of bin numbers's displayed */
extern int    x2[];		/* Final bin for lines on which multiple bins
				 * lie */
extern int    lasty[];		/* Memory for the last display location */
extern long  *displayval;	/* Memory for the current display value */
extern long  *ybase;		/* Scaling offset for log calculations */
extern unsigned int yscale[];	/* Scaling factors */
extern long far **databuf;	/* Memory used for averaging mode */
extern int    shift;		/* Number of bits for gain shift */
extern double shiftscale;	/* Multiplication factor that does this shift */
extern int    logfreq;		/* Flag set to 1 for log-based frequency
				 * scale */
extern float  ys;		/* Peak display value for linear-amplitude
				 * display */
extern float  maxfreq;		/* Maximum frequency displayed */
extern float  disp_scalefactor; /* Scale factor used for displaying log(amp) */
extern float  log_scalefactor;	/* Scale factor used for computing log(amp) */
extern float  freq_scalefactor; /* Scale factor for frequency axis */
extern float  freq_base;	/* Lowest frequency displayed */
extern int    display_peak;	/* Flag for displaying the peak information */
extern int    freeze;		/* Flag for freeze-frame mode */

/* Data for the FFT routines */
extern short *fftdata;		/* Output data from the FFT routine */
extern short *wind;		/* Array storing windowing function */

/* Buffers for sampling new data */
extern volatile int flag[];	/* Array of flags indicating fullness of
				 * buffers */
extern void far *buffer[];	/* Buffers for gathering data */
extern int    queue_buffer;	/* Pointer to the next buffer to be queued */
extern volatile int record_buffer;	/* Pointer to the next buffer to be
					 * recorded */
extern int    process_buffer;	/* Pointer to the next buffer to be processed */
extern long   SampleRate;	/* Sampling rate in Hz */
extern int    fftlen;		/* Length of the FFT performed */

extern float  threshold_level;	/* threshold value for DTMF & CTCSS modes */
extern int    p_dtmf;		/* Pointer in the DTMF table */
extern char   dtmf_nr[];	/* String to hold the DTMF number */
extern int    dtmf_mode;	/* Flag indicating when decoding DTMF */
extern int    ctcss_mode;	/* Flag indicating when decoding CTCSS */
extern FILE  *log_file;		/* File pointer to log file */
extern int    log_mode;		/* Flag indicating loggin mode */
extern double f_ctcss[];	/* CTCSS frequencies table */
extern unsigned long ctcss_act1, ctcss_act2;
				/* Active CTCSS frequencies table */
extern double err_ctcss;	/* error when generating CTCSS */
extern int    gen_ctcss;	/* CTCSS frequency number (38 means none) */
extern int    dtmf_delay;	/* Length of generated DTMF tones in ms */
extern int    help_mode;	/* Flag indicating when the help display is
				 * active */
extern char   ini_file[];	/* Filename for the INI file */
extern char  *window_name[];	/* Descriptive names for the window functions */

extern struct rgb background, warn, graph, tick, label, border, text, darkhl, lighthl;

/* Miscellaneous variables */
extern int    _font_height;
extern int    _font_width;
extern int    _font_color;
