/*
 *	sbif.h  --  simple binary image format.
 *
 *
 *	24 jul 1989  Olle Olsson.
 */

/* size of the header */
#define SBHSIZE  128

/*
 * The header is plain ascii and contains (white-space separated):
 * file name, x pixel count, y pixel count ....
 */

/* the number of bytes required to hold one pixel line */
#define XBYTES( xpixels )	((xpixels) / 8 + ((xpixels) % 8 != 0))

/*
 * The data is a two dimensional matrix of (one-bit) pixels.
 * X is the fastest changing index.
 * The first bit is the msb of the first byte (as EGA, Hercules, ...).
 * The x lines of data are padded (if necessary) to full bytes.
 * The number of x lines is the y pixel count.
 * The y coordinate is upside down, i.e. the top line is first.
 */
