/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include <stdio.h>
#include <stdlib.h>
#include "sse.h"
#include "ssecapt.h"
#include "ssedvid.h"

#define REVISION        "1"

/************************************     Buffer Sizes    */

#define MAX_CHARS       (256 - 32)
#define MAX_PCX_SIZE    (1024 * 768)
#define MAX_FONT_DATA   (MAX_CHARS * 2000)


int main( int argc, char * argv[] )
{
   char *inbuffer, *outbuffer, *out;
   dvFontHeader * fh;
   int filecount, framecount;
   imgInfo inputimg;
   FILE * fp;

   void SetupFontHeader( dvFontHeader * hdr );
   int ReadWholePCX( char * dest, imgInfo * img, char * filename );
   int CaptureAllFrames( char * outbuffer, char ** CP, imgInfo * pic, dvFontHeader * hdr );

   if( argc < 3 )
   {
      printf( "\nUsage: CAPT-FNT <input-pcx-names>... <output-font-name>\n\n" );
      return EXIT_FAILURE;
   }

   printf("\n CAPT-FNT Utility  Version %s  Revision %s\n\n",SSE_VERSION,REVISION);
   
   inbuffer = malloc( MAX_PCX_SIZE );
   outbuffer = malloc( MAX_FONT_DATA );
   fh = (dvFontHeader*) malloc( sizeof(dvFontHeader) + (MAX_CHARS-1) *
      sizeof( dvFontCharInfo ) );
   if( !inbuffer || !outbuffer || !fh )
   {
      printf( "Memory allocation failed!\n" );
      printf( "  Solution: Free more EMS/XMS.\n\n" );
printf("%ld",MAX_FONT_DATA);
      return EXIT_FAILURE;
   }

   SetupFontHeader( fh );

   filecount = 1;
   framecount = 0;
   out = outbuffer;
   while( filecount < argc - 1 )
   {
      if( ReadWholePCX( inbuffer, &inputimg, argv[filecount] ) ) return EXIT_FAILURE;

       printf( "File \"%s\" resolution %d x %d  -Working-",argv[filecount],
         inputimg.Width, inputimg.Height );

      if( CaptureAllFrames( outbuffer, &out, &inputimg, fh ) ) return EXIT_FAILURE;

      printf( "\b\b\b\b\b\b\b\b\bCharacters Captured: %d\n", fh->NumChars-framecount );

      framecount = fh->NumChars;
      filecount++;
   }

   printf( "Writing file \"%s\".\n", argv[filecount] );

   if(!( fp = fopen( argv[filecount], "wb" )))
   {
      printf("Error opening file!\n");
      return EXIT_FAILURE;
   }
   fwrite( fh, sizeof( dvFontHeader ) + (fh->NumChars-1) * 
      sizeof( dvFontCharInfo ), 1, fp );
   fwrite( outbuffer, out-outbuffer, 1, fp );
   fclose( fp );
   
   if( filecount > 2 )
      printf("\n Total: %d characters captured.\n\n", fh->NumChars );

   return EXIT_SUCCESS;

}

void SetupFontHeader( dvFontHeader * hdr )
{
   hdr->IDNumber = FONT_HEADER_ID;
   hdr->NumChars = 0;
   hdr->Height = 0;
   hdr->XMargin = 1;
   hdr->YMargin = 1;
}

int ReadWholePCX( char * dest, imgInfo * img, char * filename )
{ 
   FILE * fp;
   pcxHeader ph;

   if( !( fp = fopen( filename, "rb" )) )
   {
      printf( "Error opening PCX file \"%s\"!\n\n", filename );
      return 1;
   }
   pcxGetHeader( & ph, fp );

   if( ph.BitsPerPixel != 8 )
   {
      printf( "PCX file \"%s\" is not in 256 colors!\n\n", filename );
      fclose( fp );
      return 1;
   }

   if( ph.Width * ph.Height > MAX_PCX_SIZE )
   {
      printf( "Cannot handle PCX file \"%s\"!\n", filename );
      printf( "  Solution: Increase CAPT-SSP \"MAX_PCX_SIZE\" value.\n\n" );
      return 1;
   }
   
   pcxDecodeToBuffer( dest, ph.Width, ph.Height, fp );
   fclose( fp );

   img->Width = ph.Width;
   img->Height = ph.Height;
   img->BytesPerRow = ph.Width;
   img->Data = dest;

   return 0;
}

int CaptureAllFrames( char * outbuffer, char ** CP, imgInfo * pic, dvFontHeader * hdr )
{
   char BackColor, TagColor, * in, * out;
   int w;
   imgInfo * img;
   dvFontCharInfo * fi;
   out = *CP;

   BackColor = *(pic->Data);
   in = pic->Data;
   w = pic->Width;

   fi = hdr->Character + hdr->NumChars;

   while( *in == BackColor )
   {
      in++;
      if( !(--w) )
      {
         w = pic->Width;
         in += pic->BytesPerRow - pic->Width;
         if( in >= pic->Data + pic->BytesPerRow * pic->Height ) break;
      }
   }
   TagColor = *in;

   if( in >= pic->Data + pic->BytesPerRow * pic->Height ) return 0;

   while( 1 )
   {
      img = imgFindNext( pic, in, TagColor );

      if( img->Width == 0 ) break;
      in = img->Data + img->Width;  // Set up for next image

      if( img->Width > 255 )
      {
         printf( "\nCharacters cannot be wider than 255 pixels!\n" );
         return 1;
      }
      if( img->Height > 255 )
      {
         printf( "\nCharacters cannot be higher than 255 pixels!\n" );
         return 1;
      }
      if( hdr->Height == 0 ) hdr->Height = img->Height;
      else if( img->Height != hdr->Height )
      {
         printf( "\nCharacters are not the same heights!\n" );
         return 1;
      }
      if( out + ((img->Width + 7)>>3) * img->Height > outbuffer + MAX_FONT_DATA )
      {
         printf( "\nOut of font data memory!\n" );
//         printf( "  Solution: Increase CAPT-FNT \"MAX_FONT_DATA\" value.\n\n");
         return 1;
      }
      if( hdr->NumChars >= MAX_CHARS )
      {
         printf( "\nCannot handle more than %d characters!\n",MAX_CHARS );
         return 1;
      }

      out = captFontChar( fi, outbuffer, out, img, BackColor );

      fi++;
      hdr->NumChars++;
   }

   *CP = out;
   return 0;

}


