/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */
/*                                                                          */
/*                       Capture Program Header File                        */

#ifndef _SSECAPT_H_INCLUDED

/*  C++ compatibility  */

#ifdef __cplusplus
extern "C" {
#endif

#include<stdio.h>
#include"sse.h"
#include"ssedvid.h"

#define TILE_GRAPHIC_ID      0x55E77600
#define SPRITE_HEADER_ID   0x55E79203
#define FONT_HEADER_ID      0x55E7F000

typedef struct
{
   char Manufacturer;
   char Version;
   char Encoding;
   char BitsPerPixel;
   short Xmin, Ymin;
   short Xmax, Ymax;
   short Width;
   short Height;
   char Palette[ 48 ];
   char Reserved1;
   char Planes;
   short BytesPerRow;
   short PaletteType;
   char Reserved2[ 58 ];
} pcxHeader;

void pcxDecodeToBuffer( char *, unsigned, unsigned, FILE * );

void pcxGetPalette( char *, FILE * );

void pcxGetHeader( pcxHeader *, FILE * );

typedef struct
{
   int Width;
   int Height;
   int BytesPerRow;
   char * Data;
} imgInfo;

typedef struct
{
   int Draw;
   int Erase[ 4 ];
} HiddenSpriteInfo;

typedef struct
{
   unsigned char FileNum;
   unsigned char XPos;
   unsigned short YPos;
} TileLocInfo;

imgInfo * imgFindNext( imgInfo * SrcImg, char * CP, unsigned char TagColour );

void captSetupSSPHeader( sseSpriteHeader * hdr, HiddenSpriteInfo * hsi, int linelength );

int captSetupSpriteGraphicInfo( sseSpriteGraphicInfo * SI, HiddenSpriteInfo * HSI, imgInfo * img, short PivotX, short PivotY, unsigned char BackColor );

char * captSSPFrame( sseSpriteGraphicInfo * SI, char * BufTop,   char * out, imgInfo * img, unsigned char BackColor, int DestLineLength );

char * captEraseFrame( sseSpriteGraphicInfo * SI, char * BufTop, char * out, imgInfo * img, unsigned char BackColor, int DestLineLength );

char * captFontChar( dvFontCharInfo * FI, char * BufTop, char * out, imgInfo * img, unsigned char BackColor );

char * captTile( char * out, imgInfo * img );


#define _SSECAPT_H_INCLUDED
#ifdef __cplusplus
};
#endif
#endif
