#! /bin/csh -f
set command=`basename $0`
if ($#argv != 2) then
  echo $command": bad number of arguments"
  exit 1
endif
if (! -r $1) then
  echo $command": cannot open "$1
  exit 1
endif
if (! -r $2) then
  echo $command": cannot open "$2
  exit 1
endif
set tmp=/tmp/$command"$$"
onintr quit
cat <<'EOF' >$tmp
BEGIN	{
	FS = " "
	getline
	getline
	}
/atoms/	{
	print "% Converted to SCN"
	print "% Copyright 1992 Antonio Costa (acc@asterix.inescn.pt)"
	printf "\n#include \"mol.h\"\n\n"
	print "% Atoms:", $1, "- Bonds:", $3
	atoms = $1
	t++
	maxx = -10000
	maxy = -10000
	maxz = -10000
	minx = -maxx
	miny = -maxy
	minz = -maxz
	next
	}
/^[^0-9]/ {
	c[$1] = $4
	if ($6 == 0) r[$1] = 0.1
	if ($6 != 0) r[$1] = $6
	next
	}
/^[0-9]+ [^0-9]/ {
	printf "sphere surface matte %s data %g %g %g %g\n", \
	c[$2], $3, $4, $5, r[$2]
	if ($3 > maxx) maxx = $3
	if ($4 > maxy) maxy = $4
	if ($5 > maxz) maxz = $5
	if ($3 < minx) minx = $3
	if ($4 < miny) miny = $4
	if ($5 < minz) minz = $5
	atoms--
	if (atoms == 0) exit
	next
	}
END	{
	if (maxx < maxy && maxx < maxz)
	{
	  printf "\neye %g %g %g\n", \
	  maxx + 3 * (maxx - minx), maxy, maxz
	  printf "light point %g %g %g white\n", \
	  maxx + 2 * (maxx - minx), maxy, maxz
	}
	if (maxy < maxx && maxy < maxz)
	{
	  printf "\neye %g %g %g\n", \
	  maxx, maxy + 3 * (maxy - miny), maxz
	  printf "light point %g %g %g white\n", \
	  maxx, maxy + 2 * (maxy - miny), maxz
	}
	if (maxz < maxx && maxz < maxy)
	{
	  printf "\neye %g %g %g\n", \
	  maxx, maxy, maxz + 3 * (maxz - minz)
	  printf "light point %g %g %g white\n", \
	  maxx, maxy, maxz + 2 * (maxz - minz)
	}
	printf "at %g %g %g\n", \
	(maxx + minx) / 2.0, (maxy + miny) / 2.0, (maxz + minz) / 2.0
	}
'EOF'
cat $1 $2|tr -s " " " "|tr '[A-Z]' '[a-z]'|sed '1,$s/^ //'|awk -f $tmp
quit:
if (-e $tmp) rm -f $tmp
