/*
 * def.h contains some useful definitions for "C" programs.
 *
 * Author:  Eric Haines, 3D/Eye, Inc.
 */

/* exit codes - define as you wish */
#define	EXIT_SUCCESS	0
#define	EXIT_FAIL	1

#define EPSILON		5.0e-6

#ifndef FALSE
#define	FALSE	0
#endif

#ifndef NULL
#define	NULL	0
#endif

#ifndef TRUE
#define	TRUE	1
#endif

#ifndef PI
#define	PI	3.141592653589793
#endif

typedef	double	COORD3[3] ;
typedef	double	COORD4[4] ;

#define	X	0
#define	Y	1
#define	Z	2
#define	W	3

typedef	double		MATRIX[4][4] ;	/* row major form */

#define ABSOLUTE(A)		( (A) < 0 ? -(A) : (A) )
#define	FRACTION(A)		( (A) - (int)(A) )
#define	IS_VAL_ALMOST_ZERO(A,E)	( ABSOLUTE(A) <= (E) )
#define	MAX(A,B)		( (A) > (B) ? (A) : (B) )
#define	MIN(A,B)		( (A) < (B) ? (A) : (B) )
#define SQR(A)			( (A) * (A) )

#define ADD2_COORD3(r,a)	{ (r)[X] += (a)[X]; (r)[Y] += (a)[Y];\
				  (r)[Z] += (a)[Z]; }
#define ADD3_COORD3(r,a,b)	{ (r)[X] = (a)[X] + (b)[X];\
				  (r)[Y] = (a)[Y] + (b)[Y];\
				  (r)[Z] = (a)[Z] + (b)[Z]; }
#define COPY_COORD3(r,a)	{ (r)[X] = (a)[X];\
				  (r)[Y] = (a)[Y];\
				  (r)[Z] = (a)[Z];}
#define COPY_COORD4(r,a)	{ (r)[X] = (a)[X];\
				  (r)[Y] = (a)[Y];\
				  (r)[Z] = (a)[Z];\
				  (r)[W] = (a)[W]; }
#define CROSS(r,a,b)		{ (r)[X] = (a)[Y] * (b)[Z] - (a)[Z] * (b)[Y];\
				  (r)[Y] = (a)[Z] * (b)[X] - (a)[X] * (b)[Z];\
				  (r)[Z] = (a)[X] * (b)[Y] - (a)[Y] * (b)[X]; }
#define DOT_PRODUCT(a,b)	( (a)[X] * (b)[X] +\
				  (a)[Y] * (b)[Y] +\
				  (a)[Z] * (b)[Z] )
#define DOT4(a,b)		( (a)[X] * (b)[X] +\
				  (a)[Y] * (b)[Y] +\
				  (a)[Z] * (b)[Z] +\
				  (a)[W] * (b)[W] )
#define IS_COORD3_ALMOST_ZERO(a,E)	(\
				     IS_VAL_ALMOST_ZERO( (a)[X], (E) )\
				  && IS_VAL_ALMOST_ZERO( (a)[Y], (E) )\
				  && IS_VAL_ALMOST_ZERO( (a)[Z], (E) ) )
#define MAX_COORD3(a)		( MAX( MAX( (a)[X], (a)[Y] ), (a)[Z] ) )
#define SET_COORD3(r,A,B,C)	{ (r)[X] = (A); (r)[Y] = (B); (r)[Z] = (C); }
#define SET_COORD4(r,A,B,C,D)	{ (r)[X] = (A); (r)[Y] = (B); (r)[Z] = (C);\
				  (r)[W] = (D); }
#define SUB2_COORD3(r,a)	{ (r)[X] -= (a)[X]; (r)[Y] -= (a)[Y];\
				  (r)[Z] -= (a)[Z]; }
#define SUB3_COORD3(r,a,b)	{ (r)[X] = (a)[X] - (b)[X];\
				  (r)[Y] = (a)[Y] - (b)[Y];\
				  (r)[Z] = (a)[Z] - (b)[Z]; }
