/*
	Gauss Siedel Method of iterative Simultaneous Equation Solver.
	-------------------------------------------------------------
        Interface :
                gauss_iter(n,a,x,b)
                ----------
                where
                        n - is the dimension
                        a - Array of pointers
                            pointing to array of float.
                        b,x - arrays of float
                        tolerance - A scalar float value
                                much smaller than 0.
	
	WARNING:
		Matrix must be Diagonal Dominant.
		Otherwise converging is not guaranteed.
*/
#include <stdio.h>
#include <math.h>
extern int verbose_flag;
double **matrix(),*vector();
int gauss_iter(n,a,x,b,tolerance)
int n;
double **a,*x,b[];
double tolerance;
{
	double newx;
	double maxdelta;
	int count=0;
	if (verbose_flag)fprintf(stderr,"Iter Solve : ");
	do{
		int i;
		maxdelta=0.0;
		for(i=0; i < n; i++){
			int j;
			float delta;
			newx = b[i];
			for (j = 0; j < n; j++)
			 	if (j!=i)newx=newx-a[i][j]*x[j];
			newx /= a[i][i];
			delta = (float)fabs(newx - x[i]);
			x[i]=newx;
			if (delta > maxdelta) maxdelta=delta;
		}
		if (verbose_flag)fprintf(stderr,".");
		count++;
		if (count > n) break;
	}while (maxdelta > tolerance);
	if (verbose_flag)fprintf(stderr,"\n");
}
int diagonally_dominant(n,a)
int n;
double **a;
{
	int i,j;
	double sum;
	for(i=0;i<n;i++){
		for(j = 0,sum = -fabs(a[i][i]);j<n;j++) sum += fabs(a[i][j]);
		if(fabs(a[i][i])<sum)return(0);
	}
	return(1);
}
