#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include <allegro.h>

#include <string.h>
#include <math.h>
#include <unistd.h>

#include <sys/time.h>
#include <sys/times.h>

#include "dither.h"

#define BSIZE 400
int depth=8;
int grayscale=0;
unsigned char rgb[3]={0,1,2};

int mouse=1;
int key_motion_speed=10;
int command;
int width=640,height=480;
BITMAP *background;

typedef unsigned char byte;
byte *bgmem;

typedef float real;
typedef real vec[3];
typedef vec mat[3];
typedef unsigned char uchar;


typedef struct { uchar r,g,b;} file_pixel;

inline vec *vec_copy(vec *a,vec *b) {                  /* a=b */
  a[0][0]=b[0][0],a[0][1]=b[0][1],a[0][2]=b[0][2];
  return a;
}

inline vec *vec_add(vec *a,vec *b) {                   /* a+=b */
  a[0][0]+=a[0][0];a[0][1]+=b[0][1];a[0][2]+=b[0][2];
  return a;
}

inline vec *vec_sub(vec *a,vec *b) {                    /* a-=b */
  a[0][0]-=b[0][0];a[0][1]-=b[0][1];a[0][2]-=b[0][2];
  return a;
}

inline vec *vec_r(vec *a,real r) {                      /* a*=r */
  a[0][0]*=r,a[0][1]*=r,a[0][2]*=r;
  return a;
}

inline mat *mat_copy(mat *a,mat *b) {
  bcopy(b,a,sizeof(*a));
}

inline mat *mat_mul(mat *c,mat *a,mat *b) {             /* c=a*b */
  int i,j;
  for(i=0;i<3;i++)
    for(j=0;j<3;j++) {
      (*c)[j][i]=(*a)[j][0]*(*b)[0][i]+(*a)[j][1]*(*b)[1][i]+(*a)[j][2]*(*b)[2][i];
    }
};

void mat_rotaxis(mat *a,real fi,int axis) {
  mat r={{1,0,0},{0,1,0},{0,0,1}},s;
  int i,j;
  fi=fi*M_PI/180;
  switch(axis) {
   case 0:i=1,j=2;break;
   case 1:i=0,j=2;break;
   case 2:i=0,j=1;break;
   default:return;
  }
  r[i][i]=r[j][j]=cos(fi);
  r[i][j]=-sin(fi);
  r[j][i]=sin(fi);
  mat_copy(&s,a);
  mat_mul(a,&s,&r);
}

mat *mat_rotaxyz(mat *a,real x,real y,real z) {
  mat_rotaxis(a,x,0);
  mat_rotaxis(a,y,1);
  mat_rotaxis(a,z,2);
}

void pmap_rotate(register file_pixel *x,register int dir) {
  register int i,j;
  register file_pixel *y;
  y=(file_pixel*)malloc(sizeof(file_pixel)*BSIZE*BSIZE);
  bcopy(x,y,sizeof(file_pixel)*BSIZE*BSIZE);
  for(j=0;j<BSIZE;j++)
    for(i=0;i<BSIZE;i++)
       if(dir>0) x[BSIZE*j+i]=y[BSIZE*i+j];
       else x[BSIZE*i+j]=y[BSIZE*j+i];
  free(y);
}

void pmap_mirror(register file_pixel *x,register int y) {
  register int i,j;
  register file_pixel c;
  for(j=0;j<BSIZE;j++)
    for(i=0;i<BSIZE/2;i++)
      if(y)
        c=x[BSIZE*i+j],x[BSIZE*i+j]=x[BSIZE*(BSIZE-i-1)+j],x[BSIZE*(BSIZE-i-1)+j]=c;
      else
        c=x[BSIZE*j+i],x[BSIZE*j+i]=x[BSIZE*j+BSIZE-i-1],x[BSIZE*j+BSIZE-i-1]=c;
}

void pmap_rgb(register file_pixel *p) {
  if(rgb[0]==0&&rgb[1]==1&&rgb[2]==2)
    return;
  uchar q[3];
  file_pixel *pe=p+BSIZE*BSIZE;
  while(p<pe) {
    (*(file_pixel*)(q))=*p;
    p->r=q[rgb[0]],p->g=q[rgb[1]],p->b=q[rgb[2]];
    p++;
  }
}

typedef unsigned char *screen_pixel;


BITMAP *bmap[6];
byte *pmap[6];

BITMAP *side_read(char *filename,int how) {
  FILE *f;
  char line[80];
  int w,h;
  byte *data;
  BITMAP *bs;
  rgbmap fm;
  char *ext;

  if(!(f=fopen(filename,"rb"))) return 0;
  ext=strrchr(filename,'.');
  if(!ext) {
   defext:
    fm.import_tga(f);           // default is tga
  } else {
    ext++;
    if(!strcasecmp(ext,"ppm"))  // if there is extension ppm do ppm
      fm.import_ppm(f);
    else
      goto defext;
  }
  fclose(f);
  data=(byte*)fm.data;
  if(!grayscale)
    pmap_rgb((file_pixel*)data);
  switch(how) {
   case 0:pmap_rotate((file_pixel*)data,-1);pmap_mirror((file_pixel*)data,1);break;
   case 1:pmap_mirror((file_pixel*)data,1);break;
   case 3:pmap_rotate((file_pixel*)data,1);break;
   case 5:pmap_mirror((file_pixel*)data,0);break;
  };
  /* translation to less depth */
  bs=create_bitmap(BSIZE,BSIZE);
  switch(depth) {
   case 8:{
    if(!grayscale)
      fm.dither(1,(byte*)bs->dat,1,8,8,8,64,4);
    else
      fm.grayscale((byte*)bs->dat);
    if(!how) {
      int i;
      RGB c;
      for(i=0;i<256;i++) {
        if(!grayscale) {
          c.r=i/1%8*63/7;
          c.g=i/8%8*63/7;
          c.b=i/64%4*63/3;
        } else
          c.r=c.g=c.b=(i*63+62)/255;
        set_color(i,&c);
      }
    }
   } break;
   case 15:fm.dither(2,(byte*)bs->dat,
      1<<_rgb_r_shift_15,32,1<<_rgb_g_shift_15,32,1<<_rgb_b_shift_15,32);
    break;
   case 16:fm.dither(2,(byte*)bs->dat,
      1<<_rgb_r_shift_16,32,1<<_rgb_g_shift_16,64,1<<_rgb_b_shift_16,32);
    break;
   case 24:fm.dither(3,(byte*)bs->dat,
      1<<_rgb_r_shift_24,256,1<<_rgb_g_shift_24,256,1<<_rgb_b_shift_24,256);
    break;
   case 32:fm.dither(4,(byte*)bs->dat,
      1<<_rgb_r_shift_32,256,1<<_rgb_g_shift_32,256,1<<_rgb_b_shift_32,256);
    break;
  }
  /* done */
  fm.free();
  return bs;
 r0:
  fclose(f);
  return 0;
}

#define FIX_BITS 16
#define MULT (1<<FIX_BITS)
typedef int myfix;
#define R2F(X) ((myfix)((X)*MULT))
#define F2R(X) (((real)(X))/MULT)
#define FDIV(X,Y) (((X)<<(FIX_BITS/2))/((Y)>>(FIX_BITS-FIX_BITS/2)))

inline void minimum(myfix x,myfix dx,myfix z,myfix dz,int *min) {
  register int d,e;
  if(dz>=0)
    if(dx>=0)   // dz>=0 && dx>=0
      if(dz>=dx) return;
      else d=(z-x)/(dx-dz);
    else        // dz>=0 && dx<0
      if(dz>=-dx) return;
      else d=(z+x)/(dz-dx);
   else
     if(dx>=0) { // dz<0 && dx>=0
       d=(z-x)/(dx-dz);                 // potud ok
       if(dz<-dx) {
         e=(z+x)/(-dx-dz);
         if(e<d) d=e;
       }
     } else  {      // dz<0 && dx<0
       d=(x+z)/(-dx-dz);           // odtud ok
       if(dz<dx) {
         e=(z-x)/(dx-dz);
         if(e<d) d=e;              //  if(e>=1&&e<d) d=e;
       }
     }
  if(d<1) *min=1;
  else
    if(*min>d) *min=d;


    }


// depth dependent
// z musi byt vetsi jak 0 a v absolutni hodnote vetsi jak x a y po celou interpolaci

#define DEPTH_PART(ID,TYPE) \
inline void interpolator_ ## ID (\
  myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,\
  TYPE *map,TYPE *buf,int steps) {\
  register myfix x2,y2;\
  while(steps--) {\
    x2=FDIV(x,z);\
    y2=FDIV(y,z);\
    x2=(x2+MULT+MULT/BSIZE/1)*(BSIZE-2)/(MULT*2);\
    y2=(y2+MULT+MULT/BSIZE/1)*(BSIZE-2)/(MULT*2);\
    *buf++=map[y2*BSIZE+x2];\
    x+=dx,y+=dy,z+=dz;\
  }\
}\
\
int scanline_ ## ID (myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,byte *buffer) {\
  int len=width,min,m;\
  register myfix x2,y2,z2,dx2,dy2,dz2;\
  TYPE *buf=(TYPE*)buffer;\
  while(len) {\
    x2=abs(x),y2=abs(y),z2=abs(z);\
    if(x2>=y2&&x2>=z2) {z2=x,dz2=dx,x2=y,dx2=dy,y2=z,dy2=dz;m=0;}\
    else if(y2>=x2&&y2>=z2) {z2=y,dz2=dy,x2=x,dx2=dx,y2=z,dy2=dz;m=1;}\
    else {z2=z,dz2=dz,x2=x,dx2=dx,y2=y,dy2=dy;m=2;};\
    if(z2<0) m+=3,z2=-z2,dz2=-dz2;\
    min=len;\
    minimum(x2,dx2,z2,dz2,&min);\
    minimum(y2,dy2,z2,dz2,&min);\
    interpolator_ ## ID (x2,dx2,y2,dy2,z2,dz2,(TYPE*)pmap[m],buf,min);\
    x+=min*dx,y+=min*dy,z+=min*dz;\
    buf+=min,len-=min;\
  }\
}

typedef struct { char x[1];} s8;
typedef struct { char x[2];} s16;
typedef struct { char x[3];} s24;
typedef struct { char x[4];} s32;

DEPTH_PART(8,s8)
DEPTH_PART(16,s16)
DEPTH_PART(24,s24)
DEPTH_PART(32,s32)

int (*scanline)(myfix x,myfix dx,myfix y,myfix dy,myfix z,myfix dz,byte *buffer);

real zoom=1;
real aspect=-1;
char pmap_permutation[]={1,5,0,3,4,2};

int init(char *filename) {
  int i,j,k;
  char fn[256],*digit;
  for(i=0,digit=0;i<sizeof(fn)&&(fn[i]=filename[i]);i++)
    if(fn[i]>='0'&&fn[i]<='5')
      digit=fn+i;
  if(!digit)
    return 1;
  for(k=0;k<6;k++) {
    *digit='0'+pmap_permutation[k];
    bmap[k]=side_read(fn,k);
    if(!bmap[k]) return 1;
    pmap[k]=(byte*)bmap[k]->dat;
  }
  switch(depth) {
    case 8:scanline=scanline_8;break;
    case 15:
    case 16:scanline=scanline_16;break;
    case 24:scanline=scanline_24;break;
    case 32:scanline=scanline_32;break;
  }
  return 0;
};


void loop() {
  byte *p;
  register int i,j;
  static int t=0;
  mat ori={{1,0,0},{0,1,0},{0,0,1}},ori2;
  vec vs,vx,vy;
  real ri,rj;
  int key,lx=mouse_x,ly=mouse_y,mx=width/2,my=height/2;
  int dirty=1;

 a1:
  if(mouse) {
    if(mouse_x!=lx||mouse_y!=ly) {
      mx+=mouse_x-lx;lx=mouse_x;
      my+=mouse_y-ly;ly=mouse_y;
      dirty++;
    }
  };
  while(keypressed()) {
    key=readkey();
    dirty++;
    switch(key>>8) {
     case KEY_LEFT:mx-=key_motion_speed;break;
     case KEY_RIGHT:mx+=key_motion_speed;break;
     case KEY_UP:my-=key_motion_speed;break;
     case KEY_DOWN:my+=key_motion_speed;break;
     case KEY_ESC:
     case KEY_Q:return;
     case KEY_Z:zoom*=1.1;break;
     case KEY_X:zoom/=1.1;break;
     default:dirty--;break;
    }
  }
  t++;
  if(!dirty) {
    usleep(10000);
    goto a1;
  }
  dirty=0;
  mat_copy(&ori2,&ori);
  mat_rotaxyz(&ori2,my-height/2,mx-width/2,0);
  vec_r(vec_copy(&vx,ori2),zoom);
  vec_r(vec_r(vec_copy(&vy,ori2+1),zoom),aspect);
  vec_sub(vec_sub(vec_copy(&vs,ori2+2),&vy),&vx);
  vec_r(&vx,2);
  vec_r(&vy,2);

  // time to go to fixed arithmetic

  { myfix sx=R2F(vs[0]),sy=R2F(vs[1]),sz=R2F(vs[2]);
    myfix xx=R2F(vx[0]/width),xy=R2F(vx[1]/width),xz=R2F(vx[2]/width);
    myfix yx=R2F(vy[0]/height),yy=R2F(vy[1]/height),yz=R2F(vy[2]/width);
    myfix ax,ay,az;
    p=bgmem;
    for(j=height;j;j--) {
      scanline(sx,xx,sy,xy,sz,xz,p);
      p+=width*((depth+7)>>3);
      sx+=yx,sy+=yy,sz+=yz;
    }
  }
  blit(background,screen,0,0,0,0,width,height);
  goto a1;
}

char help_str[]=
"look [-h] [-d n] [-g] [-r XxY] [-t RGB] [-z r] [-a x/y] file[0-5].{tga,ppm}\n"
"\n"
"the files are found with following algorithm, last occurence of digits [0-5] is\n"
"taken as index field in the filename, 6 files with digits 0-5, are opened.\n"
"\n"
"-d n	where n is colordepth of the screen in bits, can be 8,15,16,24 or 32, \n"
"	the greater depth, the better picture, but slower rednering. 32 bits\n"
"	can be faster then 24 bits. Default setting is 640x480 in 8 bit, to\n"
"	start in safe mode. Pictures must have size 400x400\n"
"-g	grayscale, sets 8bit, grayscale mode\n"
"-r XxY	set resolution of screen, typicaly 320x200,640x480,800x600,1024x768,...\n"
"	what your card knows.\n"
"-t RGB  with this option you can permute RGB colors of picture. For example\n"
"	-t grb ,swaps green and red channel. Option can be useful, in the\n"
"	case of bad detect of color weights.\n"
"-z r	sets zoom of picture, 1 means 90 grades\n"
"-a x/y  sets aspect of screen to x/y.\n"
"-h 	help\n"
"\n"
"Control:\n"
"mouse,arrows	looking around\n"
"escape,q	quit\n"
"z,x		zoom in/out\n";


int main(int argc, char **argv) {
  int i;
  while(EOF!=(i=getopt(argc,argv,"t:a:r:z:md:gh")))
   switch(i) {
    case 'g':grayscale=1;depth=8;break;
    case 'a':{
         int a1,a2;
         sscanf(optarg,"%d/%d",&a1,&a2);
         aspect=((real)a2)/a1;
      } break;
    case 'd':{
     sscanf(optarg,"%d",&depth);
     if(!(depth==8||depth==15||depth==16||depth==24||depth==32)) {
       printf("bad depth %d\n",depth);
       exit(1);
     }
     if(depth!=8)
       grayscale=0;
    } break;
    case 'm':mouse=0;break;
    case 'r':sscanf(optarg,"%dx%d",&width,&height);break;
    case 'z':sscanf(optarg,"%f",&zoom);break;
    case 't':{
        int i;
        if(strlen(optarg)!=3) break;
        for(i=0;i<3;i++) {
          optarg[i]&=~32;
          if(tolower(optarg[i])=='r') rgb[i]=0;
          if(tolower(optarg[i])=='g') rgb[i]=1;
          if(tolower(optarg[i])=='b') rgb[i]=2;
        };
      } break;
    case 'h':
    default:goto help;
   }
  if(aspect<=0) aspect=((real)height)/width;
  if(optind>=argc) {
   help:
    fputs(help_str,stdout);
    return 0;
  }
//  puts(argv[optind]);
//  return 0;
  allegro_init();

  set_color_depth(depth);
  if(set_gfx_mode(GFX_AUTODETECT,width,height,0,0)) {
    printf("graphics mode %dx%d %d bpp failed\n",width,height,depth);
    exit(1);
  }
  width=SCREEN_W,height=SCREEN_H;
  install_keyboard();
  install_mouse();

  background=create_bitmap(width,height);
  bgmem=(byte*)background->dat;

  i=init(argv[optind]);
  if(!i)
    loop();

  remove_mouse();
  remove_keyboard();
  set_gfx_mode(GFX_TEXT,0,0,0,0);
  allegro_exit();
  return 0;
}

