
struct graymap {
  graymap() { data=0;};
  int width,height;
  unsigned char *data;

  int alloc(int width,int height);
  void free();

  int export_pgm(FILE *f);
  int export_tga(FILE *f);

  int import_pgm(FILE *f);
  int import_tga(FILE *f);

  void dither(int max); // new value for 255 (1 for bitmaps )
};

struct pseudomap {
  int width, height;
  unsigned char *data;
  unsigned char *palette;

  pseudomap() { data=palette=0;};
  int alloc(int width,int height);
  void free();

  void set_rgb_palette(int rbase,int rlevels,int gbase,int glevels,int bbase,int blevels);
};

struct himap {
  int width, height;
  unsigned char *data;

  int alloc(int width,int height);
  void free();
};

struct rgbmap {
  rgbmap() { data=0;}
  int width,height;
  unsigned char *data;

  int alloc(int width,int height);
  void free();

  void swaprgb(int r,int g,int b);

  int export_ppm(FILE *f);
  int export_tga(FILE *f);

  int import_ppm(FILE *f);
  int import_tga(FILE *f);

  void channel_from(graymap *gm,int offset);
  void channel_to(graymap *gm,int offset);

  void convert_to(pseudomap *pm);   // convert to 8bit
  void convert_to(himap *hm);       // convert to 16bit
  void convert_from(pseudomap *pm);   // convert to 8bit
  void convert_from(himap *hm);       // convert to 16bit

  void rgbmap::dither(int pixel_size,unsigned char *pixels,int rbase,int rlevels,int gbase,int glevels,int bbase,int blevels);
  void rgbmap::grayscale(unsigned char *pixels);
};

