/* ------------------------------------------------------------------------ */
/* Savepic.c (C) CopyLeft Bill Buckels 1991-1999                            */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* PurPose      : Cuts a PCX or BASIC BSAVED image into                     */
/*                Printshop Sized Image Fragments                           */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

#include <graph.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <malloc.h>
#include <string.h>

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */
#define CRETURN    '\x0d'
#define LFEED      '\x0a'



/* type conversion functions */
unsigned int byteword(unsigned char a, unsigned char b){
  return b << 8 | a;
}
unsigned char lsb(unsigned int word){
  return word &0xff;
}
unsigned char msb(unsigned int word){
  return word >> 8;
}
unsigned char pcxheader[128];

int checkforpcx(char *name)
{
  FILE *fp;
  /* reads a ZSOFT .PCX header but ignores the color map */
  int i;
  /* we only want CGA compatible full screens.           */
  
  unsigned int zsoft,version,codetype,pixbits;
  unsigned int xmin, ymin, xmax, ymax;
  
  unsigned int no_planes, bytesperline;
  int invalid = - 1, valid = 0, status = valid;
  
  /* read the file header */
  if((fp = fopen(name, "rb")) == NULL)return - 1;
  for(i = 0;i != 128;i++)pcxheader[i] = fgetc(fp);
  fclose(fp);
  
  zsoft = pcxheader[0];
  version = pcxheader[1];
  codetype = pcxheader[2];
  pixbits = pcxheader[3];
  
  if(zsoft != 10)        status = invalid;
  if(codetype != 1)      status = invalid;
  if(pixbits != 2)
    if(pixbits != 1)  status = invalid;
  
  xmin = byteword(pcxheader[4], pcxheader[5]);
  ymin = byteword(pcxheader[6], pcxheader[7]);
  xmax = byteword(pcxheader[8], pcxheader[9]);
  ymax = byteword(pcxheader[10], pcxheader[11]);
  
  no_planes = pcxheader[65];
  bytesperline = byteword(pcxheader[66], pcxheader[67]);
  
  if(xmin != 0)      status = invalid;
  if(ymin != 0)      status = invalid;
  if(xmax != 319)
    if(xmax != 639)     status = invalid;
  if(ymax != 199)      status = invalid;
  
  if(no_planes != 1)     status = invalid;
  if(bytesperline != 80)status = invalid;
  /* we can ignore the color map since we        */
  /* are limiting ourselves to CGA modes         */
  /* so we will not handle over 2-bits per pixel */
  return status;
  
}


int pcxload(char *pcxfilename)
{
  unsigned char *crt = (unsigned char *) 0xB8000000l;
  unsigned int packet,width = 0;
  unsigned char *byteoff,*inleaf;
  
  FILE *fp;
  unsigned char byte,bytecount;
  long wordcount,target;
  
  fp = fopen(pcxfilename, "rb");
  
  target = filelength(fileno(fp));
  for(wordcount = 0;wordcount != 128;wordcount++)byte = fgetc(fp);
  
  byteoff = (unsigned char *)&crt[0];
  inleaf = (unsigned char *)&crt[8192];
  
  do
  {
    bytecount = 1;                     /* start with a seed count */
    byte = fgetc(fp);
    wordcount++;
    /* check to see if its raw */
    if(0xC0 == (0xC0 &byte))
    {
      /* if its not, run encoded */
      bytecount = 0x3f &byte;
      byte = fgetc(fp);
      wordcount++;
    }
    for(packet = 0;packet < bytecount;packet++)
    {
      if(width < 80)
      {
        *byteoff = byte;
        *byteoff++;
        width++;
      }
      else
      {
        *inleaf = byte;
        *inleaf++;
        width++;
        if(width > 159)width = 0;
      }
    }
    
  }while(wordcount < target);
  fclose(fp);
  return(0);
}



/* a microsoft compatible bsaved image format descriptor */
unsigned char BSAVED_header[7]={
    '\xfd','\x00','\xb8','\x00','\x00','\x00','\x40'};

int checkforbas(char *name)
{
  FILE *fp;
  unsigned char c;
  int i,status = 0,invalid = - 1;
  
  if((fp = fopen(name, "rb")) == NULL)return invalid;
  for(i = 0;i != 4;i++)
    if((c = fgetc(fp)) != BSAVED_header[i])status = invalid;
  fclose(fp);
  return status;
}

int bload(char *bsaved_file)
{
  unsigned char *crt = (unsigned char *) 0xB8000000l;
  int fh;
  unsigned char headbuf[7];
  
  fh = open(bsaved_file, O_RDONLY | O_BINARY);
  read(fh, headbuf, 7);
  read(fh, crt, 16385);
  close(fh);
  return 0;
  
}



#include <graph.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <malloc.h>
#include <string.h>

int drawcolor=3;
unsigned char far *screenbuffer,*showbuffer;


/* a microsoft compatible bsaved memory image format descriptor */
unsigned char PIC_header[7]={

    '\xfd',          /* ID Flag = file descriptor identifier bsaved file */

    /* BASIC will use original segment and offset information  */
    /* to reload a memory image unless "DEF SEG" has been used */
    /* and then an explicit offset is used as the second arg   */
    /* of the bload command.  If an offset is specified without*/
    /* first calling DEF SEG, The image will then be loaded to */
    /* the offset specified in the last segment pointed to     */
    /* by the last call to DEF SEG. DEF SEG without args returns */
    /* to DGROUP (the default data segment)                      */

    /* we would normally implement using an array in memory and */
    /* VARSEG and VARPTR to obtain the window for the array's   */
    /* memory location, i.e. override the defaults by windowing */
    /* to the array base using DEF SEG = VARSEG(arrayname(0)) then to    */
    /* fill the array we would use BLOAD arrayname, VARPTR(arrayname(0)) */
    /* using VARPTR to point to the offset from the memory base segment  */

    '\x00', '\xb8',  /* base address     = LSB | MSB original segment    */
    '\x00', '\x00',  /* offset from base = LSB | MSB original offset     */

    '\x00', '\x40'   /* file size = LSB | MSB of bytes to be loaded +    */
                     /* size of descriptors in bytes (8)                 */
    };
/* we have used the CGA frame buffer as the base       */
/* if someone fails to initialize the array and bloads */
/* the file without args it will ruin the display but  */
/* will not crash the program... no point making this too drastic */

unsigned char BSAVED_tailer[1]={
    '\x1A'                      /* traditionally used by BASIC */
    };                          /* as a terminator */



/* raw binary info in either a BASIC PUT or a C putimage file format */
/* assume MED res screen mode if we are not saving to PCC            */

int BSAVE(char *name, unsigned char far *buffer)
{
  int fh;
  int target = 1144;
  unsigned int blength = target + 4;
  
#define S_IWRITE    0000200          /* write permission, owner   */
    
    if((fh = open(name, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1)
    return - 1;
  
  write(fh, PIC_header, 5);
  write(fh, (unsigned char *)&blength, 2);
  
  write(fh, (unsigned char *)&buffer[0], blength);
  write(fh, BSAVED_tailer, 1);
  close(fh);
  return (0);
  
}



int savepic(char *filename)
{
  int x1 = 0,y1 = 0,x2 = 87,y2 = 51;
  int oldx1 = 0,  oldy1 = 0 ;
  int oldx2 = 87, oldy2 = 51;
  int imagebufsize = (52*22) + 4;
  unsigned char *wordptr;
  char namebuf[66],oldbuf[66];
  unsigned char c;
  
  char far *imagebuf;
  
  
  int ybot = 199,ytop = 51 ;
  int xright = 319,xleft = 87;
  
  imagebuf = _fmalloc(imagebufsize);
  
  _getimage(x1, y1, x2, y2, imagebuf);
  _putimage(x1, y1, imagebuf, _GPRESET);
  
  while((c = getch()) != ENTERKEY)
  {
    if(c == ESCKEY)
    {
      _ffree(imagebuf);
      return - 1;
    }
    
    if(c == FUNCKEY)
    {
      c = getch();
      switch(c)
      {
        case LTARROW : if(x2 > xleft)
        {
        x2--;
        x1--;
      }
        break;
        
        case RTARROW:  if(x2 < xright)
        {
        x2++;
        x1++;
      }
        break;
        
        case UPARROW   :if(y2 > ytop)
        {
        y1--;
        y2--;
      }
        break;
        
        case DOWNARROW :if(y2 < ybot)
        {
        y1++;
        y2++;
      }
        
      }
      
      /* if our position has changed then update */
      if(x2 != oldx2 || y2 != oldy2)
      {
        _putimage(oldx1, oldy1, imagebuf, _GPSET);
        oldx1 = x1;oldx2 = x2;oldy1 = y1;oldy2 = y2;
        _getimage(x1, y1, x2, y2, imagebuf);
        _putimage(x1, y1, imagebuf, _GPRESET);
        
        
      }
      
    }
    
    
  }
  
  
  _putimage(oldx1, oldy1, imagebuf, _GPSET);
  strcpy(oldbuf, filename);
  wordptr = strtok(filename, "*. ");
  sprintf(namebuf, "%s.PIC", filename);
  BSAVE(namebuf, imagebuf);
  return(0);
  
  
}

main(int argc, char *argv[])
{
  union REGS inregs, outregs;
  
  if(argc == 2)
  {
    if(checkforbas(argv[1]) == - 1)
    {
      if(checkforpcx(argv[1]) == - 1)
      {
        printf("%s is not a valid PCX or BSAVED FILE\n", argv[1]);
      }
      else
      {
        int86(0x11, &inregs, &outregs);/* get equipment list from the bios */
        /* get display type (bits 4 and 5 of ax) */
        
        if((outregs.x.ax & 0x30) == 0x30)
        {
          printf("Sorry... CGA or Compatible Video Adapter Required.\n");
          exit(0);
        }
        _setvideomode(_MRESNOCOLOR);
        pcxload(argv[1]);
        savepic(argv[1]);
        _setvideomode(3);
        
      }
    }
    else
    {
      int86(0x11, &inregs, &outregs);  /* get equipment list from the bios */
      /* get display type (bits 4 and 5 of ax) */
      
      if((outregs.x.ax & 0x30) == 0x30)
      {
        printf("Sorry... CGA or Compatible Video Adapter Required.\n");
        exit(0);
      }
      
      _setvideomode(_MRESNOCOLOR);
      bload(argv[1]);
      savepic(argv[1]);
      _setvideomode(3);
    }
    
  }
  else
  {
    printf("SAVEPIC(C) v2.0 CopyLeft 1991-1999 by Bill Buckels\n");
    printf("All Rights Reversed.\n");
    printf("USAGE 1:  \"SAVEPIC FILE.PCX\"\n");
    printf("USAGE 2:  \"SAVEPIC FILE.BAS\"\n");
    printf("Cuts an Image Fragment (PIC FILE) From a CGA Screen Image.\n");
    printf("output file size is 88 pixels x 52 rasters.\n");
  }
  exit(0);
}
