/* ----------------------------------------------------------------------- */
/*   GBAS.c (C) Version 2.0 Copyright Bill Buckels 1989-1999               */
/*   All Rights Reserved.                                                  */
/*                                                                         */
/*   GBAS is distributed as ShareWare.                                     */
/*   It is part of the STIX(C) Children's Sticker Draw Package.            */
/*   Suggested Registration for STIX(C) is $10.00 per family.              */
/*                                                                         */
/*   You are expected to register with the Author if you use STIX          */
/*   or any of its associated files and programs including GBAS            */
/*   beyond a 30-day evaluation period. Send registration in the form      */
/*   of cheque, or money order to:                                         */
/*                                                                         */
/*   Bill Buckels                                                          */
/*   589 Oxford Street                                                     */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                    */
/*                                                                         */
/*   Email: bbuckels@escape.ca                                             */
/*   WebSite: http://www.escape.ca/~bbuckels                               */
/*                                                                         */
/*   Registered users of STIX have a royalty-free right to use, modify,    */
/*   reproduce and distribute this source code (and/or any modified        */
/*   version) in any way you find useful, provided that you do not compete */
/*   with Bill Buckels or his agents, and that you agree that Bill         */
/*   Buckels has no warranty obligations or liability whatsoever           */
/*   resulting from any associated loss or damage.                         */
/*                                                                         */
/*   If you do not agree with these terms, remove this source and          */
/*   all associated files from your computer now.                          */
/*                                                                         */
/*   Description                                                           */
/*   -----------                                                           */
/*   A memory resident frame grabber program for the CGA and compatible.   */
/*                                                                         */
/*   This program saves the CGA frame buffer to a "slide file"             */
/*   in the GWBASIC BSAVED IMAGE FORMAT.                                   */
/*                                                                         */
/*   Graphics and 80 column text mode are both supported.                  */
/*                                                                         */
/*   If in text mode, image grabs will be in 4K buffer blocks              */
/*   rather than the graphics mode 16K buffer blocks. The headers          */
/*   of the BSAVED Files and File Extensions will also differ.             */
/*                                                                         */
/*   The Comments that follow are concerned with graphics mode only,       */
/*   but the practical principles apply to text mode use of the utility    */
/*   also. (At least they did in 1989 when this was written.)              */
/*                                                                         */
/*   If the apparent usefulness of such a utility momentarily escapes you, */
/*   consider that most paint programs support only proprietary formats    */
/*   that usually try to be all things to all people and are as efficient  */
/*   as heck, but hardly simple.                                           */
/*                                                                         */
/*   And what's even worse is that due to the various bitpacking schemes   */
/*   and other stuff that is pretty much beyond the scope of what I want   */
/*   to say here, the average programmer writing in GWBASIC is effectively */
/*   CUT-OFF from exporting his Paint Brush Creations into his BASIC       */
/*   programs, because the CODE that is required is usually beyond mortal  */
/*   understanding.                                                        */
/*                                                                         */
/*   This is very unfair to programmers who would probably enjoy           */
/*   dressing-up their programs with original graphics.                    */
/*                                                                         */
/*   Since most Paint Programs have their own frame grabber programs,      */
/*   (FRIEZE.COM is PCPAINT's and CATCH.COM is PSPLUS's, etc.), it is      */
/*   easy to capture and create a disk file of almost any screen from a    */
/*   GRAPHICS program. But as I said, it is not so easy to put these       */
/*   screens to any useful purpose once embellished in the respective      */
/*   paint program because as previously indicated, the image files are    */
/*   quite formal and abit tricky to deal with.                            */
/*                                                                         */
/*   The BASIC BSAVED image format is easy to display in a GWBASIC program */
/*   program (Using the BLOAD command and the example in the manual.)      */
/*                                                                         */
/*   I felt compelled to create this utility do my "little bit" in         */
/*   providing a simple and common source of aquiring EDITTED GRAPHICS for */
/*   the Casual Programmer,                                                */
/*                                                                         */
/*   At the risk of "byteing-off" more than I can chew, I sincerely hope   */
/*   that this utility works with your computer. In 1989, tested it on an  */
/*   AMDEK 286 10mghz AT running MSDOS 4.01 with a true CGA card and       */
/*   additionally with a SAMSUNG s550 equipped with an ATI Wonder, to name */
/*   a couple, and successfully Grabbed screens in ZSOFT's PCPAINT version */
/*   3 and Logitech's PSPLUS. I have also successfully used it on an AMD   */
/*   K6/300 running Windows 98 a decade later, so it seems to have         */
/*   survived the test of time.                                            */
/*                                                                         */
/*   One tip that I should pass on. DO NOT LOAD THE FRIEZE OR THE CATCH    */
/*   PROGRAM over top of this one. (NOR SHOULD YOU LOAD ANY PROGRAM THAT   */
/*   INTERCEPTS THE PRINT SCREEN KEY WHILE RUNNING THIS PROGRAM.)          */
/*                                                                         */
/*   This Program uses The Print Screen Key as a "CAMERA SHUTTER" and the  */
/*   ".BAS"  or .BSV extension for it's creations and prints to a file     */
/*   starting with the name "IMAGE000.BAS" or "IMAGE000.BSV" and a 1000    */
/*   image limit.                                                          */
/*                                                                         */
/*   POSTFIX:                                                              */
/*                                                                         */
/*   Some other programs that also generate the BSAVED GRAPHICS            */
/*   IMAGE are TheGrin, PCPG, and of course GWBASIC. TheDraw is the        */
/*   best all-round standard Text Screen Editor for BSAVED TEXT SCREENS.   */
/*                                                                         */
/*   Amazingly, even in 1999, these utilities are still available...       */
/*   on the Internet. Some download sites are listed below.                */
/*                                                                         */
/*   PCPG is still available (March 1999) through the Oak repository:      */
/*   http://oak.oakland.edu/pub/pc-blue/pcblue/ as vol044.zip.             */
/*                                                                         */
/*   TheGrin and TheDraw are still available (March 1999) at The Cereal    */
/*   Port BBS in New Hampshire:                                            */
/*   http://cereal.mv.com/cereal/graphic/filesbbs.html                     */
/*                                                                         */
/*   Alternately PCPG and TheDraw are both available at Share Fare:        */
/*   http://www.share-fayre.co.uk/                                         */
/*                                                                         */
/*   There also used to be other antiquated CAMERA programs that worked on */
/*   the XT and grabbed into a format which allow conversion to GRAPHICS   */
/*   BSAVED IMAGES such as IBM's OLD PCSTORYBOARD or Fernando Pertuz's     */
/*   PRESENT, but I never had any luck with them on the AT.                */
/*                                                                         */
/*   The STUMBLING BLOCK to plans to create a toolbox to convert between   */
/*   some of the MORE COMMON Graphics Formats and the BSAVED IMAGE was the */
/*   RELATIVELY LARGE NUMBER of COMMON formats and VIDEO configurations as */
/*   opposed to the finite number of years in my own short life.           */
/*                                                                         */
/*   However, due To an extremely conscise explanation from ZSOFT          */
/*   regarding the .PCX file format, I long ago wrote a utility called     */
/*   BASTOPCX which allows direct conversion between the BASIC BSAVED CGA  */
/*   GRAPHICS MODE IMAGE FORMAT and EQUIVALENT PCX FORMATS.                */
/*                                                                         */
/*   GBAS is written in Medium Model Mix Power C Version 2.0.2 and         */
/*   Linked explicitly with a 2K stack and 2K heap.                        */
/* ----------------------------------------------------------------------- */

#include <bios.h>
#include <stdio.h>
#include <dos.h>

/* auto-filename counters for text and graphics */
static int txtone_count   = 0,
           txttwo_count   = 0,
           txtthree_count = 0,
           gfxone_count   = 0,
           gfxtwo_count   = 0,
           gfxthree_count = 0;

/* microsoft compatible bsaved image format descriptors */
char MEDRES_header[7]={
    '\xfd','\x00','\xb8','\x00','\x00','\x00','\x40'};

char TEXT_header[7]={
    '\xfd','\x00','\xb8','\x00','\x00','\xA0','\x0F'};

/* the current video mode - point to the bios segment */
char far *vmodeptr = (char far *)(unsigned long)0x0400049;

void interrupt GRABBER(void)
{
    /* avoids higher level string handling etc. */
    /* in an effort to keep the overhead down   */

    FILE *fp;
    static char far *crtptr;
    int i,
        one_count,
        two_count,
        three_count,
        filesize;

    char *filename,
         *header,
         temp;

    disable();
    temp=vmodeptr[0];

    /* make sure we are in a legal video mode */
    if (temp == 2 || temp ==3 || temp==4 || temp == 5 || temp == 6) {
      /* assign screen mode specific variants */
      if ( temp == 6 || temp == 5 || temp == 4) {
        filename = (char *)"IMAGE000.BAS";
        filesize = 16384;
        header = (char *)&MEDRES_header[0];
        one_count = gfxone_count;
        two_count = gfxtwo_count;
        three_count = gfxthree_count;
      }
      else  {
        filename = (char *)"IMAGE000.BSV";
        filesize = 4000;
        header = (char *)&TEXT_header[0];
        one_count = txtone_count;
        two_count = txttwo_count;
        three_count = txtthree_count;
      }
      /* increment file name */
      if (one_count > 9) {
        one_count=0;
        two_count++;
        if (two_count > 9) {
          two_count=0;
          three_count++;
          if (three_count > 9) {
            three_count = 0;
          }
        }
      }
      /* create file name */
      filename[7]=one_count+48;
      filename[6]=two_count+48;
      filename[5]=three_count+48;
      /* dump video memory to file */
      fp=fopen(filename,"wb");
      if (NULL != fp) {
        for (i=0; i<7; i++)fputc(header[i],fp);
        crtptr = MK_FP(0xB800,0);
        for (i=0; i<filesize; i++)fputc(crtptr[i],fp);
        fputc('\x1a',fp);
        fclose(fp);
        /* if we have successfully opened the file */
        /* we need to increment the file counter   */
        one_count++;
        if ( temp == 6 || temp == 5 || temp == 4) {
          gfxone_count   = one_count;
          gfxtwo_count   = two_count;
          gfxthree_count = three_count;
        }
        else {
          txtone_count   = one_count;
          txttwo_count   = two_count;
          txtthree_count = three_count;
        }
      }
    }
    enable();
}

void main(char argc,int *argv[])
{
    unsigned programsize;
    int c;

    printf("GBAS(C) Version 2.0 Copyright Bill Buckels 1989-1999\n");
    printf("All Rights Reserved.\n");
    printf("BSAVED screen GRABBER utility.\n");
    printf("Captures graphics screens and 80 column text screens.\n");
    printf("-----------------------------------------------------\n");
    printf("Do you wish to Load the \"CAMERA\"? (Y/N) ");
    c = getch();
    if (c == 'y' || c == 'Y') {
      printf("Y\n");
      setvect(5,GRABBER);
      programsize=farsetsize(0);
      printf("THE \"CAMERA\" IS LOADED and ready to take pictures.\n");
      printf("USE THE PRINT SCREEN KEY as the \"CAMERA SHUTTER\"\n");
      printf("IMAGES will be stored in BSAVED image format in\n");
      printf("the current directory starting with \"IMAGE000\"\n");
      keep(0, programsize);
    }
    else {
      printf("N\n");
      exit(1);
    }
}
