;*
;* This is a simple test of the SVGA graphics routines
;* by Piotr Ulaszewski
;*

%define st st0

%include "include\globals.inc"
%include "include\segments.inc"
%include "include\message.mac"
%include "include\scans.inc"

segment _DATA
;******************************************************************************
color dd 9                                ; values for the flat shaded triangle
x1 dd 0                                   ; in scene 2
y1 dd 0
x2 dd 590
y2 dd 200
x3 dd 10
y3 dd 470
tekst1  db 'Hi-res SVGA graphics',0
	db 'uses',0
	db 0
	db 'VESA 2.0',0
	db 0
	db 'written in assembler',0
	db 0
	db 'by',0
	db 'Piotr Ulaszewski',0
	db 0
	db 0
	db 0
	db 'special thanks',0
	db 'to',0
	db 0
	db 'Michael Tippach',0
	db 'for the',0
	db 'DOS Extender',0
	db 0
	db 0
	db 0
	db 'Babyloon Revelations',0
	db 'for the',0
	db 'basic vesa functions',0
	db 'released in 1997',0
	db 0
	db 'that was a',0
	db 'good',0
	db 'piece of code',0
	db 0
	db 0
	db 0
	db 'In the demo',0
	db 'I use the modified',0
	db 'version of their',0
	db 'two main procedures',0
	db 0
	db 0
	db 0
	db 'This code',0
	db 'is too primitive',0
	db 'to call it a demo',0
	db 0
	db 0
	db 'it is just',0
	db 'a coding example',0
	db 'with all the',0
	db 'sources',0
	db 0
	db 0
	db 0
	db 'This release',0
	db 'is',0
	db 'for',0
	db '32 bit protected mode',0
	db 0
	db 0
	db 0
	db 'I started to write the code',0
	db 'in',0
	db 'March 1998',0
	db 0
	db 'but',0
	db 'I was too lazy',0
	db 'to keep it going',0
	db 0
	db 0
	db 'so this is only',0
	db 'one part of',0
	db 'the project',0
	db 0
	db 0
	db 0
	db 'No 3D animation yet',0
	db 'may be next time?',0
	db 0
	db 0
	db 0
	db 'But it is',0
	db 'a DOS program',0
	db 'and DOS belongs',0
	db 'to',0
	db 'the past!!!',0
	db 0
	db 0
	db 0
	db 'SVGA graphics',0
	db 'in',0
	db 'DOS',0
	db 0
	db 0
	db 'with high framerates',0
	db 0
	db 'even on 486 PCI'
	db 0
	db 'requires',0
	db 'double',0
	db 'or even',0
	db 'triple',0
	db 'buffering',0
	db 0
	db 0
	db 0
	db 'You can do this',0
	db 'by accesing',0
	db 'the linear framebuffer',0
	db 'directly',0
	db 0
	db 0
	db 0
	db 'I ony used',0
	db 'double buffering',0
	db 'with',0
	db 'page fliping',0
	db 'and',0
	db 'vertical refresh sync',0
	db 0
	db 0
	db 0
	db 'that means',0
	db 'a back buffer',0
	db 'in video memory',0
	db 'that you can write to',0
	db 'and simply flip pages',0
	db 'to show it',0
	db 0
	db 0
	db 0
	db 0
	db 'my address:',0
	db 'Piotr Ulaszewski',0
	db 'Suchy Dwor 18a',0
	db 'Wroclaw - POLAND',0ffh,0    ; always at the end [,0ffh,0]

text_colorize dd 0                      ; values for scrolled text
text_color dd 13                        ; in scene 2
text_y0 dd 0
text_scroll_length dd 0                 ; do not fill (internal)

fps_string db 'Actual fps : ',0         ; values of fps string
fps_colorize dd 0
fps_color dd 13
fps_color_hicolor dd 0ffffh             ; only for hicolor modes (white)
fps_x0 dd 0
fps_y0 dd 0
fps_counter dd 0
actual_fps dd 0
seconds db 0

res_string db 'SVGA mode : ',0
res_colorize dd 0
res_color dd 13
res_x0 dd 0
res_y0 dd 16

color_count dd 0

XCenter dd 0
YCenter dd 0

line_x1 dd 0                                  ; values for moving line
line_y1 dd 0                                  ; in scene 3
line_x2 dd 0
line_y2 dd 0
line_dinc_x dd 1
line_dinc_y dd 1

; *****************************************************************************

	FileName        db 'TEST.PCX',0
	PictureAddress  dd 0                    ; uncompressed PCX address
	PictureHandle   dd 0                    ; uncompressed PCX memory handle
	FileHandle dw 0


;
;
segment _TEXT
;
;
..start:                                ; MAIN STARTING POINT
	jmp short _start
	db 'WATCOM'                     ; if you want to use DOS4GW
_start:
	sti                             ; Enable Interrupts
	cld                             ; Clear The Direction Flag
	push ds
	pop es
	push dword tekst1
	call _CheckScrollTextLength      ; get the size of the scrolled text
	add esp,byte 4
	mov [text_scroll_length],eax
	call _GetROMFont                 ; get system font

	mov ax,0501h                    ; Alloc mem for pic
	mov ebx,(640*480)+769           ;[PCXSize] 640*480+769
	mov cx,bx
	shr ebx,16
	int 31h
	errormsg 'Not enough memory to load PCX image ???'
	shl ebx,16
	mov bx,cx
	mov [PictureAddress],ebx
	shl esi,16
	mov si,di
	mov [PictureHandle],esi

	call _CheckVESA                  ; check if VESA present
	or eax,eax
	jz @@InitOk
	mov edx,[_VBE_Msg_Table+eax*4]   ; exit if no vesa
	mov ah,9
	int 21h
	mov ax,4cffh
	int 21h

@@InitOk:
	push dword 8
	push dword 480
	push dword 640
	call _InitVESAMode               ; init 640x480x8 VESA mode
	add esp,byte 12
	or eax,eax
	jz @@InitOk2
	mov edx,[_VBE_Msg_Table+eax*4]	; exit if initialisation failed
	mov ah,9
	int 21h
	mov ax,4cffh
	int 21h

@@InitOk2:
	push dword [PictureAddress]	; destination address
	push dword FileName		; name of PCX file
	call _PcxUnpack
	add esp,byte 8
	or eax,eax
	jnz pcx_ok
	stc
	errormsg 'There was an error while loading the PCX image.'

pcx_ok:
	call _key_init                   ; initialize the new key handler
	call _SetVBEMode                 ; set 640x480x256 mode
	push dword [PictureAddress]	; address of uncompressed PCX
	call _ActivePcxPal               ; activate the PCX 8bit palette
	add esp,byte 4
	push dword [PictureAddress]
	call _PutVESAScreen              ; show the PCX on the screen
	add esp,byte 4

	mov eax,[_key_table]
@@Loop1a:
	cmp byte [eax + scan_Space],1            ; wait for space key
	jne @@Loop1a
@@Loop1b:
	cmp byte [eax + scan_Space],0
	jne @@Loop1b

	Call _CloseVBEMode
	push dword 8
	push dword 600
	push dword 800
	call _InitVESAMode               ; initialize 800x600x256 mode
	add esp,byte 12
	or eax,eax
	jz @@InitOk3
	jmp _exit_program                ; if error exit
@@InitOk3:
	call _SetVBEMode                 ; set 800x600x256 mode

;--------------------------------SECOND-SCENE----------------------------------

	mov eax,[_VBE_YResolution]
	add eax,byte 10
	mov [text_y0],eax               ; set the text scroll resolution start
	mov eax,[_VBE_XResolution]
	shr eax,1
	mov [XCenter],eax
	mov eax,[_VBE_YResolution]
	shr eax,1
	mov [YCenter],eax

@@esc:
	mov ah,02h
	int 1ah                         ; calculate frames per second
	cmp dh,[seconds]
	jz @@dont_change_fps
	mov ebx,[fps_counter]
	mov [actual_fps],ebx
	mov dword [fps_counter],0
	mov [seconds],dh                ; new value
@@dont_change_fps:
	inc dword [fps_counter]

	push dword [color]
	push dword [y3]                 ; y3 = 
	push dword [x3]                 ; x3 = 
	push dword [y2]                 ; y2 = 
	push dword [x2]                 ; x2 = 
	push dword [y1]                 ; y1 = 
	push dword [x1]                 ; x1 = 
	call _FTriangle                  ; draw triangle on the virtual screen
	add esp,byte 28

	push dword 15			; color
	push dword [y3]			; r
	push dword [YCenter]
	push dword [XCenter]
	call _Circle
	add esp,byte 16

	push dword fps_string
	push dword [fps_colorize]
	push dword [fps_color]
	push dword [fps_y0]
	push dword [fps_x0]
	call _PutText                    ; draw text on the virtual screen
	add esp,byte 20

	push eax			; position after PutText function
	push dword 03fh			; color
	push dword [actual_fps]		; number
	call _WriteWordSVGA              ; draw word on the virtual screen
	add esp,byte 12

	push dword tekst1
	push dword [text_colorize]
	push dword [text_color]
	push dword [text_y0]
	call _ScrollText                 ; draw scrolled text on the virtual sc
	add esp,byte 16

	push dword res_string
	push dword [res_colorize]
	push dword [fps_color]
	push dword [res_y0]
	push dword [res_x0]
	call _PutText
	add esp,byte 20

	push eax			; position after PutText function
	push dword 03fh			; color
	push dword [_VBE_XResolution]	; number
	call _WriteWordSVGA
	add esp,byte 12

	push eax			; position
	push dword 03fh			; color
	push dword 'x'			; char
	call _WriteCharSVGA
	add esp,byte 12

	push eax			; position
	push dword 03fh			; color of that word
	push dword [_VBE_YResolution]	; number
	call _WriteWordSVGA
	add esp,byte 12

	call _Flip                       ; flip the visible page and the buffer

	mov eax,[_key_table]
	cmp byte [eax + scan_Plus],1
	jne .do_not_increase
	call _IncreaseResolution
.do_not_increase:
	cmp byte [eax + scan_Minus],1
	jne .do_not_decrease
	call _DecreaseResolution
.do_not_decrease:

	mov eax,[_VBE_XResolution]       ; EAX = XResolution-1
	dec eax
	mov ebx,[_VBE_YResolution]       ; EBX = YResolution-1
	dec ebx
	dec dword [x2]
	jnz @@x2_ook
	mov dword [x2],eax
@@x2_ook:                               ; x2 triangle coordinate checked
	inc dword [x3]
	cmp dword [x3],eax
	jl @@x3_ook
	mov dword [x3],0
@@x3_ook:                               ; x3 triangle coordinate checked
	add dword [x1],byte 2
	cmp dword [x1],eax
	jl @@x1_ook
	mov dword [x1],0
@@x1_ook:                               ; x1 triangle coordinate checked
	inc dword [y1]
	cmp dword [y1],ebx
	jl @@y1_ook
	mov dword [y1],0
@@y1_ook:                               ; y1 triangle coordinate checked
	dec dword [y3]
	jnz @@y2_ook
	mov dword [y3],ebx
@@y2_ook:                               ; y2 triangle coordinate checked
	mov edx,[text_scroll_length]
	neg edx
	sub dword [text_y0],1
	cmp dword [text_y0],edx
	jg @@text_y0_ok
	add ebx,byte 10
	mov dword [text_y0],ebx
@@text_y0_ok:                           ; y0 scrolled text coordinate checked

	mov eax,[_key_table]
	cmp byte [eax + scan_Space],1            ; check for space key
	jne near @@esc

;----------------------------------THIRD-SCENE---------------------------------

	Call _CloseVBEMode
	; free memory allocated for PCX image
	mov eax,502h
	mov esi,[PictureHandle]
	mov di,si
	shr esi,16
	int 31h

	push dword 15
	push dword 400
	push dword 640
	call _InitVESAMode               ; Initialize 640x400x15 VESA mode
	add esp,byte 12
	or eax,eax
	jz @@InitOkTmp
	push dword 15
	push dword 200
	push dword 320
	call _InitVESAMode               ; Initialize 320x200x15 VESA mode
	add esp,byte 12
	or eax,eax
	jz @@InitOkTmp
	jmp _exit_program                ; if error exit program
@@InitOkTmp:
	call _SetVBEMode                 ; set the highcolor graphics mode

	mov eax,[_VBE_XResolution]
	shr eax,1
	mov dword [line_x1],eax
	mov eax,[_VBE_YResolution]
	shr eax,1
	mov dword [line_y1],eax

hicolor_loop:
	mov ah,2
	int 1ah                         ; calculate the frame rate
	cmp dh,[seconds]
	jz @@dont_change_fps_tmp
	mov ebx,[fps_counter]
	mov [actual_fps],ebx
	mov dword [fps_counter],0
	mov [seconds],dh		; new value of fps
@@dont_change_fps_tmp:
	inc dword [fps_counter]

	mov eax,[color_count]
	mov esi,[_VBE_VirtualScreenAddress]      ; start of virtual screen
hicolor_fill:   
	mov [esi],ax
	add esi,byte 2
	cmp esi,[_VBE_FirstByteBeyondVirtualScreen]      ; end of virtual screen
	ja exit_hicolor_fill
	inc eax
	cmp eax,byte 32                                 ; 1 blu - 32 shades
	jb hicolor_fill 

	mov eax,[color_count]
hicolor_fill_2: 
	shl eax,5
	mov [esi],ax
	shr eax,5
	add esi,byte 2
	cmp esi,[_VBE_FirstByteBeyondVirtualScreen]
	ja exit_hicolor_fill
	inc eax
	cmp eax,64                              ; 2 times green - 32/64 shades
	jb hicolor_fill_2

	mov eax,[color_count]
hicolor_fill_3: 
	shl eax,10
	mov [esi],ax
	shr eax,10
	add esi,byte 2
	cmp esi,[_VBE_FirstByteBeyondVirtualScreen]
	ja exit_hicolor_fill
	inc eax
	cmp eax,byte 32                         ; 1 red - 32 shades
	jb hicolor_fill_3
	mov eax,[color_count]
	jmp short hicolor_fill


exit_hicolor_fill:
	mov eax,[line_dinc_x]
	add dword [line_x2],eax
	mov eax,[line_dinc_y]
	add dword [line_y2],eax

	mov eax,[_VBE_YResolution]
	dec eax
	cmp dword [line_y2],eax
	jl line_y1_ok
	neg dword [line_dinc_y]
line_y1_ok:
	cmp dword [line_y2],0
	jg line_y2_ok
	neg dword [line_dinc_y]
line_y2_ok:
	mov eax,[_VBE_XResolution]
	dec eax
	cmp dword [line_x2],eax
	jl line_x1_ok
	neg dword [line_dinc_x]
line_x1_ok:
	cmp dword [line_x2],0
	jg line_x2_ok
	neg dword [line_dinc_x]
line_x2_ok:

	push dword -1
	push dword [line_y2]
	push dword [line_x2]
	push dword [line_y1]
	push dword [line_x1]
	call _Line
	add esp,byte 20

	push dword fps_string
	push dword [fps_colorize]               
	push dword [fps_color_hicolor]          ; hicolor format of color
	push dword [fps_y0]
	push dword [fps_x0]
	call _PutText
	add esp,byte 20

	push eax				; position after PutTextHicolor
	push dword -1               ; color of that word (hicolor format - white)
	push dword [actual_fps]			; number
	call _WriteWordSVGA
	add esp,byte 12

	push dword res_string
	push dword [res_colorize]
	push dword [fps_color_hicolor]
	push dword [res_y0]
	push dword [res_x0]
	call _PutText
	add esp,byte 20

	push eax				; position after PutTextHicolor
	push dword 0ffffh                       ; color of that word (hicolor)
	push dword [_VBE_XResolution]		; number
	call _WriteWordSVGA
	add esp,byte 12

	push eax				; position
	push dword 0ffffh			; color of that word (hicolor)
	push dword 'x'				; char
	call _WriteCharSVGA
	add esp,byte 12

	push eax				; position
	push dword 0ffffh                       ; color of that word (hicolor)
	push dword [_VBE_YResolution]		; number
	call _WriteWordSVGA
	add esp,byte 12

	call _Flip                               ; flip the video pages

	mov eax,[_key_table]
	cmp byte [eax + scan_Space],1       ; space key
	jne near hicolor_loop

;------------------------------------------------------------------------------

@@exit:                                         ; standard exit procedure
	call _key_deinit
	Call _CloseVBEMode
	mov ax,03
	int 10h

	mov ax,4c00h                  ; AH=4Ch - Exit To DOS
	int 21h                       ; DOS INT 21h

