/*

 1998-2000 Piotr Ulaszewski
 Flip2.h header file for vesa double buffering library

*/

typedef unsigned char byte;
typedef unsigned long dword;
typedef unsigned short word;

#define TRUE 1
#define FALSE 0

#ifdef __cplusplus
extern "C" {
#endif

/* globals for the VESA interface (VESA.ASM) */
extern word VBE_TotalMemory;                           /* word - size of video RAM in KB */
extern word VBE_VBEVersion;                            /* word - BCD version of VESA interface */
extern dword VBE_NumberOfMode;                         /* dword - total number of graphics modes */
extern word VBE_Gfx_Mode;                              /* word - physical number of mode found */
extern void *VBE_VRAM_Address;                         /* dword - pointer to Video RAM */
extern dword VBE_BytesPerScanLine;                     /* dword - width in bytes of VESA mode */
extern byte VBE_LFBAvailable;                          /* byte - if = 1 then LFB is available */
extern byte VBE_PMODEInterface;                        /* byte - if = 1 then PMODE is available */
extern byte VBE_PMODEBankSwitch;                       /* byte - if = 1 then PM Bank switch ok */
extern char *VBE_Msg_Table[];                          /* dword - pointer to array of VESA errors */
extern byte VBE_NumberOfMemoryPages;                   /* byte - for the current mode */
extern void *VBE_VirtualScreenAddress;                 /* dword - pointer to Virtual Screen */
extern void *VBE_FirstByteBeyondVirtualScreen;         /* dword - pointer to end of Virtual Screen */
extern dword VBE_CurrentPageMappingSize;               /* dword - size in bytes of the current page */
extern dword VBE_TotalMappingSize;                     /* dword - size of video RAM in bytes */
extern dword VBE_XResolution;                          /* dword - X resolution of the current mode */
extern dword VBE_YResolution;                          /* dword - Y resolution of the current mode */
extern dword VBE_BitsPerPixel;                         /* dword - Bits per Pixel of the current mode */
extern dword VBE_CalcBitsPerPixel;                     /* dword - if 15 then 16 */
extern dword VBE_CalcBitsPerPixel2;                    /* dword - bpp shr 3 */
extern void *ROM_Font;                                 /* dword - pointer to system font */
extern void *VideoMemory_StartAddress;                 /* dword - pointer to start of Linear Framebuffer */
extern int cdecl CheckVESA (void);
extern int cdecl InitVESAMode (word xres, word yres, word bpp);
extern void cdecl SetVBEMode (void);
extern void cdecl CloseVBEMode (void);
extern void cdecl PutVESAScreen (void *source);
extern void cdecl WaitRetrace (void);
extern void cdecl Flip (void);
extern int cdecl IncreaseResolution (void);
extern int cdecl DecreaseResolution (void);
extern void cdecl GetROMFont (void);


/* globals for the file formats (FFORMATS.ASM) */
extern int cdecl PcxUnpack (char *filename, void *destination);
extern void cdecl ActivePcxPal (void *image);


/* globals for the drawing functions (DRAW.ASM) */
extern void cdecl XLine (int x1,int x2,int y,dword c);
extern void cdecl FTriangle (int x1,int y1,int x2,int y2,int x3,int y3,dword c);
extern void * cdecl PutText (int x0,int y0,dword c,byte colorize,char *text);
extern void cdecl ScrollText (int y0,dword c,byte colorize,char *text);
extern void cdecl Line (int x1,int y1,int x2,int y2,dword c);
extern void cdecl Circle (int x0,int y0,int r,dword c);
extern void cdecl PutPIxel (int x0,int y0,dword c);
extern dword cdecl GetPixel (int x0,int y0);
extern int cdecl CheckScrollTextLength (char *text);
extern void * cdecl WriteWordSVGA (word number, byte color, void *position);
extern void * cdecl WriteCharSVGA (char sign, byte color, void *position);
extern dword cdecl CreateColor (byte r, byte g, byte b);


/* globals for the interrupt functions (INT.ASM) */
extern void cdecl exit_program (void);
extern void cdecl key_init (void);
extern void cdecl key_deinit (void);
extern byte * cdecl key_table;


#ifdef __cplusplus
}
#endif

