//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <signal.h>
#include <string.h>
#include <memory.h>

#include "cthugha.h"
#include "initscrn.h"
#include "patch.h"
#include "options.h"

#include "banner.h"
#include "cthu_hlp.h"
#include "cdmix.h"
#include "credits.h"
#include "stats.h"
#include "startup.h"

#include "audio.h"

#include "uncrunch.h"

#include "cmdfiles.h"

unsigned char far *screenaddr=(char far *) 0xB8000000;


char *people[]={
//|-----------------------------------:------------------------------------
 " ",
 "              People who have sent CD's !",
 "              ---------------------------",
 " ",
 "Don Weir  - Sydney, Australia",
 "              (Pete Namlook: The Definative Ambient Collection)",
 "              (Gothic Voices: Music for the lion-hearted king)",
 "              (Sandra: Greatest Hits",
 " ",
 "Tom Ellard  (Severed Heads) - Sydney, Australia",
 "              (Severed Heads: Dead eyes opened)",
 "              (Tom used Cthugha in the video clip for Dead Eyes Opened)",
 " ",
 "Yasuki Ohsono - Japan",
 "              (Pizzicato Five: Overdose)",
 " ",
 "Oliver & Babsi Mueller, Gerd Joachim Klostermann - Germany",
 "              (Kraftwerk: Die Mensch Maschine)",
 " ",
 "Thomas O. Moll - Germany",
 "              (Divine: Maid in England)",
 " ",
 "DeadZone - USA",
 "              (2 copies of their E.P., a bumper sticker,a photo)",
 "              (DeadZone: An Audio Interpretation of Human Existance)",
 " ",
 "Alex Habbe - Austria",
 "              (Freaky Fukin Weirdoz: Mao Mak Maa)",
 " ",
 "Matt Black - UK",
 "              (Tone Tales From Tomorrow)",
 " ",
 "Dan Foley - USA",
 "              (Pete Namlook: Shades of Orion)",
 " ",
 "Geert-Jan Engelen - Netherlands",
 "              (Wax: Magnetic Heaven",
 " ",
 "David Smith - Michigan, USA",
 "              (King Crimson: VROOOM)",
 " ",
 "Steve Kirby (I-Sense) - Berks, UK",
 "              (I-Sense: cacti and succulents)",
 " ",
 "Jim Hill - Seattle, USA",
 "              (The Neon Interactive CD-ROM advertising CD)",
 "              (see, I said I wasnt fussy about what you send!)",
 " ",
 "Lawrence Wright - USA",
 "              (Ozzy Ozborne: Blizzard of Ozz)",
 " ",
 "Daniel Wigtil - USA",
 "              (American Gramaphone Records: Sampler III)",
 " ",
 " ",
 " ",
 "              This guys sent their video tapes !",
 "              ----------------------------------",
 " ",
 "USA        :  Don Slepian - Video Dreamland",
 "Australia  :  Tom Ellard (Severed Heads: Dead eyes opened)",
 " ",
 " ",
 " ",
 NULL};


long memavail(void)
{
      union REGS regs;

      /* Request impossibly large number of 16-byte paragraphs from DOS */

      regs.h.ah = 0x48;
      regs.x.bx = 0xFFFF;

      _int86(0x21,&regs,&regs);

      return((long)regs.x.bx * 16L);
}

void put_string(int x,int y,char *string)
{
	int i;

	gotoxy(x,y);
//	printf(string);

	for (i=x; i<strlen(string)+x; i++)
		put_char(i,y,string[i-x]);
}

#if 0
void scroll_up(int x1, int y1, int x2,int y2,int lines,unsigned char color)
{
	union REGS r;

	r.h.ah=0x06;
	r.h.al=lines;
	r.h.bh=color;
	r.h.cl=x1;
	r.h.dl=x2;
	r.h.ch=y1;
	r.h.dh=y2;

	_int86(0x10,&r,&r);
}
#endif

void gotoxy(int x1, int y1)
{
	union REGS r;

	r.x.ax=0x0200;
	r.h.bh=0x00;
	r.h.dl=x1;
	r.h.dh=y1;
	_int86(0x10,&r,&r);
}

void quit_screen(void)
{
	int x;
	uncrunch(BANNER,screenaddr,sizeof(BANNER));

	for( x=0; x < 80; x++ )
		color_char(x,24,' ',7);   // Clean final line...

	gotoxy(0,23);
}

char myname[16]={'\0'};

void show_credits(void)
{
	int y,i,firsttime=1;
	int numcreds;
	char temp[90];

	i=0;
	while (people[i]!=NULL)
		i++;
	numcreds=i;

	uncrunch(CREDITS,screenaddr,sizeof(CREDITS));

	i=0;

	if (myname[0]!='\0') {
//		printf("Searching...'%s'\n",myname);
		for (i=0; i<numcreds; i++) {
//			printf("%s\n",people[i]);
			memcpy(temp,people[i],89);
			if (strstr(_strlwr(temp),myname)!=NULL) {
				break;
			}
		}
	}

	do {
		for (y=0; y<7; y++) {
//			gotoxy(3,y+17);
//			sprintf(temp,"%-78s",people[(i+y)%numcreds]);
			memset(temp,' ',76);
			memcpy(temp,people[(i+y)%numcreds],89);
			memset(&(temp[strlen(people[(i+y)%numcreds])]),' ',77-strlen(people[(i+y)%numcreds]));
			temp[76]=0;
			put_string(3,y+16,temp);
		}
		gotoxy(0,24);

		if (firsttime) {
			firsttime=0;
			delay(500);
			if (myname!=NULL)
				delay(500);
		}

		delay(400);

		i++;
	} while (!_kbhit());

	gotoxy(0,24);
}


void cdmix_screen(int ok)
{

	uncrunch(CDMIX,screenaddr,sizeof(CDMIX));
	gotoxy(0,23);
}

void start_screen(void)
{
	uncrunch(STARTUP,screenaddr,sizeof(STARTUP));
	gotoxy(0,23);
}

extern int numwaves;
extern function_opt wavearray[];

void help_screen(void)
{
	int x,y,i;

	uncrunch(HELPDATA,screenaddr,sizeof(HELPDATA));

	for (i=0; i<numwaves; i++) {
		if (i>=13) {
			y=7+i-13;
			x=69;
		} else {
			y=7+i;
			x=50;
		}
		gotoxy(x,y);
		printf("%-10s",wavearray[i].name);
	}
	gotoxy(0,23);

}

extern clock_t start,end;
extern int frames;

void stats_screen(void)
{
	uncrunch(STATS,screenaddr,sizeof(STATS));

	gotoxy(20,3);
	printf("%ld bytes",memavail());

	gotoxy(20,4);
	switch (sound_card) {
		case SBPRO: printf("SbPro");break;
		case OLDSB: printf("Old Sb");break;
		case GUS  : printf("GUS");break;
		case PAS  : printf("PAS");break;
		case UNKNOWN  : printf("Unknown");break;
		default: printf("error!"); break;
	}

	gotoxy(20,5); printf("%s",(norefresh)?"Off":"On");
	gotoxy(20,6); printf("%s",(debug_mode)?"On":"Off");
	gotoxy(20,7); printf("%s",(locked)?"On":"Off");

	if (start!=end) {
		gotoxy(0,8); printf("FPS   : %5.2f",((float)frames*1000.0)/((float)end-(float)start));
	} else {
		gotoxy(0,8); printf("FPS   : (bad)");
	}
	gotoxy(0,9);
	printf("Current flame  = %-20s",flamearray[curflame].name);
	gotoxy(0,10);			 
	printf("Current wave   = %-20s",wavearray[usewave].name);
	gotoxy(0,11);
	printf("Current display= %-20s",disparray[curdisplay].name);
	gotoxy(0,12);
	printf("Sample Rate    = %ud",sample_rate);
	gotoxy(0,13);
	printf("Stereo         = %s",(sample_stereo)?"On":"Off");
	gotoxy(0,14);
	printf("Input Device   = ");
	gotoxy(17,14);
	switch (device) {
		case CDInput:
			printf("CD");
			break;
		case LineInput:
			printf("Line");
			break;
		case MicInput:
			printf("Mic");
			break;
		default:
			printf("Unknown");
			break;
	}

	gotoxy(0,15);
}
