{ Show 24x24 Chinese Font }

uses SVGA256,Txt;

var FontAsc,FontSpc,FontSup:pointer;
    FileChn:string;      { 12288,29376,26280 bytes }

{  InitChinese  }
procedure InitChinese(Chn,Asc,Spc,Sup:string);
begin
  if (FileLen(Asc,1)<0) then
    begin Writeln(''''+Asc+''' not found !'); Halt(1); end;
  if (FileLen(Spc,1)<0) then
    begin Writeln(''''+Spc+''' not found !'); Halt(1); end;
  if (FileLen(Sup,1)<0) then
    begin Writeln(''''+Sup+''' not found !'); Halt(1); end;
  FileChn:=Chn;
  GetMem(FontAsc,12288); FileRead(Asc,0,256,48,FontAsc^);
  GetMem(FontSpc,29376); FileRead(Spc,0,408,72,FontSpc^);
  GetMem(FontSup,26280); FileRead(Sup,0,365,72,FontSup^);
end;
{  GetBig5  }
procedure GetBig5(Hi,Lo:byte;var Ty,N:integer);
var C:word;
begin
  if not((Hi in [$81..$FE]) and (Lo in [$40..$7E,$A1..$FE])) then
    begin Ty:=0; Exit; end;
  C:=Hi shl 8+Lo;
  case C of
    $A440..$C67E:
      begin Ty:=1; N:=157*(Hi-$A4)+Lo-$40; if Lo>=$A1 then Dec(N,34); end;
    $C940..$F9FE:
      begin Ty:=1; N:=157*(Hi-$C9)+Lo-$40+5401; if Lo>=$A1 then Dec(N,34); end;
    $A140..$A3BF:
      begin Ty:=2; N:=157*(Hi-$A1)+Lo-$40; if Lo>=$A1 then Dec(N,34); end;
    $C6A1..$C8D3:
      begin Ty:=3; N:=157*(Hi-$C6)+Lo-$A1; if Lo<=$7E then Inc(N,34); end;
    else Ty:=4;
  end;
end;
{  PrintC  }
procedure PrintC(Ty,X,Y,Color,Space,Count:integer;St:string);
var Buf1,Buf2:array[0..575] of byte;    { Ty: 0=Mono, 1..4=Color }
    S1,O1,S2,O2,S3,O3,Hi,Lo,Typ,N,L,P:integer;
    File1:file;
begin
  S1:=Seg(FontAsc^); O1:=Ofs(FontAsc^);
  S2:=Seg(FontSpc^); O2:=Ofs(FontSpc^);
  S3:=Seg(FontSup^); O3:=Ofs(FontSup^);
  Assign(File1,FileChn); Reset(File1,72);
  L:=Length(St); P:=0;
  while P<L do begin
    Hi:=Ord(St[P+1]); Lo:=Ord(St[P+2]);
    GetBig5(Hi,Lo,Typ,N);
    if (P=L-1) and (Hi in [$81..$FE]) then Ty:=0;
    case Typ of
      0:begin
	  Conv1to8(Mem[S1:O1+48*Hi],Buf2,48,Color,0);
	  Hi:=16; Lo:=12+Space shr 1; N:=1;
	end;
      1:begin
	  if N<13094 then begin Seek(File1,N); BlockRead(File1,Buf1,1); end
	    else FillChar(Buf1,72,0);
	  Conv1to8(Buf1,Buf2,72,Color,0);
	  Hi:=24; Lo:=24+Space; N:=2;
	end;
      2:begin
	  Conv1to8(Mem[S2:O2+72*N],Buf2,72,Color,0);
	  Hi:=24; Lo:=24+Space; N:=2;
	end;
      3:begin
	  Conv1to8(Mem[S3:O3+72*N],Buf2,72,Color,0);
	  Hi:=24; Lo:=24+Space; N:=2;
	end;
      4:begin
	  FillChar(Buf2,576,0);
	  Hi:=24; Lo:=24+Space; N:=2;
	end;
    end;
    if Ty>0 then Colorize(Ty,Hi,24,Color,Count,Color,Buf2);
    Get(X,Y,Hi,24,Buf1); Mix(Buf2,Buf1,24*Hi,0);
    Put(X,Y,Hi,24,Buf1);
    Inc(X,Lo); Inc(P,N);
  end;
  Close(File1);
end;
{  PrintC1  }
procedure PrintC1(Ty,X,Y,Color,Space,Count:integer;St:string);
begin
  PrintC(Ty,X+3,Y+3,16,Space,24,St);
  PrintC(Ty,X+2,Y+2,Color,Space,Count,St);
  PrintC(Ty,X-1,Y-1,Color,Space,Count,St);
  PrintC(Ty,X-1,Y+1,Color,Space,Count,St);
  PrintC(Ty,X+1,Y-1,Color,Space,Count,St);
  PrintC(Ty,X+1,Y+1,Color,Space,Count,St);
  PrintC(Ty,X-1,Y,Color,Space,Count,St);
  PrintC(Ty,X+1,Y,Color,Space,Count,St);
  PrintC(Ty,X,Y-1,Color,Space,Count,St);
  PrintC(Ty,X,Y+1,Color,Space,Count,St);
  PrintC(Ty,X,Y,16,Space,24,St);
end;
{  PrintC2  }
procedure PrintC2(Ty,X,Y,Color,Space,Count:integer;St:string);
begin
  PrintC(Ty,X+3,Y+3,Color,Space,Count,St);
  PrintC(Ty,X+2,Y+2,16,Space,24,St);
  PrintC(Ty,X+1,Y+1,16,Space,24,St);
  PrintC(Ty,X,Y,Color,Space,Count,St);
end;
{  Screen  }
procedure Screen;
const Pal:array[0..14] of byte=
       (22,22,50, 32,32,63, 36,36,63, 38,38,63, 40,40,63);
var A:array[0..7999] of byte;
    I:integer;
    Buf:pointer;
begin
  GetMem(Buf,32000);
  FileRead('word.pic',0,8000,1,A);
  SetPalette(8,5,Pal);
  for I:=0 to 7999 do case A[I] of
     0:A[I]:=10+Random(3);
     7:A[I]:=9;
    15:A[I]:=8;
  end;
  Zoom(A,Buf^,80,100,160,200);
  for I:=11 downto 0 do Put(160*(I mod 4),200*(I div 4),160,200,Buf^);
  FreeMem(Buf,32000);
end;

const
  St:array[0..3] of string[30]=
    ('wϥΥqt,',
    'qtάwkҦ,',
    'qзRϥθ귽!',
    ' Jou-Nan Chen 1995 ');
var I:integer;
begin
  SetMode(3);
  Screen;
  InitChinese('\et3\stdfont.24','\et3\ascfont.24','\et3\spcfont.24',
    '\et3\spcfsupp.24');
  for I:=0 to 3 do if I<3 then PrintC1(1,150,140+40*I,40+8*I,4,2,St[I])
    else PrintC2(1,150,140+40*I,40+8*I,4,2,St[I]);
  I:=Key;
  SetMode(0);
end.
