{ͻ
                                    
    Pattern Recognition #3          
    Optimal Linear Separability     
                                    
    Written by Jou-Nan Chen  1995   
                                    
 ͼ}

uses Txt,SVGA256;

const
  Cycle=100; S=0.05; Zoom=280;
  Z1=64; Z2=48;
  L1=640 div Z1; L2=480 div Z2;
  D:array[1..10,1..3] of real=(
    (-0.253, 1.832,-1),
    ( 1.130, 3.181,-1),
    (-2.812, 3.775,-1),
    ( 0.543,-0.010,-1),
    (-2.309,-0.414,-1),
    ( 1.188,-2.550,-1),
    ( 1.658,-2.604,-1),
    ( 4.192,-0.281,-1),
    ( 2.081,-0.941,-1),
    ( 2.208,-1.102,-1));
var I,J,K,N:integer;
    E,X,Y:real;
    St:string;
    Font:array[0..4000] of byte;
    Aw,B:array[1..10] of real;
    W,W0,Ab:array[1..3] of real;
    Aa,Ai:array[1..3,1..3] of real;
begin
  { ****** Show Screen ****** }
  SetMode(3);
  FileRead('1616sim#.fnt',0,96,32,Font);
  InstallFont(2,16,16,32,96,1,Font);
  Print3(1,1, 1,63,2,'Linear Separability');
  Print3(1,1,21,63,2,'Written by Jou-Nan Chen');
  Bar(0,240,640,1,36);
  Bar(320,0,1,480,36);
  for I:=0 to L1 do begin
    Bar(Z1*I,241,1,5,36);
    if I mod (L1 div 2)>0 then PrintNum(Z1*I,250,36,I-5);
  end;
  for I:=0 to L2 do begin
    Bar(321,Z2*I,5,1,36);
    if I mod (L2 div 2)>0 then PrintNum(330,Z2*I,36,5-I);
  end;
  for I:=1 to 5 do for J:=5 downto 1 do
    Circle(Trunc(D[I,1]*Z1)+320,240-Trunc(D[I,2]*Z2),J,J,50+J);
  for I:=6 to 10 do for J:=1 to 5 do
    Circle(Trunc(D[I,1]*Z1)+320,240-Trunc(D[I,2]*Z2),J,J,46-J);
  { ****** Compute ****** }
  { ****** (AT*A)' ****** }
  for I:=1 to 3 do for J:=1 to 3 do Aa[I,J]:=0;
  for I:=1 to 3 do for J:=1 to 3 do for K:=1 to 10 do
    Aa[I,J]:=Aa[I,J]+D[K,I]*D[K,J];
  E:=Aa[1,1]*Aa[2,2]*Aa[3,3]+Aa[2,1]*Aa[3,2]*Aa[1,3]+Aa[3,1]*Aa[1,2]*Aa[2,3]
    -Aa[1,3]*Aa[2,2]*Aa[3,1]-Aa[2,3]*Aa[3,2]*Aa[1,1]-Aa[3,3]*Aa[1,2]*Aa[2,1];
  Ai[1,1]:=Aa[2,2]*Aa[3,3]-Aa[2,3]*Aa[3,2];
  Ai[1,2]:=Aa[2,1]*Aa[3,3]-Aa[2,3]*Aa[3,1];
  Ai[1,3]:=Aa[2,1]*Aa[3,2]-Aa[2,2]*Aa[3,1];
  Ai[2,1]:=Aa[1,2]*Aa[3,3]-Aa[1,3]*Aa[3,2];
  Ai[2,2]:=Aa[1,1]*Aa[3,3]-Aa[1,3]*Aa[3,1];
  Ai[2,3]:=Aa[1,1]*Aa[3,2]-Aa[1,2]*Aa[3,1];
  Ai[3,1]:=Aa[1,2]*Aa[2,3]-Aa[1,3]*Aa[2,2];
  Ai[3,2]:=Aa[1,1]*Aa[2,3]-Aa[1,3]*Aa[2,1];
  Ai[3,3]:=Aa[1,1]*Aa[2,2]-Aa[1,2]*Aa[2,1];
  for I:=1 to 3 do for J:=1 to 3 do Ai[I,J]:=Ai[I,J]/E;
  { ****** Ininial B ****** }
  for I:=1 to 10 do B[I]:=-0.1*I; B[5]:=0.4; B[7]:=1;
  for N:=1 to Cycle do begin
    { ****** AT*B ****** }
    for I:=1 to 3 do Ab[I]:=0;
    for I:=1 to 3 do for J:=1 to 10 do Ab[I]:=Ab[I]+D[J,I]*B[J];
    { ****** W=(AT*A)'*(AT*B) ****** }
    for I:=1 to 3 do W[I]:=0;
    for I:=1 to 3 do for J:=1 to 3 do W[I]:=W[I]+Ai[I,J]*Ab[J];
    { ****** A*W ****** }
    for I:=1 to 10 do Aw[I]:=0;
    for I:=1 to 10 do for J:=1 to 3 do Aw[I]:=Aw[I]+D[I,J]*W[J];
    { ****** B=B+S*(A*W-B) ****** }
    for I:=1 to 10 do if Aw[I]-B[I]>0 then B[I]:=B[I]+S*(Aw[I]-B[I]);
    { ****** Error Measure ****** }
    if N=1 then begin
      Bar(30,275,250,200,1);
      for I:=0 to 3 do Box(30+I,275+I,250-2*I,200-2*I,52+I);
    end else begin
      E:=0;
      E:=E+Sqr(W[3]/W[1]-W0[3]/W0[1])+Sqr(W[3]/W[2]-W0[3]/W0[2]);
      X:=W[3]/W[1]*Z1; Y:=W[3]/W[2]*Z2;
      Line(320+Trunc(X),240,320,240-Trunc(Y),32+N mod 72);
      Bar(40+2*N,420-Trunc(E*Zoom),2,Trunc(E*Zoom)+1,32+N mod 72);
      Str(E:12:8,St); Bar(40,440,200,16,1); Print(40,440,15,St);
    end;
    for I:=1 to 3 do W0[I]:=W[I];
  end;
  { ****** End ****** }
  K:=Key;
  SetMode(0);
end.
