{ͻ
                                                   
    Pattern Recognition #2                         
    Parzen Window  Gaussian Density Estimation   
                                                   
    Written by Jou-Nan Chen  1995                  
                                                   
 ͼ}

uses Txt,SVGA256;

const
  Dots=700; Z1=64; Z2=48;
  L1=640 div Z1; L2=480 div Z2;
var I,J,K,N,S,U,V:integer;
    R1,R2,X,Y:real;
    St:string;
    Font:array[0..4000] of byte;
    D:array[1..Dots,1..2] of integer;
    A:array[1..20,1..20] of integer;
begin
  { ****** Show Screen ****** }
  SetMode(3);
  FileRead('1616sim#.fnt',0,96,32,Font);
  InstallFont(2,16,16,32,96,1,Font);
  Print3(1,1, 1,63,2,'Parzen-window');
  Print3(1,1,21,63,2,'Written by Jou-Nan Chen');
  Bar(0,240,640,1,53);
  Bar(320,0,1,480,53);
  for I:=0 to L1 do begin
    Bar(Z1*I,241,1,5,53);
    if I mod (L1 div 2)>0 then PrintNum(Z1*I,250,53,I-2);
  end;
  for I:=0 to L2 do begin
    Bar(321,Z2*I,5,1,53);
    if I mod (L2 div 2)>0 then PrintNum(330,Z2*I,53,2-I);
  end;
  Str(Dots,St); Print(0,70,15,'Samples='+St);
  { ****** Generate Random ****** }
  Randomize;
  for I:=1 to Dots do begin
    R1:=Random; R2:=Random;
    X:=Sqrt(-2*Ln(R1))*Cos(2*Pi*R2);
    Y:=Sqrt(-2*Ln(R1))*Sin(2*Pi*R2);
    D[I,1]:=Trunc(X*Z1);
    D[I,2]:=Trunc(Y*Z2);
    PutDot(D[I,1]+320,240-D[I,2],40+Random(4));
  end;
  { ****** Compute ****** }
  for N:=0 to 2 do begin
    for I:=1 to 20 do for J:=1 to 20 do A[I,J]:=0;
    { ****** 20x20,15x15,10x10 ****** }
    { ****** Count ****** }
    S:=5*(4-N); U:=4*(N+2); V:=U div 2;
    for I:=1 to Dots do Inc(A[D[I,1] div (16*(N+2))+S div 2+1,
			      D[I,2] div (12*(N+2))+S div 2+1]);
    for I:=1 to 20 do for J:=1 to 20 do A[I,J]:=A[I,J] div (N+1);
    { ****** 3D Graph ****** }
    for I:=1 to S do for J:=1 to S do
      for K:=0 to V-1 do
      Bar( 450+U*J-V*I-K,150*N+80-A[J,I]+V*I+K,U,A[J,I]+1,32+I+J);
    for I:=1 to S do for J:=1 to S-1 do
      Line(120+U*J-V*I,  150*N+80-A[J,I]+V*I,
	   120+U*J-V*I+U,150*N+80-A[J+1,I]+V*I,32+I+J);
    for I:=1 to S do for J:=1 to S-1 do
      Line(120+U*I-V*J,  150*N+80-A[I,J]+V*J,
	   120+U*I-V*J-V,150*N+80-A[I,J+1]+V*J+V,32+I+J);
  end;
  K:=Key;
  SetMode(0);
end.
