;method cribbed from some pibterm code.  Thanks to Phil Burns for making
;the source available...

bios_data	segment at 40h
		org 1Ah
buffer_head	dw ?			;pointer to keyboard buffer head
buffer_tail	dw ?			;pointer to keyboard buffer tail
		org 80h
buffer_start	dw ?			;starting keyboard buffer address
buffer_end	dw ?			;ending keyboard buffer address
bios_data	ends

code	segment
	assume	cs:code

	org	100h
start:
	jmp	start_1

keyboard      label dword
old9h         dw 2 dup (?)		;old interrupt 9h vector

;We look up the codes that we'll be modifying in our_codes.
;The replacements are in ctrl_codes or alt_codes.

our_codes	label	byte
	db	72			;Up Arrow
	db	74			;Minus
	db	76			;Five
	db	78			;Plus
	db	80			;Down Arrow
	db	82			;Ins
	db	83			;Del
	db	15			;Tab
	db	53			;/
	db	55			;Asterisk
	db	57			;Space
ctrl_gate	label	byte		;above this, we don't add ctrl-
	db	71			;Home
	db	73			;Pg Up
	db	79			;End
	db	81			;Pg Dn
	db	75			;Left Arrow
	db	77			;Right Arrow
	db	1			;-Esc
	db	14			;Back Space
	db	26			;{
	db	27			;}
	db	28			;Return
	db	39			;;
	db	40			;'
	db	41			;`
	db	43			;\
	db	51			;,
	db	52			;.
codes_count	equ	$-our_codes

ctrl_codes	label	byte
	db	141			;C-Up Arrow
	db	142			;C-Minus
	db	143			;C-Five
	db	144			;C-Plus
	db	145			;C-Down Arrow
	db	146			;C-Ins
	db	147			;C-Del
	db	148			;C-Tab
	db	149			;C-Slash
	db	150			;C-Asterisk
	db	167			;C- 		Fake for Freemacs

alt_codes	label	byte
	db	152			;M-Up Arrow
	db	74			;M-Minus
	db	76			;M-Five
	db	78			;M-Plus
	db	160			;M-Down Arrow
	db	162			;M-Ins
	db	163			;M-Del
	db	165			;M-Tab
	db	164			;M-Slash
	db	55			;M-Asterisk
	db	168			;M- 		Fake for Freemacs

	db	151			;M-Home
	db	153			;M-Pg Up
	db	159			;M-End
	db	161			;M-Pg Dn
	db	155			;M-Left Arrow
	db	157			;M-Right Arrow
	db	1			;M-Esc
	db	14			;M-Back Space
	db	26			;M-{
	db	27			;M-}
	db	28			;M-Return
	db	39			;M-;
	db	40			;M-'
	db	41			;M-`
	db	43			;M-\
	db	51			;M-,
	db	52			;M-.



;-----------------------------------------------------------------------------
;KBINT handles interrupt 9 and generates new extended keycodes.
;-----------------------------------------------------------------------------
kbint	proc near
	sti				;interrupts on
	push	ax			;save AX and BX
	push	bx
	push	cx
	push	di
	push	es

	in	al,60h			;read scan code
	push	cs
	pop	es
	mov	di,offset our_codes	;look it up in the table.
	mov	cx,codes_count
	cld
	repne	scasb
	je	our_key			;see if we should do ctrl versions.
oldint:
	pop	es
	pop	di
	pop	cx
	pop	bx			;restore AX and BX
	pop	ax
	jmp	keyboard		;exit to BIOS handler
;
;Generate extended codes for Ctrl-
;
our_key:
	mov	ah,2			;get shift key status
	int	16h
	and	al,0fh			;just consider the four shift keys.
	cmp	al,4			;Just Ctrl key pressed?
	jnz	checkalt		;no, then check Alt key
	cmp	di,offset ctrl_gate	;Should we do these?
	ja	oldint			;no - let the bios do them.
	mov	bl,cs:[ctrl_codes - our_codes + di - 1]
	jmp	short process		;process it
;
;Generate extended codes for Alt-
;
checkalt:
	cmp	al,8			;Just Alt key pressed?
	jnz	oldint			;no, then exit to BIOS
	mov	bl,cs:[alt_codes - our_codes + di - 1]

;
;Reset the keyboard and clear the interrupt.
;
process:
	in	al,61h			;read control port value
	mov	ah,al			;save it in AH
	or	al,80h			;set the high bit
	out	61h,al			;reset keyboard
	mov	al,ah			;retrieve original value
	out	61h,al			;enable keyboard
	cli
	mov	al,20h			;end the interrupt
	out	20h,al
	sti
;
;Insert the new keycode into the keyboard buffer.
;
	mov	ah,bl			;transfer code to AH
	xor	al,al			;zero AL
	push	dx			;save DX and DS
	push	ds
	mov	bx,bios_data		;point DS to BIOS data area
	mov	ds,bx
	assume	ds:bios_data
	cli				;interrupts off
	mov	bx,buffer_tail		;get current tail address
	mov	dx,bx			;transfer it to DX
	add	dx,2			;advance to next position
	cmp	dx,buffer_end		;wrap around if necessary
	jne	buffer
	mov	dx,buffer_start
buffer:
	cmp	dx,buffer_head		;is the buffer full?
	je	kbexit			;yes, then exit now
	mov	[bx],ax			;insert keycode into buffer
	mov	buffer_tail,dx		;advance tail
kbexit:
	sti				;enable interrupts
	pop	ds			;restore registers
	assume ds:nothing
	pop	dx

	pop	es
	pop	di
	pop	cx
	pop	bx
	pop	ax
	iret				;and exit
kbint	endp

start_1:
;
;Determine whether or not the BIOS supports extended keyboard functions.
;
	mov	ah,5			;write FFFFh to keyboard buffer
	mov	cx,0FFFFh
	int	16h
	mov	ah,10h			;then read it back
	int	16h
	cmp	ax,0FFFFh		;is AX set correctly?
	je	is_ext_kbd		;yes, then don't reset INT 9
;
;Point the interrupt 9 vector to the internal keyboard handler.
;
	push	es
	assume	es:nothing
	mov	ax,3509h		;get current vector
	int	21h
	mov	old9h,bx		;save it
	mov	old9h[2],es
	mov	ax,2509h			;then reset it
	mov	dx,offset kbint
	int	21h
	pop	es
	assume	es:code
	mov	dx,offset start_1		;TSR
	int	27h
;
;They already have an extended keyboard.
;
is_ext_kbd:
	mov	dx,offset is_extended_msg
	mov	ah,9
	int	21h
	int	20h

is_extended_msg	db	'You already have an extended keyboard$'

code	ends

	end	start
