\  SCREEN FILE COMPARISON PROGRAM

\ COPYRIGHT (C) 1985 BY THOMAS ALMY.  ALL RIGHTS RESERVED.

\  Users of ForthCMP are given permission to use or distribute this
\  program, as long as no charge is made and the credit message is maintained.

\ Uses memory for buffer area for maximum performance.

100 MSDOS
INCLUDE VARS
INCLUDE DOS1

0 CONSTANT FALSE
-1 CONSTANT TRUE
1024 CONSTANT B/BLK

HCB FILE1
HCB FILE2

VARIABLE DIFFLG  \ TRUE when differences exist
VARIABLE SCR#    \ current screen number
VARIABLE #BLKS   \ number of buffered block pairs
VARIABLE ACT1    \ number filled for file 1
VARIABLE ACT2    \ number filled for file 2
VARIABLE BUF1ST  \ start of first buffer
VARIABLE BUF2ST  \ start of second buffer
VARIABLE INDX    \ index into buffers

2 1 IN/OUT
: SCR<> ( string1 string2  -- flag, true if different )
    FALSE -ROT  B/BLK  0 ?DO
      OVER I + C@  OVER I + C@
           <> IF  ROT DROP TRUE -ROT LEAVE THEN
      LOOP
  2DROP ;

0 0 IN/OUT
: INITIALIZE-DATA
  PAD DUP BUF1ST !  S0 @ 100 - OVER - 0  B/BLK 2* UM/MOD NIP
  DUP #BLKS !  DUP ACT1 ! DUP ACT2 ! DUP INDX !
  B/BLK * + BUF2ST !
  DIFFLG OFF  SCR# OFF ;

0 0 IN/OUT
: FILL-BUFFERS
	FILE1 BUF1ST @ #BLKS @ B/BLK * FREAD
	  0 B/BLK UM/MOD NIP  ACT1 !
	FILE2 BUF2ST @ #BLKS @ B/BLK * FREAD
	  0 B/BLK UM/MOD NIP  ACT2 !
  INDX OFF ;

: READ-SCREENS? ( -- addr1 addr2 flag1 flag2 )
                ( no addr'S if either flag is zero )
  INDX @ #BLKS @ = IF FILL-BUFFERS THEN
  INDX @ ACT1 @ = IF  FALSE INDX @ ACT2 @ <>  EXIT THEN
  INDX @ ACT2 @ = IF  TRUE FALSE EXIT THEN
  INDX @ B/BLK *  BUF1ST @ OVER +  SWAP BUF2ST @ +
  TRUE TRUE
  1 INDX +! ;

0 0 IN/OUT
: HELLO 
  ." Forth Screenfile Comparison Program" CR
  ." Copyright (C) 1985 by Thomas Almy.  All Rights Reserved"
  ;

1 0 IN/OUT
: .DIFS ( scr# -- )
  DIFFLG @ 0= IF CR ." Different: "  DIFFLG ON THEN
  . ;

2 0 IN/OUT
: .LARGER ( firstfileflg scr#  -- ) SWAP  CR  DIFFLG ON
  IF ." First" ELSE ." Second" THEN
  ."  file larger, starting screen " . ;

0 0 IN/OUT
: ?THE-SAME  DIFFLG @ 0= IF CR ." Files are identical" THEN ;

0 0 IN/OUT
: COMPARE-SCREENS
  BEGIN
   READ-SCREENS?
   2DUP AND WHILE ( both read )
   2DROP
   SCR<> IF SCR# @ .DIFS THEN
   1 SCR# +!
  REPEAT
  OVER OR IF ( one reached eof first )
       SCR# @ .LARGER
          ELSE ( both ended )
       DROP  ?THE-SAME
      THEN ;

1 0 IN/OUT
: ?FNF IF CR ." File not found"  bye THEN ;

1 0 IN/OUT
: ADD.DEFAULT.EXTENSION ( handle -- )
  2+ DUP >R  1+  ( ext string )
  BEGIN COUNT DUP ASCII . = IF DROP BEGIN COUNT DUP 0=
        IF R> DROP 2DROP EXIT THEN  DUP ASCII \ = SWAP ASCII / = OR UNTIL  1 THEN
        0= UNTIL
  DUP 1- ASCII . C<-  ( replace null with dot )
  CNT" SCR"  0 DO COUNT 2 PICK C! SWAP 1+ SWAP LOOP
  DROP ( extension address )
  DUP 0 C<-  ( delimit string )
  R@ - 1- R> C!   ( set length byte )
  ; 

0 0 IN/OUT
: USAGE ( only one file specified )  CR
  ." USAGE: SCRDIF [ filename1 filename2 ] " CR
  bye ;

0 0 IN/OUT
: OPEN-FILES
	129 TIB 128 C@ DUP #TIB ! CMOVE  \ get command line
	BL WORD C@ 0= IF USAGE THEN	\ no args
	HERE FILE1 NAME>HCB
	FILE1 ADD.DEFAULT.EXTENSION
	FILE1 O_RD FOPEN ?FNF
	BL WORD C@ 0= IF USAGE THEN	\ no args
	HERE FILE2 NAME>HCB
	FILE2 ADD.DEFAULT.EXTENSION
	FILE2 O_RD FOPEN ?FNF
   ;


: MAIN
    HELLO
    INITIALIZE-DATA
    OPEN-FILES
    COMPARE-SCREENS
    bye
;


INCLUDE DOS2
INCLUDE FORTHLIB
END
