/* extract bytes from a file into another file */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#ifdef MSDOS
#include <io.h>
#include <stdlib.h>
#define BUF_SIZE	16384
#else
#define O_BINARY	0
#define SEEK_SET	0
#define SEEK_END	2
#define BUF_SIZE	262144
#endif

#define DEFAULT_BLOCK	262144
int in_file, out_file;
long start;
long endf;
long in_size;
long bytes_to_copy;

char *buf;
char in_file_name[128], out_file_name[128];

long size_of_block;
int  file_count=0;

/* because ASCII C atol does not distinguish between zero and errors */
long myatol (s) char *s; {
	long temp;
	temp = 0;
	while (*s != 0) {
		if (*s<'0' || *s>'9')	return (-1);
		temp = 10*temp + (*s-'0');
		s++;
	}
	return (temp);
} /* end myatol */


int do_the_copy () {
	long bytes_read;
	int  result;
	int  read_size;

	for (bytes_read=0; bytes_read<bytes_to_copy; bytes_read+=result) {

		if (bytes_to_copy - bytes_read < BUF_SIZE)
			read_size = bytes_to_copy - bytes_read;
		else
			read_size = BUF_SIZE;

		if ( (result=read (in_file, buf, read_size)) != read_size) {
			fprintf (stderr, "read error\n");
			return (1);
		}

		if (write (out_file, buf, result) < 0) {
			printf ("write error\n");
			return (1);
		}
	}
	return (0);
}


void usage () {
	fprintf (stderr, "\nfilextrt 1.0 - extract bytes from a file. Richard Marks\n\n");
	fprintf (stderr, "filextrt [-s s]  [-e e] [-n n] infile outfile\n");
	fprintf (stderr, "\tstarting at byte offest s from the front of the file,\n");
	fprintf (stderr, "\tor byte offset e from the end of the file\n");
	fprintf (stderr, "\textracts n bytes from infile result to outfile\n");
	fprintf (stderr, "\ts and e are not specified, defaults to the start of the file.\n");
	fprintf (stderr, "\tif n is not specified, extract the remainder of the file\n");
	fprintf (stderr, "\tNote, start and end are offsets, start 1 is second byte\n");
	exit (1);
}  /* end usage */


void main (argc, argv) int argc; char **argv; {
int i=1;
in_file_name[0] = out_file_name[0] = 0;

start = -1;
endf  = -1;
in_size = 0;
bytes_to_copy = -1;

while (i<argc) {
	if (argv[i][0] != '-')	break;
	if (argv[i][2] != 0)	usage ();
	if (tolower(argv[i][1]) == 's') {
		if (start != -1 || endf != -1)	usage ();
		if (++i >= argc)		usage ();
		if ((start=myatol(argv[i])) <0)	usage ();

	} else if (tolower(argv[i][1]) == 'e') {
		if (start != -1 || endf != -1)	usage ();
		if (++i >= argc)		usage ();
		if ((endf=myatol(argv[i])) < 0)	usage ();

	} else if (tolower(argv[i][1]) == 'n') {
		if (bytes_to_copy != -1)	usage ();
		if (++i >= argc)		usage ();
		if ((bytes_to_copy=myatol(argv[i])) <= 0)	usage ();
	} else {
		usage ();
	}
	i++;
}

/* get input file name - if given */
if (i<argc) {
	strcpy (in_file_name, argv[i]);
	if ( (in_file=open (in_file_name, O_RDONLY | O_BINARY)) < 0) {
		fprintf (stderr, "open error on %s\n", in_file_name);
		usage ();
	}
}

i++;
if (i<argc) {
	strcpy (out_file_name, argv[i]);
	if (strcmp(out_file_name, "-") == 0)  out_file_name[0]=0;
}

i++;
if (i != argc)	usage ();
if (start==-1 && bytes_to_copy==-1 && endf==-1) usage ();

in_size = lseek (in_file, 0, SEEK_END);
if (endf >= 0) {
	if (endf >= in_size)	goto E1;
	start=in_size-endf-1;
}
if (start<0)		start=0;
if (start>=in_size)	goto E1;
if (bytes_to_copy<=0)	bytes_to_copy = in_size-start;

if (start+bytes_to_copy > in_size) {
E1:	fprintf (stderr, "param greater than file size of %d\n", in_size);
	usage ();
}

if ((buf=(char*)malloc(BUF_SIZE)) == NULL) {
	fprintf (stderr, "memory allocation error\n");
	usage ();
}

if ( (out_file=open (out_file_name, O_CREAT|O_WRONLY|O_BINARY, 0666)) < 0) {
		fprintf (stderr, "open error on %s\n", out_file_name);
		usage ();
}

/* now, position for reads */
if (lseek (in_file, start, SEEK_SET) != start) {
		fprintf (stderr, "lseek error\n");
		usage ();
}

/* print summary of what is happening */
fprintf (stderr, "filextrt 1.0, by Richard Marks\n");
fprintf (stderr, "Extracting %ld bytes starting at byte %ld, from file %s\n",
			bytes_to_copy, start, in_file_name);

do_the_copy ();

close (in_file);  close(out_file);
}
