/*
 * uprompt.c - set the prompt to the current working directory, with
 * forward slashes
 *
 * Author:		R. Brittain						4/11/90
 *
 * Syntax:
 *		uprompt
 *
 *					This code placed in the public domain
 *
 */
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <stdlib.h>
#include <io.h>

/* size minimization measures */
setenvp() {}
void exit(int status) { _exit(status); }

#define MEMCHECK(x)		if ((x) == NULL) fatal("Out of memory",1)

#ifdef UNIXCOMPAT
 #define strupr(x)			(x)		/* disable upper-casing env-vars */
#endif

/* prototypes */

int 	 get_env_index(char *var, char **env_var);
int  	 getenvseg(unsigned *envseg);
unsigned get_env_var(unsigned env_addr, char ***env_var, int *count);
void 	 put_env_var(unsigned env_addr, unsigned seglen, char **env_var);

void 	 fatal(char *msg, int status);
char 	 *concat(char *s1, char *s2);
char 	 *translit(char *s,char c1,char c2);

main()
{
	unsigned env_addr, seglen;
	int index, count;
	char dbuf[64], **env_var;

	if ( !getenvseg(&env_addr))
		fatal ("Cannot locate environment\n",2);

	seglen = get_env_var( env_addr, &env_var, &count );
	index  = get_env_index( "PROMPT", env_var );

	/* change the value of the variable */

	*(strchr(env_var[index],'=')+1) = '\0';
	env_var[index] = concat(env_var[index],translit(strlwr(getcwd(dbuf,sizeof(dbuf))),'\\','/'));
	env_var[index] = concat(env_var[index]," >");
	put_env_var(env_addr, seglen, env_var);
	return(0);
}


char *concat(s1, s2)
char *s1, *s2;
{
/*
 * return the concatenation of s1 and s2 in malloced memory
 */
	char *p;
	p = malloc(strlen(s1)+strlen(s2)+2);
	if (p == (char *)NULL) {
		fatal ("\nOut of memory\n",1);
	} else {
		strcpy(p,s1);
		strcat(p,s2);
	}
	return(p);
}

void fatal(char *msg, int status)
{
	write(2,msg,strlen(msg));
	exit(status);
}

char *translit(s,c1,c2)
char *s, c1, c2;
{
/*  turn all c1 into c2 in string s, in situ. Return pointer to start of s */
	char *p;
	p = s;
	while (*s) {
		if (*s == c1) *s = c2;
		s++;
	}
	return(p);
}

#include "envfuncs.c"
