                                  
/*
**  TextView Program - (C) 1994 Paul Burgin
*/

/* This module is a stand-alone text viewer. No comments. */

#include "stdio.h"
#include "conio.h"
#include "bios.h"
#include "string.h"
#include "ctype.h"

/* PCD: quit prototype */
extern void quit(unsigned char *text, unsigned char exit_type);

#define SLINES	25
#define PLINES	(SLINES-4)
#define RLINES	120
#define PX		2
#define PY		3

const char header[] = "TEXTVIEW (C) 1994 By Paul Burgin";
const char footer[] = "   PgUp PgDn HOME END = Scroll  F3 = Search  F4 = Search Again  ESC = Exit";
const char newline[] = "\n\r";
const char blank[79] = "                                                                              ";

char			at_eof;
fpos_t			pos_ary[RLINES];
fpos_t			last_pos;
signed int		pos_used;
long			last_line, curr_line;
FILE			*tp;
char			eexit;
char			string[70] = "Default Search String [set 'findlen' to length].";
int				findlen = 0;

void foot(void)
{
	textattr((LIGHTGRAY << 4) + RED);
	window(1,SLINES,80,SLINES);
	cprintf(newline);
	cprintf(footer);
}

void stats(void)
{
	long percent;
	int xx = wherex(), yy = wherey();

	percent = curr_line * 100L;
	percent /= last_line;
	window(76,SLINES-1,80,SLINES-1);
	textattr((CYAN << 4) + WHITE);
	if (percent < 10L)
		putch(205);
	else if (percent > 99L)
		percent = 99L;
	cprintf("%ld%%", percent);
	window(3,SLINES-1,80,SLINES-1);
	cprintf("%ld%c%c%c%c%c",curr_line-PLINES,205,205,205,205,205);
	window(79,1,80,1);
	textattr((LIGHTGRAY << 4) + DARKGRAY);
	if (pos_used < (PLINES+10))
		putch(' ');
	if (pos_used >= (PLINES+1))
		cprintf("%d",pos_used-PLINES);
	else
		putch(' ');
	window(PX,PY,79,SLINES-2);
	textattr((CYAN << 4) + BLACK);
	gotoxy(xx,yy);
}

void outline(char do_output)
{
	int ch, count = 0;

	curr_line++;
	if (pos_used < RLINES)
	{
		fgetpos(tp,&pos_ary[pos_used]);
		pos_used++;
	}
	else
	{
		for (ch = 0; ch < (RLINES-1); ch++)
			pos_ary[ch] = pos_ary[ch+1];
		fgetpos(tp,&pos_ary[RLINES-1]);
	}

	if (!at_eof)
	{
		do
		{
			ch = fgetc(tp);
			if ((ch != EOF) && (ch != '\n') && do_output)
			{
				putch(ch);
				count++;
			}
		} while ((ch != EOF) && (ch != '\n'));
		if (ch == EOF)
			at_eof = 1;
		while (bioskey(1))
			bioskey(0);
	}
	if ((count < 78) && do_output)
		cprintf(&blank[count]);
}

void outpage(void)
{
	char ln, lmax = PLINES;

	if (!at_eof)
	{
		if (wherey() == 1)
		{
			outline(1);
			lmax--;
		}
		for (ln = 0; ln < lmax; ln++)
		{
			cprintf(newline);
			outline(1);
		}
	}
}

void reverse(char how_far)
{
	int		ch;
	fpos_t	nowpos;
	long	now_line = 0;

	at_eof = 0;
	curr_line-=(PLINES+how_far);
	pos_used-=(PLINES+how_far);

	if (pos_used < 0)
	{
		rewind(tp);
		pos_used = 0;
		fgetpos(tp, &pos_ary[pos_used++]);

		if (curr_line > 1)
		{
			do
			{
				now_line++;
				do
				{
					ch = fgetc(tp);
				} while ((ch != '\n') && (ch != EOF));
				fgetpos(tp, &nowpos);
				if (now_line != curr_line)
				{
					if (pos_used < RLINES)
					{
						pos_ary[pos_used] = nowpos;
						pos_used++;
					}
					else
					{
						for (ch = 0; ch < (RLINES-1); ch++)
							pos_ary[ch] = pos_ary[ch+1];
						pos_ary[RLINES-1] = nowpos;
					}
				}
				while (bioskey(1))
					getch();
			} while (now_line < curr_line);
			pos_used--;
		}
		else
		{
			curr_line = 1;
			pos_used = 0;
		}
	}
	fsetpos(tp, &pos_ary[pos_used]);
	gotoxy(1,1);
	if ((how_far == 1) && (curr_line > 1))
	{
		insline();
		outline(1);
		gotoxy(78,PLINES);
		for (now_line = 0; now_line < (PLINES-1); now_line++)
			outline(0);
	}
	else
		outpage();
	stats();
}

void find(char again)
{
	int		xx = wherex(), yy = wherey();
	int		posn, srchlen;

	if (!again)
	{
		textattr((LIGHTGRAY << 4) + BROWN);
		window(1,SLINES,80,SLINES);
		cprintf(blank);
		cprintf(newline);
		cprintf(" Search For: ");
		string[0] = 67;
		cgets(string);
		findlen = string[1];
		strcpy(string,&string[2]);
		cprintf(newline);
		foot();
		window(PX,PY,79,SLINES-2);
		textattr((CYAN << 4) + BLACK);
		gotoxy(xx,yy);
	}
	if (findlen > 0)
	{
		char	instr[100];
		fpos_t	original, find_pos;
		long	oldline = curr_line;
		char	found = 0, end = 0;

		fgetpos(tp, &original);
		curr_line-=(PLINES-1);
		fsetpos(tp, &pos_ary[pos_used-(PLINES-1)]);

		do
		{
			fgetpos(tp, &find_pos);
			if (fgets(instr,99,tp) == NULL)
				end = 1;
			else
			{
				curr_line++;
				srchlen = strlen(instr) - findlen;
				if (srchlen >= 0)
				{
					for (posn = 0; posn <= srchlen; posn++)
					{
						if (strnicmp(string,&instr[posn],findlen) == 0)
							found = 1;
					}
				}
			}
		} while (!found && !end);
		if (end)
		{
			fsetpos(tp, &original);
			curr_line = oldline;
		}
		if (found)
		{
			at_eof = 0;
			fsetpos(tp, &find_pos);
			curr_line--;
			pos_used = 0;
			gotoxy(1,1);
			outpage();
			stats();
		}
	}
}

/*
** TextView
**
** tname    = filename of file to view
** tmessage = message to print at top of screen
** tcolour  = colour for tmessage
**
** return:  0 = file not found, 1 = success
**
** Always exits in C80 mode.
*/

int textview(char *tname, char *tmessage, int tcolour)
{
	int _winit = _wscroll;

	tp = fopen(tname, "rt");
	if (tp != NULL)
	{
		char linenum;
		signed int inch;
		char *hdr_mes = (char *)header;

		at_eof = eexit = 0;
		pos_used = 0;
		_wscroll = 0;
		textmode(C80);
		_setcursortype(_NOCURSOR);

		if (tmessage != NULL)
			hdr_mes = tmessage;
		textattr((LIGHTGRAY << 4) + (tcolour & 0x0f));
		window(1,1,80,1);
		cprintf(newline);
		cprintf(&blank[78-(40-(strlen(hdr_mes)>>1))]);
		cprintf(hdr_mes);
		foot();

		window(1,2,80,SLINES-1);
		textattr((CYAN << 4) + WHITE);
		clrscr();
		putch(201);
		for(linenum=2;linenum<80;linenum++)
			putch(205);
		putch(187);
		for(linenum=2;linenum<(SLINES-2);linenum++)
		{
			gotoxy(1,linenum);
			putch(186);
			gotoxy(80,linenum);
			putch(186);
		}
		gotoxy(1,SLINES-2);
		putch(200);
		for(linenum=2;linenum<80;linenum++)
			putch(205);
		putch(188);

		window(PX,PY,79,SLINES-2);
		textattr((CYAN << 4) + BLACK);

		curr_line = 1L;
		outpage();

		fgetpos(tp,&pos_ary[RLINES-1]);
		last_line = curr_line-1;
		do
		{
			do
			{
				inch = fgetc(tp);
			} while ((inch != '\n') && (inch != EOF));
			last_line++;
		} while (inch != EOF);
		fgetpos(tp, &last_pos);

		stats();
		fsetpos(tp,&pos_ary[RLINES-1]);

		do
		{
			unsigned char inchar;

			inchar = getch();
			if (inchar == 0)
			{
				inchar = getch();

				/* Re-map a couple of codes which clash with letters. */
				switch (inchar)
				{
					case 0x44:
					case 0x5D:
					case 0x67:
					case 0x71:	inchar = 'X';
								break;
					case 0x51:	inchar = 0xA0;
								break;
				}
			}
			else
				inchar = toupper(inchar);
			switch(inchar & 0xff)
			{
				/* Quit. */
				case 3:
				case 'X':
				case 'Q':
				case 27:	eexit = 1;
							break;

				case 0x10:
				case 0x2D:
				case 24:
				case 17:	quit("",4); /* PCD: separated from above */

				/* Home. */
				case 0x47:
				case 0x77:
				case 0x97:
				case 0x84:
				case 0x99:	rewind(tp);
							curr_line = 1L;
							pos_used = 0;
							at_eof = 0;
							gotoxy(1,1);
							outpage();
							stats();
							break;

				/* Page Up. */
				case 0x8D:
				case 0x98:
				case 0x73:
				case 0x9B:
				case 0x49:	reverse(PLINES);
							break;

				/* End. */
				case 0x4f:
				case 0x75:
				case 0x9F:
				case 0x76:
				case 0xA1:	fsetpos(tp, &last_pos);
							pos_used = 0;
							curr_line = last_line;
							reverse(0);
							break;

				/* Line Up. */
				case 0x48:
				case 0x4B:
				case 'U':	reverse(1);
							break;

				/* Line Down. */
				case 0x50:
				case 0x4D:
				case '\n':
				case '\r':
				case 'D':	if (curr_line < last_line)
							{
								cprintf(newline);
								outline(1);
								stats();
							}
							break;

				/* Page Down. */
				case 0x91:
				case 0xA0:
				case 0x74:
				case 0x9D:	gotoxy(1,1);

				/* Scroll Down. */
				case ' ':	if (curr_line < last_line)
							{
								outpage();
								stats();
							}
							break;

				/* Find. */
				case 0x1F:
				case 0x21:
				case 0x3D:	find(0);
							break;

				/* Find again. */
				case 0x1E:
				case 12:
				case 0x3E:	find(1);
							break;
			}
		} while (!eexit);

		fclose(tp);

		_wscroll = _winit;
		window(1,1,80,SLINES);
		textattr((BLACK << 4) + LIGHTGRAY);
		_setcursortype(_NORMALCURSOR);
		clrscr();
		return 1;
	}
	return 0;
}
