                    
/*
**  Table Of Instruction Data For 6809 Engine.
**
**  Copyright 1993-97 by Paul D. Burgin. All rights reserved.
*/

#include "dos.h"
#include "conio.h"

#include "build.h"
#include "types.h"
#include "extern.h"
#include "6809cpu.h"

/* Instruction information. */
const ins_t i_table[256 * sizeof(instruction)] =
{

	/* 00 */
	NEG,		DIRECT,		TO_MEM,		6,		2,
	_DOIO,		INHERENT,	NO_REG,	   10,	    2, /* Used for I/O. */
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	COM,		DIRECT,		TO_MEM,		6,		2,
	LSR,		DIRECT,		TO_MEM,		6,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ROR,		DIRECT,		TO_MEM,		6,		2,
	ASR,		DIRECT,		TO_MEM,		6,		2,

	/* 08 */
	LSL,		DIRECT,		TO_MEM,		6,		2,
	ROL,		DIRECT,		TO_MEM,		6,		2,
	DEC,		DIRECT,		TO_MEM,		6,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	INC,		DIRECT,		TO_MEM,		6,		2,
	TST,		DIRECT,		TO_MEM,		6,		2,
	JMP,		DIRECT,		TO_MEM,		3,		2,
	CLR,		DIRECT,		TO_MEM,		6,		2,

	/* 10 */
	ILLEGAL,		NO_MODE,	NO_REG,	    0,	    1, /* 10xx instructions */
	ILLEGAL,		NO_MODE,	NO_REG,	   	0,	    1, /* 11xx instructions */
	NOP,		INHERENT,	NO_REG,		2,		1,
	SYNC,		INHERENT,	NO_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	JMP,		RELATIVE,	NO_REG,		5,		3,
	JMP,		RELATIVE,	NO_REG,		9,		3,

	/* 18 */
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	DAA,		INHERENT,	A_REG,		2,		1,
	ORCC,		IMMEDIATE,	CC_REG,		3,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ANDCC,		IMMEDIATE,	CC_REG,		3,		2,
	SEX,		INHERENT,	NO_REG,		2,		1,
	EXG,		INHERENT,	NO_REG,		8,		2,
	TFR,		INHERENT,	NO_REG,		7,		2,

	/* 20 */
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,

	/* 28 */
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,
	JMP,		RELATIVE,	NO_REG,		3,		2,

	/* 30 */
	LEA,		INDEXED,	X_REG,		4,		2,
	LEA,		INDEXED,	Y_REG,		4,		2,
	LEA,		INDEXED,	S_REG,		4,		2,
	LEA,		INDEXED,	U_REG,		4,		2,
	PSH,		INHERENT,	S_REG,		5,		2,
	PUL,		INHERENT,	S_REG,		5,		2,
	PSH,		INHERENT,	U_REG,		5,		2,
	PUL,		INHERENT,	U_REG,		5,		2,

	/* 38 */
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	RTS,		INHERENT,	NO_REG,		5,		1,
	ABX,		INHERENT,	NO_REG,		3,		1,
	RTI,		INHERENT,	NO_REG,		6,		1,
	CWAI,		IMMEDIATE,	CC_REG,	   21,		2,
	MUL,		INHERENT,	NO_REG,	   11,		1,
	_RESET,		INHERENT,	NO_REG,		1,	    1,
	SWI,		INHERENT,	NO_REG,	   19,		1,

	/* 40 */
	NEG,		INHERENT,	A_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	COM,		INHERENT,	A_REG,		2,		1,
	LSR,		INHERENT,	A_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ROR,		INHERENT,	A_REG,		2,		1,
	ASR,		INHERENT,	A_REG,		2,		1,

	/* 48 */
	LSL,		INHERENT,	A_REG,		2,		1,
	ROL,		INHERENT,	A_REG,		2,		1,
	DEC,		INHERENT,	A_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	INC,		INHERENT,	A_REG,		2,		1,
	TST,		INHERENT,	A_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	CLR,		INHERENT,	A_REG,		2,		1,

	/* 50 */
	NEG,		INHERENT,	B_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	COM,		INHERENT,	B_REG,		2,		1,
	LSR,		INHERENT,	B_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ROR,		INHERENT,	B_REG,		2,		1,
	ASR,		INHERENT,	B_REG,		2,		1,

	/* 58 */
	LSL,		INHERENT,	B_REG,		2,		1,
	ROL,		INHERENT,	B_REG,		2,		1,
	DEC,		INHERENT,	B_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	INC,		INHERENT,	B_REG,		2,		1,
	TST,		INHERENT,	B_REG,		2,		1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	CLR,		INHERENT,	B_REG,		2,		1,

	/* 60 */
	NEG,		INDEXED,	TO_MEM,		6,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	COM,		INDEXED,	TO_MEM,		6,		2,
	LSR,		INDEXED,	TO_MEM,		6,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ROR,		INDEXED,	TO_MEM,		6,		2,
	ASR,		INDEXED,	TO_MEM,		6,		2,

	/* 68 */
	LSL,		INDEXED,	TO_MEM,		6,		2,
	ROL,		INDEXED,	TO_MEM,		6,		2,
	DEC,		INDEXED,	TO_MEM,		6,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	INC,		INDEXED,	TO_MEM,		6,		2,
	TST,		INDEXED,	TO_MEM,		6,		2,
	JMP,		INDEXED,	TO_MEM,		3,		2,
	CLR,		INDEXED,	TO_MEM,		6,		2,

	/* 70 */
	NEG,		EXTENDED,	TO_MEM,		7,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	COM,		EXTENDED,	TO_MEM,		7,		3,
	LSR,		EXTENDED,	TO_MEM,		7,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	ROR,		EXTENDED,	TO_MEM,		7,		3,
	ASR,		EXTENDED,	TO_MEM,		7,		3,

	/* 78 */
	LSL,		EXTENDED,	TO_MEM,		7,		3,
	ROL,		EXTENDED,	TO_MEM,		7,		3,
	DEC,		EXTENDED,	TO_MEM,		7,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	INC,		EXTENDED,	TO_MEM,		7,		3,
	TST,		EXTENDED,	TO_MEM,		7,		3,
	JMP,		EXTENDED,	TO_MEM,		3,		3,
	CLR,		EXTENDED,	TO_MEM,		7,		3,

	/* 80 */
	SUB8,		IMMEDIATE,	A_REG,		2,		2,
	CMP8,		IMMEDIATE,	A_REG,		2,		2,
	SBC,		IMMEDIATE,	A_REG,		2,		2,
	SUB16,		IMMEDIATE,	D_REG,		4,		3,
	AND,		IMMEDIATE,	A_REG,		2,		2,
	BIT,		IMMEDIATE,	A_REG,		2,		2,
	LD8,		IMMEDIATE,	A_REG,		2,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,

	/* 88 */
	EOR,		IMMEDIATE,	A_REG,		2,		2,
	ADC,		IMMEDIATE,	A_REG,		2,		2,
	OR,			IMMEDIATE,	A_REG,		2,		2,
	ADD8,		IMMEDIATE,	A_REG,		2,		2,
	CMP16,		IMMEDIATE,	X_REG,		4,		3,
	JMP,		RELATIVE,	NO_REG,		7,		2,
	LD16,		IMMEDIATE,	X_REG,		3,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,

	/* 90 */
	SUB8,		DIRECT,		A_REG,		4,		2,
	CMP8,		DIRECT,		A_REG,		4,		2,
	SBC,		DIRECT,		A_REG,		4,		2,
	SUB16,		DIRECT,		D_REG,		6,		2,
	AND,		DIRECT,		A_REG,		4,		2,
	BIT,		DIRECT,		A_REG,		4,		2,
	LD8,		DIRECT,		A_REG,		4,		2,
	ST8,		DIRECT,		A_REG,		4,		2,

	/* 98 */
	EOR,		DIRECT,		A_REG,		4,		2,
	ADC,		DIRECT,		A_REG,		4,		2,
	OR,			DIRECT,		A_REG,		4,		2,
	ADD8,		DIRECT,		A_REG,		4,		2,
	CMP16,		DIRECT,		X_REG,		6,		2,
	JMP,		DIRECT,		NO_REG,		7,		2,
	LD16,		DIRECT,		X_REG,		5,		2,
	ST16,		DIRECT,		X_REG,		5,		2,

	/* A0 */
	SUB8,		INDEXED,	A_REG,		4,		2,
	CMP8,		INDEXED,	A_REG,		4,		2,
	SBC,		INDEXED,	A_REG,		4,		2,
	SUB16,		INDEXED,	D_REG,		6,		2,
	AND,		INDEXED,	A_REG,		4,		2,
	BIT,		INDEXED,	A_REG,		4,		2,
	LD8,		INDEXED,	A_REG,		4,		2,
	ST8,		INDEXED,	A_REG,		4,		2,

	/* A8 */
	EOR,		INDEXED,	A_REG,		4,		2,
	ADC,		INDEXED,	A_REG,		4,		2,
	OR,			INDEXED,	A_REG,		4,		2,
	ADD8,		INDEXED,	A_REG,		4,		2,
	CMP16,		INDEXED,	X_REG,		6,		2,
	JMP,		INDEXED,	NO_REG,		7,		2,
	LD16,		INDEXED,	X_REG,		5,		2,
	ST16,		INDEXED,	X_REG,		5,		2,

	/* B0 */
	SUB8,		EXTENDED,	A_REG,		5,		3,
	CMP8,		EXTENDED,	A_REG,		5,		3,
	SBC,		EXTENDED,	A_REG,		5,		3,
	SUB16,		EXTENDED,	D_REG,		7,		3,
	AND,		EXTENDED,	A_REG,		5,		3,
	BIT,		EXTENDED,	A_REG,		5,		3,
	LD8,		EXTENDED,	A_REG,		5,		3,
	ST8,		EXTENDED,	A_REG,		5,		3,

	/* B8 */
	EOR,		EXTENDED,	A_REG,		5,		3,
	ADC,		EXTENDED,	A_REG,		5,		3,
	OR,			EXTENDED,	A_REG,		5,		3,
	ADD8,		EXTENDED,	A_REG,		5,		3,
	CMP16,		EXTENDED,	X_REG,		7,		3,
	JMP,		EXTENDED,	NO_REG,		8,		3,
	LD16,		EXTENDED,	X_REG,		6,		3,
	ST16,		EXTENDED,	X_REG,		6,		3,

	/* C0 */
	SUB8,		IMMEDIATE,	B_REG,		2,		2,
	CMP8,		IMMEDIATE,	B_REG,		2,		2,
	SBC,		IMMEDIATE,	B_REG,		2,		2,
	ADD16,		IMMEDIATE,	D_REG,		4,		3,
	AND,		IMMEDIATE,	B_REG,		2,		2,
	BIT,		IMMEDIATE,	B_REG,		2,		2,
	LD8,		IMMEDIATE,	B_REG,		2,		2,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,

	/* C8 */
	EOR,		IMMEDIATE,	B_REG,		2,		2,
	ADC,		IMMEDIATE,	B_REG,		2,		2,
	OR,			IMMEDIATE,	B_REG,		2,		2,
	ADD8,		IMMEDIATE,	B_REG,		2,		2,
	LD16,		IMMEDIATE,	D_REG,		3,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,
	LD16,		IMMEDIATE,	U_REG,		3,		3,
	ILLEGAL,	NO_MODE,	NO_REG,	   _F,	    1,

	/* D0 */
	SUB8,		DIRECT,		B_REG,		4,		2,
	CMP8,		DIRECT,		B_REG,		4,		2,
	SBC,		DIRECT,		B_REG,		4,		2,
	ADD16,		DIRECT,		D_REG,		6,		2,
	AND,		DIRECT,		B_REG,		4,		2,
	BIT,		DIRECT,		B_REG,		4,		2,
	LD8,		DIRECT,		B_REG,		4,		2,
	ST8,		DIRECT,		B_REG,		4,		2,

	/* D8 */
	EOR,		DIRECT,		B_REG,		4,		2,
	ADC,		DIRECT,		B_REG,		4,		2,
	OR,			DIRECT,		B_REG,		4,		2,
	ADD8,		DIRECT,		B_REG,		4,		2,
	LD16,		DIRECT,		D_REG,		5,		2,
	ST16,		DIRECT,		D_REG,		5,		2,
	LD16,		DIRECT,		U_REG,		5,		2,
	ST16,		DIRECT,		U_REG,		5,		2,

	/* E0 */
	SUB8,		INDEXED,	B_REG,		4,		2,
	CMP8,		INDEXED,	B_REG,		4,		2,
	SBC,		INDEXED,	B_REG,		4,		2,
	ADD16,		INDEXED,	D_REG,		6,		2,
	AND,		INDEXED,	B_REG,		4,		2,
	BIT,		INDEXED,	B_REG,		4,		2,
	LD8,		INDEXED,	B_REG,		4,		2,
	ST8,		INDEXED,	B_REG,		4,		2,

	/* E8 */
	EOR,		INDEXED,	B_REG,		4,		2,
	ADC,		INDEXED,	B_REG,		4,		2,
	OR,			INDEXED,	B_REG,		4,		2,
	ADD8,		INDEXED,	B_REG,		4,		2,
	LD16,		INDEXED,	D_REG,		5,		2,
	ST16,		INDEXED,	D_REG,		5,		2,
	LD16,		INDEXED,	U_REG,		5,		2,
	ST16,		INDEXED,	U_REG,		5,		2,

	/* F0 */
	SUB8,		EXTENDED,	B_REG,		5,		3,
	CMP8,		EXTENDED,	B_REG,		5,		3,
	SBC,		EXTENDED,	B_REG,		5,		3,
	ADD16,		EXTENDED,	D_REG,		7,		3,
	AND,		EXTENDED,	B_REG,		5,		3,
	BIT,		EXTENDED,	B_REG,		5,		3,
	LD8,		EXTENDED,	B_REG,		5,		3,
	ST8,		EXTENDED,	B_REG,		5,		3,

	/* F8 */
	EOR,		EXTENDED,	B_REG,		5,		3,
	ADC,		EXTENDED,	B_REG,		5,		3,
	OR,			EXTENDED,	B_REG,		5,		3,
	ADD8,		EXTENDED,	B_REG,		5,		3,
	LD16,		EXTENDED,	D_REG,		6,		3,
	ST16,		EXTENDED,	D_REG,		6,		3,
	LD16,		EXTENDED,	U_REG,		6,		3,
	ST16,		EXTENDED,	U_REG,		6,		3

};
