/* Video modes from Video 7 1024i card attached to Multisync II (or other
   multifrequency VGA monitor).  DOS only, since I don't know how to get
   the card into these modes from OS/2.  */

/* 90/07/04  Created, for Epsilon 5.0. */

#ifdef MSDOS

#include "include\eel.h"
#include "include\lowlevel.h"

/* From shell.e: */
int supercede_routine ();

/* From disp.e: */
char vga43;
/* End of from disp.e. */


short is_v7()
{
    m_regs.b.ah = 0x6f;
    m_regs.b.al = 0x00;
    do_interrupt(0x10, &m_regs);
    return (m_regs.b.bh == 'V' && m_regs.b.bl == '7') ? 1 : 0;
}


command is_it_v7()
{
    say ("Is%s video7 card.", is_v7() == 1 ? "" : " not");
}


short v7_set_mode(a,m)
{
    switch (a) {
    case 0:
	return 1;

    case 1:
	m_regs.b.ah = 0x6f;
	m_regs.b.al = 0x05;
	m_regs.b.bl = m;
	do_interrupt(0x10, &m_regs);
	return 1;

    case 2:
	return is_v7();
    }
}


short dsb_video_mode_80x25(active)
{
    if (is_v7())
	return v7_set_mode (active, 0x02);
    else
	return org_video_mode_80x25(active);
}

short video_mode_80x43(active)
{
    if (is_v7()) {
	if (vga43) 
	    return v7_set_mode (active, 0x40);
	else 
	    return 0;
    } else
	return org_video_mode_80x43(active);
}

short video_mode_132x25(active)
{
    return v7_set_mode (active, 0x41);
}

short video_mode_132x43(active)
{
    return v7_set_mode (active, 0x42);
}

short video_mode_80x60(active)
{
    return v7_set_mode (active, 0x43);
}

short video_mode_100x60(active)
{
    return v7_set_mode (active, 0x44);
}

short video_mode_132x28(active)
{
    return v7_set_mode (active, 0x45);
}

when_loading()
{
    /* Say its not ok to use 43-line mode in addition to 50-line modes.
       The card & monitor will handle it, but the font is no different
       from the 50-line font, so there's no advantage. */

    vga43 = 0;

    /* Supercede existing video modes. */

    load_commands ("super");

    supercede_routine ("video_mode_80x25", 
		       "org_video_mode_80x25",
		       "dsb_video_mode_80x25");

    supercede_routine ("video_mode_80x43", 
		       "org_video_mode_80x43",
		       "dsb_video_mode_80x43");
}

#endif
