/* 90/07/07  Updated for Epsilon 5.0. */


#include "include\eel.h"

/* From cmdline.e: */
int biggest_process;

/* From disp.e: */
command set_show_graphic();

/* From load.e: */
char prev_byte_name[80];

/* From proc.e: */
char ignore_error[70];

/* From prog.e: */
short near_pause;
short far_pause;

/* From super.e: */
int supercede_routine ();

/* Declare and create a keytable for ^T (also F9). */

keytable ct_tab;

/* Declare a bunch of commands for remapping. */

command apropos();
command argument();
command bind_to_key();
command bufed();
command cd();
command change_modified();
command compare_windows();
command copy_to_file();
command copy_filename();
command describe_command();
command diff();
command dired();
command end_kbd_macro();
command exchange_point_and_mark();
command find_file();
command goto_line();
command goto_tag();
command insert_file();
command last_kbd_macro();
command load_bytes();
command named_command();
command name_kbd_macro();
command next_error();
command next_video();
command pluck_tag();
command push();
command query_replace();
command redo();
command redo_changes();
command replace_string();
command save_all_buffers();
command set_mark();
command set_show_graphic();
command set_variable();
command set_video();
command show_variable();
command start_kbd_macro();
command start_process();
command transpose_characters();
command transpose_lines();
command undo();
command undo_changes();
command visit_file();
command what_is();
command where_is();
command write_region();


/* Replacement for (control.e)make_prompt fixes up the table_keys if the
   function key prefixes F-9 = C-T or F-10 = C-X were hit.  They appear as
   F-9 and F-10 respectively without this fix.  (Depends, of course, on
   the bindings to be made later in this file.) */

make_prompt(s)	/* put prompt in s based on key tables seen so far */
char *s;
{
    int i;
    short c;
	
    if (has_arg)
	sprintf(s, "%d ", iter);
    else
	*s = 0;
    for (i = 0; i < table_count; i++) {
	c = table_keys[i];
	if (i == 0) {
	    if      (c == FKEY( 9)) c = CTRL('T');
	    else if (c == FKEY(10)) c = CTRL('X');
	}
	show_char(s, c);
	strcat(s, " ");
    }
}


/* Use c-mode as the default mode for resource (Windows & PM) files */
suffix_rc ()	{ c_mode(); }
suffix_rch ()	{ c_mode(); }


/* Debugging only:  Display memory status on startup in buffer main. */
command memory_avail ()
{
    char *orig = bufname;
    char *temp = temp_buf();

    bufname = temp;

    bprintf ("Memory status.\n\n");
    bprintf ("biggest_process:\t%d\n",	biggest_process);
    bprintf ("availmem:\t\t%d\n",	availmem);
    bprintf ("mem_in_use:\t\t%d\n",	mem_in_use);
    bprintf ("maxmem:\t\t\t%d\n",	maxmem);
    bprintf ("minmem:\t\t\t%d\n",	minmem);
    bprintf ("emsmem:\t\t\t%d\n",	emsmem);

    bufname = orig;
    view_buffer (temp);
    delete_buffer(temp);
}


command dsb_set_fill_column()
{
    org_set_fill_column();
    make_mode();
}


/* This command will move the cursor to the end of the line.  If
   already at the end of the line it will move the cursor to the end
   of the window.  If at the end of a window, it will move it to the
   end of the buffer.  This function emulates the behavior of the
   BRIEF (tm) editor's End key. */
command end_key()
{
	iter = 0;
	if (curchar() != '\n')
		to_end_line();
	else if (point != window_end)
		point = window_end;
	else if (point != size())
		point = size();
}


/* This command will move the cursor to the beginning of the line.
   If already at the beginning of the line, it will move it to the
   beginning of the window.  If already at the beginning of the window,
   it will move it to the beginning of the buffer.  This function emulates
   the Home key of the BRIEF (tm) editor. */
command home_key()
{
	iter = 0;
	if (current_column() != 0)
		to_begin_line();
	else if (point != window_start)
		point = window_start;
	else if (point != 0)
		point = 0;
}   /* of function home_key */


/* Scroll the buffer in the next window. */
/* Should there be two commands, one to scroll up and one to scroll down?
   Or should the argument (maybe the existence of the argument) control
   the direction? */

command scroll_other_window()
{
	window_number++;
	if (has_arg)
		previous_page ();
	else
		next_page ();
	window_number--;
}


/* Similar to (proc.e)make() */
/* Saves (all) buffer, and then runs eel on the file the buffer is visiting.*/
command compile_buffer()
{
	char eel_cmd[120];
	int err = 0;

	/* Command is :  eel filename */
	strcpy (eel_cmd, "eel ");
	strcat (eel_cmd, filename);
	maybe_save_all();
	if (no_running()) {		/* goes to end of proc buffer */
		if (error_spot)
			*error_spot = point;
		bprintf("%s\n", eel_cmd);
		iter = 1;
		delay(-1, COND_PROC | COND_KEY);
		if (!another || !process_input())
			return;		/* else assume it's compiled */
	} else
		err = do_push(eel_cmd, 1, 0);
	if (!do_next_error(1) && err)
		say("Process returned %d", err);
	iter = 0;
}

/* Does a find file, but in another window.  Splits the only window if
   necessary. */
command find_file_other_window()
{
	char fname[FNAMELEN];

	/* From (file.e)find_file: */
	iter = 0;
	get_file_dir(fname, "Find file (other window): ", filename);

	/* Make sure a valid filename was entered: */
	if (fname[0] == '\0' || strcmp(filename, fname) == 0) return;
	
	/* Now move to another window or split the windows: */
	if (number_of_windows() == 1) {
		window_split(HORIZONTAL);
		window_number = 1;
	} else {
		int nw = window_number + 1;
		if (nw == number_of_windows()) nw = 0;
		window_number = nw;
	}

	/* Move to the file's buffer or read the file: */
	find_it (fname, !has_arg);
}


/* Similar to (load.e)load_bytes */
/* Load the bytecode file which corresponds to the eel file in the current
   buffer. */
command load_eel_buffer()
{
	char fname[80], rel[80];
	strcpy(fname, filename);
	strcpy(get_extension(fname), byte_extension);
	load_commands(fname);
	relative(fname, rel);
	say("%s loaded.", rel);
	iter = 0;
}

/* Put the current memory status in the echo area. */
command memory_status()
{
	say("%d bytes available, %d bytes in use.", availmem, mem_in_use);
}

/* Executed by Epsilon automatically when it is just getting started. */
dsb_start_up ()
{
    org_start_up();
    prev_byte_name[0] = 0;  /* Clear remnants of saving the state */
    say (" ");              /* Set colors in minibuffer line */
    /* debug_memory_avail(); */
}

/* Executed by Epsilon automatically when it is going away. */
dsb_finish_up ()
{
    int i;

    org_finish_up();

    try_calling ("finish_up_cursor");

    /* Restore colors before leaving; for some reason Epsilon doesn't 
       do it. */

    for (i = 0; i < NUMCOLORS; i++)
	alter_color (i, COLOR(colWHITE, colBLACK));

    term_clear();
}


when_loading ()
{
    int i;
    
    load_commands ("super");

    supercede_routine ("set_fill_column",
		       "org_set_fill_column",
		       "dsb_set_fill_column");

    supercede_routine ("start_up",
		       "org_start_up",
		       "dsb_start_up");

    supercede_routine ("finish_up",
		       "org_finish_up",
		       "dsb_finish_up");

    /* Set reasonable colors */

    colors[0] = COLOR(colBLACK, colWHITE);		/* Normal text */
    colors[1] = COLOR(colWHITE, colBLACK);		/* Echo area */
    colors[2] = COLOR(colINTENSE+colBROWN, colBROWN);	/* Mode line */
    colors[3] = COLOR(colINTENSE+colBROWN, colBROWN);	/* Horiz border */
    colors[4] = COLOR(colINTENSE+colBROWN, colBROWN);	/* Vertical border */
    colors[5] = COLOR(colBLACK, colCYAN);		/* More-mode text */

    for (i = 0; i < NUMCOLORS; i++)
	alter_color (i, colors[i]);
	
    /* Set some variables */
    biggest_process		= 300000;
    capture_output		= 1;
    clear_process_buffer	= 1;
    Closeback			= 1;
    diff_match_lines		= 2;
    far_pause			= 50;
    Matchdelim			= 1;
    near_pause			= 25;
    kill_buffers		= 5;
    resynch_match_chars		= 10;
    save_when_making		= 1;
    scroll_at_end		= 1;
    shell_shrinks		= 1;
    Topindent			= 1;
    want_auto_save		= 0;
    want_bell			= 0;
    window_bordered		= 1;

    display_characters[0]	= 0xB3;		/* vertical border */
    display_characters[1]	= 0xC4;		/* horizontal border */
    display_characters[2]	= 0x19;		/* continuation */
    display_characters[3]	= 0x00;
    
    /* Microsoft C 5.1 warning messages to be ignored:
       C4011:  identifier truncated to 'identifier'
       C4060:  conversion of long address to short address
       C4069:  conversion of near pointer to long integer
    */
    strcpy(ignore_error, ".*C40(11|60|69).*");

    auto_fill_indents.default	= 1;
    auto_indent.default		= 1;
    case_fold.default		= 1;
    c_indent.default		= 4;
    delete_hacking_tabs.default	= 1;
    indent_with_tabs.default	= 1;
    margin_right.default	= 68;
    undo_size.default		= 100000;
    want_backups.default	= 0;

    /* Show PC line drawing set instead of M-? */
    has_arg = 1;
    iter = 1;
    set_show_graphic();

    load_commands ("cursor");
    load_commands ("ff");
    load_commands ("shell");
    load_commands ("v7video");

    /* Bind some function keys. */
    reg_tab[CTRL('T')] = find_index("ct-tab");
    ct_tab [CTRL('T')] = (short) transpose_characters;

    reg_tab[FKEY(   1)] = (short) help;
    reg_tab[FCTRL(  1)] = (short) what_is;
    reg_tab[FALT(   1)] = (short) where_is;
    cx_tab [FKEY(   1)] = (short) describe_command;
    ct_tab [FKEY(   1)] = (short) apropos;
    
    reg_tab[FKEY(   2)] = (short) set_mark;
    reg_tab[FCTRL(  2)] = (short) goto_tag;
    reg_tab[FALT(   2)] = (short) pluck_tag;
    cx_tab [FKEY(   2)] = (short) goto_line;
    ct_tab [FKEY(   2)] = (short) copy_filename;
    
    reg_tab[FKEY(   3)] = (short) start_kbd_macro;
    reg_tab[FCTRL(  3)] = (short) insert_file;
    reg_tab[FALT(   3)] = (short) copy_to_file;
    cx_tab [FKEY(   3)] = (short) write_region;
    ct_tab [FKEY(   3)] = (short) end_kbd_macro;
    
    reg_tab[FKEY(   4)] = (short) last_kbd_macro;
    reg_tab[FCTRL(  4)] = (short) set_show_graphic;
    reg_tab[FALT(   4)] = (short) next_video;
    cx_tab [FKEY(   4)] = (short) set_video;
    ct_tab [FKEY(   4)] = (short) name_kbd_macro;
    
    reg_tab[FKEY(   5)] = (short) undo;
    reg_tab[FCTRL(  5)] = (short) change_modified;
    reg_tab[FALT(   5)] = (short) save_all_buffers;
    reg_tab[FSHIFT( 5)] = (short) undo_changes;
    cx_tab [FKEY(   5)] = (short) visit_file;
    ct_tab [FKEY(   5)] = (short) redo;
    ct_tab [FSHIFT( 5)] = (short) redo_changes;
    
    reg_tab[FKEY(   6)] = (short) cd;
    reg_tab[FCTRL(  6)] = (short) bufed;
    reg_tab[FALT(   6)] = (short) 0; /* stated would go here */
    cx_tab [FKEY(   6)] = (short) dired;
    ct_tab [FKEY(   6)] = (short) push;
    
    reg_tab[FKEY(   7)] = (short) named_command;
    reg_tab[FCTRL(  7)] = (short) compile_buffer;
    reg_tab[FALT(   7)] = (short) load_eel_buffer;
    cx_tab [FKEY(   7)] = (short) bind_to_key;
    ct_tab [FKEY(   7)] = (short) load_bytes;
    
    reg_tab[FKEY(   8)] = (short) argument;
    reg_tab[FCTRL(  8)] = (short) start_process;
    reg_tab[FALT(   8)] = (short) 0;
    cx_tab [FKEY(   8)] = (short) replace_string;
    ct_tab [FKEY(   8)] = (short) query_replace;
    
    reg_tab[FKEY(   9)] = find_index ("ct-tab");
    reg_tab[FCTRL(  9)] = (short) diff;
    reg_tab[FALT(   9)] = (short) find_file;
    reg_tab[FSHIFT( 9)] = (short) set_variable;
    cx_tab [FKEY(   9)] = (short) transpose_lines;
    ct_tab [FKEY(   9)] = (short) next_error;
    
    reg_tab[FKEY(  10)] = find_index ("cx-tab");
    reg_tab[FCTRL( 10)] = (short) compare_windows;
    reg_tab[FALT(  10)] = (short) find_file_other_window;
    reg_tab[FSHIFT(10)] = (short) show_variable;
    cx_tab [FKEY(  10)] = (short) exchange_point_and_mark;
    ct_tab [FKEY(  10)] = (short) scroll_other_window;

    /* Make ^X-F be find-file, not set-fill-column. */
    cx_tab['f']         = (short) find_file;

    /* Don't let ^X^C run exit.  (You can use F10 ^C if you really
       want exit, but in fact I never use anything but ^X^Z.) */
    cx_tab[CTRL('c')]   = (short) 0;

    ct_tab ['=']        = (short) memory_status;
    ct_tab ['?']        = (short) memory_avail;
    reg_tab[KEYHOME]    = (short) home_key;
    reg_tab[KEYEND]     = (short) end_key;

    /* Space in bufed will advance to next line, not goto buffer. */
    bufed_tab[' ']      = (short) down_line;

    do_save_state ("dsbakin");
}
