/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*									*
*  Copyright (C) 1985, 1990 Lugaru Software Ltd.  All rights reserved.	*
*									*
* Limited permission is hereby granted to reproduce and modify this	*
* copyrighted material provided that the resulting code is used only in	*
* conjunction with Lugaru products and that this notice is retained in	*
* any such reproduction or modification.				*
*************************************************************************
* Modified by David S. Bakin:  OS/2 set_cursor.                         *
* 90/07/07:  Updated for Epsilon 5.0.                                   *
************************************************************************/



#include "include\eel.h"
#include "include\lowlevel.h"

/* From super.e: */
int supercede_routine ();

char prev_over_mode = -1;

#ifdef OS2
struct CursorData OriginalCursorData;
#endif

/* Modified from disp.e. */
make_mode()
{
	if (prev_over_mode != over_mode)
		set_cursor(over_mode);
	prev_over_mode = over_mode;
	strcpy(mode, major_mode);
	if (fill_mode) {
		char fw[15];
		sprintf(fw, " Fill %d", margin_right);
		strcat(mode, fw);
	}
	if (over_mode)
		strcat(mode, " Over");
	if (in_rectangle_mode)
		strcat(mode, " Rect");
	if (strip_returns != strip_returns.default)
		strcat(mode, strip_returns ? " Trans" : " NoTrans");
	if (narrow_start > 0 || narrow_end > 0)
		strcat(mode, " Narrow");
	if (len_def_mac)
		strcat(mode, " Def");
}

/* Call the following from your finish_up routine in order to clean up
   the cursor when leaving Epsilon: */
finish_up_cursor()
{
	set_cursor(0);
}

set_cursor(over)
{
#ifdef OS2
	struct CursorData cd;
	/* Overlay mode:  Set the cursor start to 0.
	   Insert mode:   Set the cursor to the original cursor.
	*/
	cd.cur_start	 = over ? 0 : OriginalCursorData.cur_start;
	cd.cur_end	 = OriginalCursorData.cur_end;
	cd.cur_width	 = OriginalCursorData.cur_width;
	cd.cur_attribute = OriginalCursorData.cur_attribute;
	
	os2call("VIOCALLS", 0, "VIOSETCURTYPE",
		3 /* # words of argument */,
		get_pointer(&cd, SEGMENT),
		get_pointer(&cd, !SEGMENT),
		0 /* VIO handle */,
		0, 0 /* two placeholders */);
#endif
#ifdef MSDOS
	m_regs.w.cx = over ? 0x0007 : 0x0607;
	vid_int(0x100);
#endif
}


/* Fixup mode line, which has the side effect of setting the cursor
   properly, whenever the window is changed. */

command dsb_next_window()
{
    org_next_window();
    make_mode();
}

command dsb_previous_window()
{
    org_previous_window();
    make_mode();
}

command dsb_kill_window()
{
    org_kill_window();
    make_mode();
}

when_loading()
{
    load_commands ("super");

    supercede_routine ("next_window", 
		       "org_next_window",
		       "dsb_next_window");
    supercede_routine ("previous_window",
		       "org_previous_window",
		       "dsb_previous_window");
    supercede_routine ("kill_window",
		       "org_kill_window",
		       "dsb_kill_window");

#ifdef OS2
    /* This isn't right:  It shouldn't be during when_loading, but more of a 
       during when_restoring(). */
    /* Get the original cursor value */
    os2call("VIOCALLS", 0, "VIOGETCURTYPE",
	    3 /* # words of argument */,
	    get_pointer(&OriginalCursorData, SEGMENT),
	    get_pointer(&OriginalCursorData, !SEGMENT),
	    0 /* VIO handle */,
	    0, 0 /* two placeholders */);
#endif
}
