/****************************************************************************
*
*	Program Name : WI_GEN.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
*
*       This program generates wi which is the number of minterms adjacent to
*	mi that are in CPT but not in the given boolean function where mi is
* 	a term adjacent to the minterm of interest.
*
*	Returns wi, no. of adjacent terms of mi in e-array but not in a-array
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
*
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

unsigned char   adj_of_mi(mi, e, a)
unsigned char   *mi, *e, *a;

{
   unsigned short    ma;
   unsigned long     me, topow();
   unsigned char     j, nspm, n, i, wi, *adjterm;
   char              test;

   n = *a;                                   /* no. of variables */
   nspm = *(a+3);                            /* no. of bytes/minterm */
   ma = *(a+2)<<8 | *(a+1);                  /* no. of minterms in a-array */

   me = topow(*(e+1));                       /* no. of minterms in e-array */

   adjterm = (unsigned char *) malloc(nspm+1);        /* temporary storage */
   if (adjterm == 0)
      {
	 printf("Out of memory -- WI_GEN, *adjterm\n");
	 printf("Program terminated - 1\n");
	 exit(0);
      }

   wi = 0;                             /* reset to zero */

   for (i=0; i<n; i++)                 /* generate possible adj terms to mi */
      {
	 for (j=0; j<nspm; j++)        /* byte operation for nspm>1 */
	    {
	       if ((i/8) == j)
		  *(adjterm + j) = *(mi + j) ^ (1<<(i%8));   /* XOR */
	       else
		  *(adjterm + j) = *(mi + j);
	    }

	 test = exist(adjterm, e, me);       /* present in e-array ? */
	 if (test == 0)                      /* YES */
	    {
	       test = exist(adjterm, a, ma);       /* present in a-array ? */
	       if (test == -1)                     /* NO */
		  wi++;                            /* increment wi */
	    }
      }
   free(adjterm);                            /* free pointer */

   return(wi);    			     /* return wi */
}