/******************************************************************************
 *
 *	Program Name : REDUCE.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program removes the same minterms that are in array-c from
 *	that in the b-array. The b-array is then shrinked.
 *
 *	Returns pointer to an array consisting of :
 *		1.	index pointer to the b-array, i
 *		2.      the reduced b-array
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define   mask8 255

unsigned char      *reduce(c, b, pos)
unsigned short     pos;
unsigned char      *b, *c;

{
   unsigned short  mb, samepos, adj, i, j;
   unsigned char   nspm;
   int             test;

   adj = *(c+2)<<8 | *(c+1);            /* no. of adj terms or (SSM terms-1) */
   nspm = *(b+3);                       /* no. of storage/minterm */
   mb = *(b+2)<<8 | *(b+1);             /* no. of ON minterm */
   samepos = 0;                         /* an indicator */

   for (i=0; i<=adj; i++)               /* do for all minterms in c-array */
      {
	 for (j=0; j<mb; j++)           /* do for all minterms in b-array */
	    {
	       test = memcmp((b+4+nspm*j),(c+4+nspm*i),nspm); /* present ? */

	       if (test==0)     /* minterm in c-array present in b-array */
		  {
		     memcpy((b+4+nspm*j),(b+4+nspm*(j+1)),(mb-1-j)*nspm);  /* remove minterm */

		     b = (unsigned char *) realloc (b, 4+nspm*mb);  /* reduce space in b */
		     if (b==0)
			{
			   printf("Out of memory -- REDUCE, *b\n");
			   printf("Program terminated - 1 \n");
			   exit(0);
			}
		     mb--;                 /* no. of minterms in b-array */

		     if (j<pos)
			pos--;             /* decrement index pointer */
		     if (j==pos)
			samepos++;         /* an indicator */

		     break;
		  }
	    }
	}
     *(b+1) = mb & mask8;    /* reduced no. of minterms */
     *(b+2) = mb>>8;

     if (samepos>0)         /* indicator is true */
	*b = pos-1;         /* index pointer returned */
     else
	*b = pos;           /* index pointer of b-array, next i */
     return (b);            /* return reduced b-array */
}



